/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.ConfigurationContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SmartConfiguration;
import com.baan.owimpl.fw.ccf.impl.ConfigurationData;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.sun.jndi.misc.BASE64Decoder;
import com.sun.jndi.misc.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public abstract class SmartContext
extends ConfigurationContext {
    private static final ILogger s_logger;
    private static final String PROP_USER = "user.name";
    private static final String PROP_APP = "ow.app.name";
    private static final String DEFAULT = "_default_";
    private static final String CN_DEFAULT = "cn=_default_";
    private static final String s_machine;
    private static final String s_user;
    private static final String s_application;
    private static BASE64Decoder s_decoder;
    private static BASE64Encoder s_encoder;
    private Constructor m_constructor = null;
    static /* synthetic */ Class class$java$lang$String;

    protected SmartContext(Class clazz) throws OWConfigurationException {
        super(clazz);
        try {
            this.m_constructor = this.getConfigurationClass().getConstructor(this.getClass(), class$java$lang$String == null ? (class$java$lang$String = SmartContext.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SmartContext.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SmartContext.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
        }
        catch (Exception exception) {
            throw new OWConfigurationException("Configuration class " + this.getConfigurationClass() + " has invalid constructor " + exception);
        }
    }

    public abstract SmartConfiguration createConfiguration(String var1, String var2, String var3) throws OWConfigurationException;

    protected SmartConfiguration createConfiguration(String string, String string2, String string3, int n) throws OWConfigurationException {
        s_logger.flowMessage("Create smart configuration for " + string + "," + string2 + "," + string3);
        s_logger.flowMessage("Version: " + n);
        SmartConfiguration smartConfiguration = this.searchConfiguration(string, string2, string3);
        if (smartConfiguration.m_configurationData.getVersion() == n) {
            return this.copyConfiguration(smartConfiguration, string, string2, string3);
        }
        ConfigurationData configurationData = new ConfigurationData(n);
        return this._createSmart(configurationData, string, string2, string3, true);
    }

    public SmartConfiguration createDefaultConfiguration(int n) throws OWConfigurationException {
        s_logger.flowMessage("Create default smart configuration");
        s_logger.flowMessage("Version: " + n);
        ConfigurationData configurationData = new ConfigurationData(n);
        return this._createSmart(configurationData, DEFAULT, DEFAULT, DEFAULT, true);
    }

    public void removeConfiguration(String string, String string2, String string3) throws OWConfigurationException {
        if (string == null || string.length() == 0) {
            string = DEFAULT;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = DEFAULT;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = DEFAULT;
        }
        boolean bl = true;
        if (string3.equals(DEFAULT) && string2.equals(DEFAULT) && string.equals(DEFAULT)) {
            s_logger.flowMessage("Trying to remove default configuration");
            boolean bl2 = true;
            try {
                this.getConfiguration(DEFAULT, DEFAULT, DEFAULT);
            }
            catch (OWConfigurationException oWConfigurationException) {
                s_logger.flowMessage("Invalid default configuration, allowed to remove it");
                bl2 = false;
                bl = false;
            }
            if (bl2) {
                s_logger.flowMessage("Not allowed to remove default configuration");
                throw new OWConfigurationException("Cannot remove default Configuration");
            }
        }
        try {
            s_logger.flowMessage("Remove smart configuration for " + string + "," + string2 + "," + string3);
            Context context = this.m_configType;
            Context context2 = (Context)context.lookup("cn=" + string);
            Context context3 = (Context)context2.lookup("cn=" + string2);
            if (bl) {
                context3.lookup("cn=" + string3);
            }
            s_logger.flowMessage("Remove application node " + string3);
            context3.unbind("cn=" + string3);
            NamingEnumeration<NameClassPair> namingEnumeration = context3.list("");
            if (!namingEnumeration.hasMore()) {
                s_logger.flowMessage("Remove user node " + string2);
                context2.unbind("cn=" + string2);
            }
            if (!(namingEnumeration = context2.list("")).hasMore()) {
                s_logger.flowMessage("Remove machine node " + string);
                context.unbind("cn=" + string);
            }
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public SmartConfiguration searchConfiguration(String string, String string2, String string3) throws OWConfigurationException {
        s_logger.flowMessage("Search smart configuration for " + string + "," + string2 + "," + string3);
        return this.construct(string, string2, string3, true);
    }

    public SmartConfiguration searchConfiguration() throws OWConfigurationException {
        s_logger.flowMessage("Search smart configuration for " + s_machine + "," + s_user + "," + s_application);
        return this.construct(s_machine, s_user, s_application, true);
    }

    public SmartConfiguration getConfiguration(String string, String string2, String string3) throws OWConfigurationException {
        s_logger.flowMessage("Get smart configuration for " + string + "," + string2 + "," + string3);
        return this.construct(string, string2, string3, false);
    }

    public SmartConfiguration getConfiguration() throws OWConfigurationException {
        s_logger.flowMessage("Get smart configuration for " + s_machine + "," + s_user + "," + s_application);
        return this.construct(s_machine, s_user, s_application, false);
    }

    public SmartConfiguration copyConfiguration(SmartConfiguration smartConfiguration, String string, String string2, String string3) throws OWConfigurationException {
        s_logger.flowMessage("Copy configuration for smart " + smartConfiguration + " to " + string + "-" + string2 + "-" + string3);
        ConfigurationData configurationData = new ConfigurationData(smartConfiguration.m_configurationData);
        return this._createSmart(configurationData, string, string2, string3, true);
    }

    protected SmartConfiguration construct(String string, String string2, String string3, boolean bl) throws OWConfigurationException {
        try {
            return (SmartConfiguration)this.m_constructor.newInstance(this, string, string2, string3, new Boolean(bl));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new OWConfigurationException("Constructing " + this.getConfigurationClass() + " failed " + invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new OWConfigurationException("Constructing " + this.getConfigurationClass() + " failed " + exception);
        }
    }

    private SmartConfiguration _createSmart(ConfigurationData configurationData, String string, String string2, String string3, boolean bl) throws OWConfigurationException {
        try {
            if (string == null || string.length() == 0) {
                string = DEFAULT;
            }
            if (string2 == null || string2.length() == 0) {
                string2 = DEFAULT;
            }
            if (string3 == null || string3.length() == 0) {
                string3 = DEFAULT;
            }
            ConfigurationContext.validateName(string);
            ConfigurationContext.validateName(string2);
            ConfigurationContext.validateName(string3);
            Context context = null;
            try {
                context = (Context)this.m_configType.lookup("cn=" + string);
            }
            catch (NamingException namingException) {
                context = this.m_configType.createSubcontext("cn=" + string);
            }
            try {
                context = (Context)context.lookup("cn=" + string2);
            }
            catch (NamingException namingException) {
                context = context.createSubcontext("cn=" + string2);
            }
            try {
                context.bind("cn=" + string3, (Object)configurationData);
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                throw new OWConfigurationException("Object '" + string + "-" + string2 + "-" + string3 + "' already exists");
            }
            return this.construct(string, string2, string3, false);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public String[] listMachines() throws OWConfigurationException {
        try {
            s_logger.flowMessage("list machines");
            NamingEnumeration<NameClassPair> namingEnumeration = this.m_configType.list("");
            return ConfigurationContext.getNameArray(namingEnumeration);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public String[] listUsers(String string) throws OWConfigurationException {
        try {
            if (string == null || string.length() == 0) {
                string = DEFAULT;
            }
            s_logger.flowMessage("list users for " + string);
            Context context = (Context)this.m_configType.lookup("cn=" + string);
            NamingEnumeration<NameClassPair> namingEnumeration = context.list("");
            return ConfigurationContext.getNameArray(namingEnumeration);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public String[] listApplications(String string, String string2) throws OWConfigurationException {
        try {
            if (string == null || string.length() == 0) {
                string = DEFAULT;
            }
            if (string2 == null || string2.length() == 0) {
                string2 = DEFAULT;
            }
            s_logger.flowMessage("list application for " + string + "-" + string2);
            Context context = (Context)this.m_configType.lookup("cn=" + string);
            Context context2 = (Context)context.lookup("cn=" + string2);
            NamingEnumeration<NameClassPair> namingEnumeration = context2.list("");
            return ConfigurationContext.getNameArray(namingEnumeration);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public String export(String string, String string2, String string3) throws OWConfigurationException {
        s_logger.flowMessage("Export configuration for M=" + string + ", U=" + string2 + ", A=" + string3);
        try {
            ConfigurationData configurationData = this.getConfiguration((String)string, (String)string2, (String)string3).m_configurationData;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(configurationData);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return s_encoder.encodeBuffer(byArray);
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            throw new OWConfigurationException("Error Exporting '" + this + "'\nwith M=" + string + ", U=" + string2 + ", A=" + string3);
        }
    }

    public void _import(String string, String string2, String string3, String string4, boolean bl) throws OWConfigurationException {
        block9: {
            s_logger.flowMessage("Import configuration for M=" + string + ", U=" + string2 + ", A=" + string3);
            try {
                byte[] byArray = s_decoder.decodeBuffer(string4);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = objectInputStream.readObject();
                ConfigurationData configurationData = (ConfigurationData)object;
                objectInputStream.close();
                Context context = null;
                try {
                    context = (Context)this.m_configType.lookup("cn=" + string);
                }
                catch (NamingException namingException) {
                    context = this.m_configType.createSubcontext("cn=" + string);
                }
                try {
                    context = (Context)context.lookup("cn=" + string2);
                }
                catch (NamingException namingException) {
                    context = context.createSubcontext("cn=" + string2);
                }
                try {
                    context.bind("cn=" + string3, (Object)configurationData);
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                    if (bl) {
                        s_logger.flowMessage("Configuration for M=" + string + ", U=" + string2 + ", A=" + string3 + " already exist, replacing it");
                        context.rebind("cn=" + string3, (Object)configurationData);
                        break block9;
                    }
                    s_logger.flowMessage("Configuration for M=" + string + ", U=" + string2 + ", A=" + string3 + " already exist, not replaced, import ignored");
                }
            }
            catch (Exception exception) {
                s_logger.errorException(exception);
                throw new OWConfigurationException("Error Importing " + this + "'\nfor M=" + string + ", U=" + string2 + ", A=" + string3);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        s_logger = LoggerFactory.createLogger("com.baan.owimpl.fw.ccf", "SmartContext");
        s_decoder = new BASE64Decoder();
        s_encoder = new BASE64Encoder();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
            int n = string.indexOf(".");
            if (n > 0) {
                string = string.substring(0, n);
            }
        }
        catch (UnknownHostException unknownHostException) {
            string = null;
        }
        s_machine = string;
        s_application = System.getProperty(PROP_APP);
        s_user = System.getProperty(PROP_USER);
    }
}

