/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.Configuration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SmartContext;
import com.baan.owimpl.fw.ccf.impl.ConfigurationData;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.io.PrintStream;
import javax.naming.Context;
import javax.naming.NamingException;

public abstract class SmartConfiguration
extends Configuration {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.fw.ccf", "SmartConfiguration");
    private static final String DEFAULT = "_default_";
    private static final String CN_DEFAULT = "cn=_default_";
    private String m_orgMachine = null;
    private String m_orgUser = null;
    private String m_orgApplication = null;
    private String m_machine = null;
    private String m_user = null;
    private String m_application = null;
    private boolean m_smart = false;

    protected SmartConfiguration(SmartContext smartContext, String string, String string2, String string3, boolean bl) throws OWConfigurationException {
        super(smartContext);
        if (string == null || string.length() == 0) {
            string = DEFAULT;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = DEFAULT;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = DEFAULT;
        }
        this.m_orgMachine = this.m_machine = string;
        this.m_orgUser = this.m_user = string2;
        this.m_orgApplication = this.m_application = string3;
        this.m_smart = bl;
        if (bl) {
            String[] stringArray = new String[]{"cn=" + this.m_application + "," + "cn=" + this.m_user + "," + "cn=" + this.m_machine, "cn=" + this.m_application + "," + "cn=" + this.m_user + "," + CN_DEFAULT, "cn=" + this.m_application + "," + CN_DEFAULT + "," + "cn=" + this.m_machine, "cn=" + this.m_application + "," + CN_DEFAULT + "," + CN_DEFAULT, "cn=_default_,cn=" + this.m_user + "," + "cn=" + this.m_machine, "cn=_default_,cn=" + this.m_user + "," + CN_DEFAULT, "cn=_default_,cn=_default_,cn=" + this.m_machine, "cn=_default_,cn=_default_,cn=_default_"};
            int n = 0;
            Context context = smartContext.m_configType;
            while (true) {
                try {
                    this.m_configurationData = (ConfigurationData)context.lookup(stringArray[n]);
                    this.m_configurationData.resetDirty();
                    s_logger.flowMessage("FOUND " + stringArray[n]);
                    if (n == 1 || n == 3 || n == 5 || n == 7) {
                        this.m_machine = DEFAULT;
                    }
                    if (n == 2 || n == 3 || n == 6 || n == 7) {
                        this.m_user = DEFAULT;
                    }
                    if (n != 4 && n != 5 && n != 6 && n != 7) break;
                    this.m_application = DEFAULT;
                }
                catch (NamingException namingException) {
                    s_logger.flowMessage("NOT FOUND " + stringArray[n]);
                    if (++n < stringArray.length) continue;
                }
                break;
            }
            if (n >= stringArray.length) {
                throw new OWConfigurationException("Object could not be found, there are no defaults, directory is not initialized");
            }
        } else {
            String string4 = "cn=" + this.m_application + "," + "cn=" + this.m_user + "," + "cn=" + this.m_machine;
            try {
                s_logger.flowMessage("getting " + string4);
                Context context = smartContext.m_configType;
                this.m_configurationData = (ConfigurationData)context.lookup(string4);
                this.m_configurationData.resetDirty();
            }
            catch (NamingException namingException) {
                s_logger.errorException(namingException);
                throw new OWConfigurationException("Object '" + string4 + "' could not be found");
            }
        }
    }

    public String getMachine() {
        return this.m_machine;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getApplication() {
        return this.m_application;
    }

    public void store() throws OWConfigurationException {
        try {
            s_logger.flowMessage("Store smart configuration for " + this);
            Context context = this.m_parent.m_configType;
            Context context2 = (Context)((Context)context.lookup("cn=" + this.m_machine)).lookup("cn=" + this.m_user);
            this.m_configurationData.touch();
            context2.rebind("cn=" + this.m_application, (Object)this.m_configurationData);
            this.m_configurationData.resetDirty();
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public void remove() throws OWConfigurationException {
        ((SmartContext)this.m_parent).removeConfiguration(this.m_machine, this.m_user, this.m_application);
    }

    protected void refresh() {
        block3: {
            if (this.isChanged()) break block3;
            try {
                SmartConfiguration smartConfiguration = ((SmartContext)this.m_parent).construct(this.m_orgMachine, this.m_orgUser, this.m_orgApplication, this.m_smart);
                if (!this.equals(smartConfiguration)) {
                    s_logger.flowMessage("Configuration changed for " + this);
                    this.m_configurationData = smartConfiguration.m_configurationData;
                    this.onConfigurationChanged();
                }
            }
            catch (OWConfigurationException oWConfigurationException) {}
        }
    }

    public String toString() {
        return this.m_machine + "-" + this.m_user + "-" + this.m_application;
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        Configuration.printProperty(printStream, "Machine", this.getMachine());
        Configuration.printProperty(printStream, "User", this.getUser());
        Configuration.printProperty(printStream, "Application", this.getApplication());
        Configuration.printProperty(printStream, "Last Modified", this.getModificationDate().toString());
        Configuration.printProperty(printStream, "Modified by", this.getModificationUser());
    }
}

