/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.Configuration;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SmartConfiguration;
import com.baan.owimpl.fw.ccf.dt.LogCategories;
import com.baan.owimpl.fw.ccf.dt.LogLevelEnum;
import com.baan.owimpl.fw.log.control.LogController;
import java.io.PrintStream;

public class LoggingConfiguration
extends SmartConfiguration {
    public static final int VERSION = 1;
    private static final String LOGFILENAME = "filename";
    private static final String LOGFILENAME_DEFAULT = "";
    private static final String PERPROCESS = "perprocess";
    private static final boolean PERPROCESS_DEFAULT = true;
    private static final String LEVEL = "level";
    private static final LogLevelEnum LEVEL_DEFAULT = LogLevelEnum.ERROR;
    private static final String CATEGORIES = "categories";
    private static final LogCategories CATEGORIES_DEFAULT = new LogCategories(Integer.MAX_VALUE);

    public LoggingConfiguration(LoggingContext loggingContext, String string, String string2, String string3, boolean bl) throws OWConfigurationException {
        super(loggingContext, string, string2, string3, bl);
    }

    public void storeDefaults() throws OWConfigurationException {
        this.setFileName(LOGFILENAME_DEFAULT);
        this.setPerProcess(true);
        this.setCategories(CATEGORIES_DEFAULT);
        this.setLevel(LEVEL_DEFAULT);
        this.store();
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        Configuration.printProperty(printStream, "Log Level", this.getLevel());
        Configuration.printProperty(printStream, "Categories", this.getCategories());
        String string = this.getFileName();
        if (string != null && string.length() > 0) {
            Configuration.printProperty(printStream, "Log File", string);
        } else {
            Configuration.printProperty(printStream, "Log File", "'" + string + "' (" + LogController.getLogFileName(string) + ")");
        }
        Configuration.printProperty(printStream, "Per process logging", this.getPerProcess() ? "enabled" : "disabled");
    }

    public LogLevelEnum getLevel() {
        Integer n = (Integer)this.m_configurationData.getProperty(LEVEL);
        return LogLevelEnum.getEnum(n);
    }

    public void setLevel(LogLevelEnum logLevelEnum) {
        this.m_configurationData.setProperty(LEVEL, new Integer(logLevelEnum.getValue()));
    }

    public String getFileName() {
        return (String)this.m_configurationData.getProperty(LOGFILENAME);
    }

    public void setFileName(String string) {
        this.m_configurationData.setProperty(LOGFILENAME, string);
    }

    public LogCategories getCategories() {
        Integer n = (Integer)this.m_configurationData.getProperty(CATEGORIES);
        return new LogCategories(n);
    }

    public void setCategories(LogCategories logCategories) {
        this.m_configurationData.setProperty(CATEGORIES, new Integer(logCategories.getValue()));
    }

    public boolean getPerProcess() {
        Boolean bl = (Boolean)this.m_configurationData.getProperty(PERPROCESS);
        return bl;
    }

    public void setPerProcess(boolean bl) {
        this.m_configurationData.setProperty(PERPROCESS, new Boolean(bl));
    }
}

