/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.ConfigurationContext;
import com.baan.owimpl.fw.ccf.IdentifierConfiguration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.impl.ConfigurationData;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.sun.jndi.misc.BASE64Decoder;
import com.sun.jndi.misc.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public abstract class IdentifierContext
extends ConfigurationContext {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$fw$ccf$IdentifierContext == null ? (class$com$baan$owimpl$fw$ccf$IdentifierContext = IdentifierContext.class$("com.baan.owimpl.fw.ccf.IdentifierContext")) : class$com$baan$owimpl$fw$ccf$IdentifierContext);
    private static BASE64Decoder s_decoder = new BASE64Decoder();
    private static BASE64Encoder s_encoder = new BASE64Encoder();
    private Constructor m_constructor = null;
    static /* synthetic */ Class class$com$baan$owimpl$fw$ccf$IdentifierContext;
    static /* synthetic */ Class class$java$lang$String;

    protected IdentifierContext(Class clazz) throws OWConfigurationException {
        super(clazz);
        try {
            this.m_constructor = this.getConfigurationClass().getConstructor(this.getClass(), class$java$lang$String == null ? (class$java$lang$String = IdentifierContext.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception exception) {
            throw new OWConfigurationException("Configuration class " + this.getConfigurationClass() + " has invalid constructor " + exception);
        }
    }

    public abstract IdentifierConfiguration createConfiguration(String var1) throws OWConfigurationException;

    protected IdentifierConfiguration createConfiguration(String string, int n) throws OWConfigurationException {
        try {
            s_logger.flowMessage("Create configuration for identifier " + string);
            s_logger.flowMessage("Version: " + n);
            ConfigurationContext.validateName(string);
            ConfigurationData configurationData = new ConfigurationData(n);
            this.m_configType.bind("cn=" + string, (Object)configurationData);
            return this.construct(string);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public void removeConfiguration(String string) throws OWConfigurationException {
        try {
            s_logger.flowMessage("Remove identifier configuration for " + string);
            Context context = this.m_configType;
            context.unbind("cn=" + string);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public IdentifierConfiguration getConfiguration(String string) throws OWConfigurationException {
        s_logger.flowMessage("Get configuration for identifier " + string);
        return this.construct(string);
    }

    public IdentifierConfiguration copyConfiguration(IdentifierConfiguration identifierConfiguration, String string) throws OWConfigurationException {
        try {
            s_logger.flowMessage("Copy configuration for identifier " + identifierConfiguration + " to " + string);
            ConfigurationContext.validateName(string);
            ConfigurationData configurationData = new ConfigurationData(identifierConfiguration.m_configurationData);
            this.m_configType.bind("cn=" + string, (Object)configurationData);
            return this.construct(string);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    protected IdentifierConfiguration construct(String string) throws OWConfigurationException {
        try {
            return (IdentifierConfiguration)this.m_constructor.newInstance(this, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof OWConfigurationException) {
                throw new OWConfigurationException(throwable.getMessage());
            }
            throw new OWConfigurationException("Constructing " + this.getConfigurationClass() + " failed " + invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new OWConfigurationException("Constructing " + this.getConfigurationClass() + " failed " + exception);
        }
    }

    public String[] list() throws OWConfigurationException {
        s_logger.flowMessage("list identifiers");
        if (this.m_configType == null) {
            return new String[0];
        }
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = this.m_configType.list("");
            return ConfigurationContext.getNameArray(namingEnumeration);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public String export(String string) throws OWConfigurationException {
        s_logger.flowMessage("Export configuration for identifier " + string);
        try {
            ConfigurationData configurationData = this.getConfiguration((String)string).m_configurationData;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(configurationData);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return s_encoder.encodeBuffer(byArray);
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            throw new OWConfigurationException("Error Exporting '" + this + "'\nwith id '" + string + "'");
        }
    }

    public void _import(String string, String string2, boolean bl) throws OWConfigurationException {
        block5: {
            s_logger.flowMessage("Import configuration for identifier " + string);
            try {
                byte[] byArray = s_decoder.decodeBuffer(string2);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = objectInputStream.readObject();
                ConfigurationData configurationData = (ConfigurationData)object;
                objectInputStream.close();
                try {
                    this.m_configType.bind("cn=" + string, (Object)configurationData);
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                    if (bl) {
                        s_logger.flowMessage("Configuration with id " + string + " already exists, replacing it");
                        this.m_configType.rebind("cn=" + string, (Object)configurationData);
                        break block5;
                    }
                    s_logger.flowMessage("Configuration with id " + string + " already exists, not replaced, import ignored");
                }
            }
            catch (Exception exception) {
                s_logger.errorException(exception);
                throw new OWConfigurationException("Error Importing '" + this + "'\nwith id '" + string + "'");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

