/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.Configuration;
import com.baan.owimpl.fw.ccf.IdentifierContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.impl.ConfigurationData;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.io.PrintStream;
import javax.naming.Context;
import javax.naming.NamingException;

public abstract class IdentifierConfiguration
extends Configuration {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.fw.ccf", "IdentifierConfiguration");
    private String m_identifier = null;

    protected IdentifierConfiguration(IdentifierContext identifierContext, String string) throws OWConfigurationException {
        super(identifierContext);
        this.m_identifier = string;
        try {
            Context context = identifierContext.m_configType;
            this.m_configurationData = (ConfigurationData)context.lookup("cn=" + this.m_identifier);
            this.m_configurationData.resetDirty();
        }
        catch (NamingException namingException) {
            s_logger.message("Cannot find '" + identifierContext + "' with id '" + string + "' " + namingException);
            throw new OWConfigurationException("Cannot find " + identifierContext + " with id '" + string + "' in the directory.");
        }
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public void store() throws OWConfigurationException {
        try {
            s_logger.flowMessage("Store identifier configuration for " + this);
            Context context = this.m_parent.m_configType;
            this.m_configurationData.touch();
            context.rebind("cn=" + this.m_identifier, (Object)this.m_configurationData);
            this.m_configurationData.resetDirty();
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public void remove() throws OWConfigurationException {
        ((IdentifierContext)this.m_parent).removeConfiguration(this.m_identifier);
    }

    protected void refresh() {
        block3: {
            if (this.isChanged()) break block3;
            try {
                IdentifierConfiguration identifierConfiguration = ((IdentifierContext)this.m_parent).construct(this.m_identifier);
                if (!this.equals(identifierConfiguration)) {
                    s_logger.flowMessage("Configuration changed for " + this);
                    this.m_configurationData = identifierConfiguration.m_configurationData;
                    this.onConfigurationChanged();
                }
            }
            catch (OWConfigurationException oWConfigurationException) {}
        }
    }

    public String toString() {
        return this.m_identifier;
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        Configuration.printProperty(printStream, "Identifier", this.getIdentifier());
        Configuration.printProperty(printStream, "Last Modified", this.getModificationDate().toString());
        Configuration.printProperty(printStream, "Modified by", this.getModificationUser());
    }
}

