/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.impl.DirectoryURL;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;

public class ConfigurationContext {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.fw.ccf", "ConfigurationContext");
    private Context m_rootNode = null;
    private Context m_configurationsNode = null;
    protected Context m_configType = null;
    private String m_URL = null;
    private Class m_configClass;
    private Boolean m_readOnly = null;
    protected static final String CN = "cn=";
    private static final String LDAP_JNDI_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String FILE_JNDI_FACTORY = "com.baan.ow.jndi.xml.XmlCtxFactory";
    private static final String CONFIGURATIONS_NAME = "cn=configurations";
    private static final String DUMMY_NAME = "cn=_dummy_";
    private static String s_directoryURL = DirectoryURL.get();
    private static String s_username = null;
    private static String s_password = null;

    public static void overrideDefaultDirectoryURL(String string) {
        s_directoryURL = string;
    }

    public static void setAuthenticationInfo(String string, String string2) {
        s_username = string;
        s_password = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationContext() throws OWConfigurationException {
        s_logger.flowMessage("Construct ConfigurationContext for root node");
        if (s_directoryURL == null || s_directoryURL.equals("")) {
            s_logger.errorMessage("No directory URL configured");
            throw new OWConfigurationException("No directory URL configured");
        }
        this.m_URL = s_directoryURL;
        try {
            s_logger.flowMessage("Connect to URL " + this.m_URL);
            Properties properties = new Properties();
            if (this.m_URL.startsWith("ldap:")) {
                ((Hashtable)properties).put("java.naming.factory.initial", LDAP_JNDI_FACTORY);
            } else {
                ((Hashtable)properties).put("java.naming.factory.initial", FILE_JNDI_FACTORY);
            }
            ((Hashtable)properties).put("java.naming.provider.url", this.m_URL);
            if (s_username != null) {
                ((Hashtable)properties).put("java.naming.security.principal", s_username);
                ((Hashtable)properties).put("java.naming.security.credentials", s_password);
            }
            this.m_rootNode = new InitialContext(properties);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                try {
                    this.m_configurationsNode = (Context)this.m_rootNode.lookup(CONFIGURATIONS_NAME);
                }
                catch (NamingException namingException) {
                    s_logger.flowMessage("cn=configurations not found, trying to create it");
                    this.m_configurationsNode = this.m_rootNode.createSubcontext(CONFIGURATIONS_NAME);
                }
            }
        }
        catch (CommunicationException communicationException) {
            s_logger.errorException(communicationException);
            throw new OWConfigurationException("Cannot connect to directory, check the URL: " + this.m_URL);
        }
        catch (NameNotFoundException nameNotFoundException) {
            s_logger.errorException(nameNotFoundException);
            throw new OWConfigurationException("Cannot find root object in directory, check the URL: " + this.m_URL);
        }
        catch (NoPermissionException noPermissionException) {
            s_logger.errorException(noPermissionException);
            throw new OWConfigurationException("No permission to access the directory, URL: " + this.m_URL);
        }
        catch (AuthenticationException authenticationException) {
            s_logger.errorException(authenticationException);
            throw new OWConfigurationException("Invalid username or password specified, URL: " + this.m_URL);
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            Throwable throwable = namingException.getRootCause();
            String string = throwable != null ? throwable.toString() : namingException.getMessage();
            throw new OWConfigurationException(string);
        }
        s_logger.flowMessage("root node constructed for " + this.m_URL);
    }

    protected ConfigurationContext(Class clazz) throws OWConfigurationException {
        this();
        s_logger.flowMessage("Construct ConfigurationContext for configuration type node");
        this.m_configClass = clazz;
        String string = clazz.getName();
        try {
            s_logger.flowMessage("Lookup configuration type " + string);
            this.m_configType = (Context)this.m_configurationsNode.lookup(CN + string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            s_logger.message("Configuration '" + string + "' not present in Directory.");
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException("Error accessing configuration '" + string + "' in Directory.");
        }
        catch (ClassCastException classCastException) {
            s_logger.errorException(classCastException);
            throw new OWConfigurationException("Incompatible types detected, no Context");
        }
        s_logger.flowMessage("configuration node constructed for " + string);
    }

    public void close() throws OWConfigurationException {
        s_logger.flowMessage("close context");
        try {
            if (this.m_configType != null) {
                this.m_configType.close();
            }
            if (this.m_configurationsNode != null) {
                this.m_configurationsNode.close();
            }
            if (this.m_rootNode != null) {
                this.m_rootNode.close();
            }
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new OWConfigurationException(namingException);
        }
    }

    public String getURL() {
        return this.m_URL;
    }

    public Class getConfigurationClass() {
        return this.m_configClass;
    }

    public boolean isReadOnly() {
        block4: {
            if (this.m_readOnly != null) break block4;
            s_logger.flowMessage("Check if Directory is read only");
            this.m_readOnly = Boolean.FALSE;
            String string = "writable";
            try {
                this.m_configurationsNode.bind(DUMMY_NAME, (Object)string);
            }
            catch (NamingException namingException) {
                try {
                    this.m_configurationsNode.rebind(DUMMY_NAME, (Object)string);
                }
                catch (NamingException namingException2) {
                    s_logger.flowMessage("Directory is read only");
                    this.m_readOnly = Boolean.TRUE;
                }
            }
        }
        return this.m_readOnly;
    }

    protected static void validateName(String string) throws OWConfigurationException {
        if (string == null || string.equals("")) {
            throw new OWConfigurationException("Name may not be empty");
        }
        if (string.startsWith(" ")) {
            throw new OWConfigurationException("Name may not start with space character");
        }
    }

    protected static String[] getNameArray(NamingEnumeration namingEnumeration) throws NamingException {
        Object object;
        Vector vector = new Vector();
        while (namingEnumeration.hasMore()) {
            object = (NameClassPair)namingEnumeration.next();
            String string = ((NameClassPair)object).getName();
            if (string.startsWith(CN)) {
                string = string.substring(CN.length());
            }
            ConfigurationContext.insertName(vector, string);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private static void insertName(Vector vector, String string) {
        String string2 = string.toLowerCase();
        int n = 0;
        int n2 = vector.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            String string3 = (String)vector.elementAt(n3);
            if (string2.compareTo(string3.toLowerCase()) < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        vector.insertElementAt(string, n);
    }

    protected static void initialize(Class clazz) throws OWConfigurationException {
        s_logger.flowMessage("initialize context for " + clazz.getName());
        ConfigurationContext configurationContext = new ConfigurationContext();
        configurationContext.createConfigType(clazz);
        configurationContext.close();
    }

    private void createConfigType(Class clazz) {
        String string = clazz.getName();
        try {
            s_logger.flowMessage("Create subfolder " + string);
            this.m_configurationsNode.createSubcontext(CN + string);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            s_logger.flowMessage("type " + string + " already exist - " + nameAlreadyBoundException);
        }
        catch (NoPermissionException noPermissionException) {
            s_logger.message("type " + string + " cannot create - " + noPermissionException);
        }
        catch (NamingException namingException) {
            s_logger.errorMessage("type " + string + " directory exception - " + namingException);
        }
    }
}

