/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.ConfigurationContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.event.ConfigurationEvent;
import com.baan.owimpl.fw.ccf.event.ConfigurationListener;
import com.baan.owimpl.fw.ccf.impl.ConfigurationData;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Configuration {
    public static final String CN = "cn=";
    protected ConfigurationData m_configurationData = null;
    protected ConfigurationContext m_parent = null;
    private Vector m_listeners = new Vector();
    private ConfigurationThread m_thread = null;
    private int m_refreshTime = 0;

    protected Configuration(ConfigurationContext configurationContext) {
        this.m_parent = configurationContext;
    }

    public boolean isChanged() {
        return this.m_configurationData.isDirty();
    }

    public Date getModificationDate() {
        return this.m_configurationData.getDate();
    }

    public String getModificationUser() {
        return this.m_configurationData.getUser();
    }

    protected static void printProperty(PrintStream printStream, String string, Object object) {
        printStream.print(string);
        int n = string.length();
        while (n < 25) {
            printStream.print(" ");
            ++n;
        }
        printStream.print(" : ");
        printStream.println(object);
    }

    protected static void printArrayProperty(PrintStream printStream, String string, Object[] objectArray) {
        if (objectArray.length == 0) {
            Configuration.printProperty(printStream, string, "-none-");
        } else {
            int n = 0;
            while (n < objectArray.length) {
                Configuration.printProperty(printStream, n == 0 ? string : "", objectArray[n]);
                ++n;
            }
        }
    }

    public void print(PrintStream printStream) {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)object;
        return this.m_configurationData.equals(configuration.m_configurationData);
    }

    public void setRefreshTime(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_refreshTime = 1000 * n;
        if (this.m_refreshTime > 0 && this.m_thread == null) {
            this.m_thread = new ConfigurationThread(this);
        } else if (this.m_refreshTime == 0 && this.m_thread != null) {
            this.m_thread.stopThread();
            this.m_thread = null;
        }
    }

    public int getRefreshTime() {
        return this.m_refreshTime / 1000;
    }

    public synchronized void addConfigurationListener(ConfigurationListener configurationListener) {
        this.m_listeners.addElement(configurationListener);
    }

    public synchronized void removeConfigurationListener(ConfigurationListener configurationListener) {
        this.m_listeners.removeElement(configurationListener);
    }

    protected synchronized void onConfigurationChanged() {
        ConfigurationEvent configurationEvent = new ConfigurationEvent(this);
        Enumeration enumeration2 = this.m_listeners.elements();
        while (enumeration2.hasMoreElements()) {
            ConfigurationListener configurationListener = (ConfigurationListener)enumeration2.nextElement();
            configurationListener.configurationChanged(configurationEvent);
        }
    }

    public abstract void store() throws OWConfigurationException;

    public abstract void remove() throws OWConfigurationException;

    protected abstract void refresh();

    private class ConfigurationThread
    extends Thread {
        private Configuration m_configuration;
        private boolean m_keepRunning;

        public ConfigurationThread(Configuration configuration2) {
            this.m_configuration = configuration2;
            this.m_keepRunning = true;
            this.setName("ConfigRefresh");
            this.setDaemon(true);
            this.start();
        }

        public void stopThread() {
            this.m_keepRunning = false;
            this.interrupt();
        }

        public void run() {
            try {
                while (this.m_keepRunning) {
                    Thread.sleep(this.m_configuration.m_refreshTime);
                    if (!this.m_keepRunning) continue;
                    this.m_configuration.refresh();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

