/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.IUserSession;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.Configuration;
import com.baan.owimpl.fw.ccf.IdentifierConfiguration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import com.eibus.services.security.BlockEncryption;
import java.io.PrintStream;
import java.util.Vector;

public class BusComponentConfiguration
extends IdentifierConfiguration {
    public static final int VERSION = 1;
    private static final String OWNER = "ownerid";
    private static final String DEFAULT_OWNER = "";
    private static final String ADMINISTRATOR = "administratorid";
    private static final String DEFAULT_ADMINISTRATOR = "";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULT_DESCRIPTION = "";
    private static final String COMPANY_NUMBER = "companynumber";
    private static final int DEFAULT_COMPANY_NUMBER = -1;
    private static final String USERSESSION = "usersession";
    private static final boolean DEFAULT_USERSESSION = false;
    private static final String USERNAME = "username";
    private static final String DEFAULT_USERNAME = "";
    private static final String M_KEY1 = "B253856FE748D53DAB46294294D53DAB4629469637258B36E37AD7897AD78936";
    private static final String PASSWORD = "password";
    private static final String DEFAULT_PASSWORD = "";
    private static final String M_KEY2 = "5A48FBC436DE983AC7B253856FE748D53DAB462946963729F58B36E373DAB462";
    private static final String CONNECTION_POINTS = "connection-points";
    private static final String[] DEFAULT_CONNECTION_POINTS = new String[]{"socket://<servername>:7912/"};
    private static final String CATEGORIES = "categories";
    private static final String[] DEFAULT_CATEGORIES = new String[0];
    private static final String ACTIVATION_TYPE = "activationtype";
    private static final String DEFAULT_ACTIVATION_TYPE = "";
    private static final String ACTIVATION_SERVICE_REFERENCE = "servicereference";
    private static final String DEFAULT_ACTIVATION_SERVICE_REFERENCE = "";
    private static final String ACTIVATION_POOLING_POLICY = "activationpoolingpolicy";
    private static final String DEFAULT_ACTIVATION_POOLING_POLICY = "shared";
    private static final String ACTIVATION_MAX_REFERENCES = "activationmaxreferences";
    private static final int DEFAULT_ACTIVATION_MAX_REFERENCES = 1;
    private static final String ACTIVATION_MAX_CONNECTIONS = "activationmaxconnections";
    private static final int DEFAULT_ACTIVATION_MAX_CONNECTIONS = 1;
    private static final String ACTIVATION_KEEPALIVE_TIME = "activationkeepalivetime";
    private static final int DEFAULT_ACTIVATION_KEEPALIVE_TIME = 0;
    private static final String ACTIVATION_POOLING_SERVICE = "activationpoolingservice";
    private static final String DEFAULT_ACTIVATION_POOLING_SERVICE = null;
    private static final String ACTIVATION_SERVER_TIMEOUT = "servertimeout";
    private static final int DEFAULT_ACTIVATION_SERVER_TIMEOUT = 720;
    public static final String ERPLX_ENV_CTRL_LIB = "erplx_env_ctrl_lib";
    public static final String ERPLX_WEBTOP_URI = "erplx_webtop_uri";
    public static final String ERPLX_XMG_CLASSPATH = "erplx_xmg_classpath";
    public static final String WMS_SYSTEM_ID = "wms_system_id";
    public static final String EVENTS_POLLING_FREQUENCY = "events_polling_frequency";
    public static final String JDBC_DRIVER_NAME = "jdbc_driver_name";
    public static final String JDBC_DATABASE_URL = "jdbc_database_url";
    public static final String JDBC_USER = "jdbc_user";
    public static final String JDBC_PASSWORD = "jdbc_password";
    public static final String ERROR_HANDLER_BUSCOMPONENT = "error_handler_buscomponent";
    public static final String PERSISTENT_QUEUE_PATH = "persistent_queue_path";

    public BusComponentConfiguration(BusComponentContext busComponentContext, String string) throws OWConfigurationException {
        super(busComponentContext, string);
    }

    public void storeDefaults() throws OWConfigurationException {
        this.setOwner("");
        this.setAdministrator("");
        this.setDescription("");
        this.setCompanyNumber(-1);
        this.setDefaultUserSession(false);
        this.setUsername("", false);
        this.setPassword("", false);
        this.setConnectionPoints(DEFAULT_CONNECTION_POINTS);
        this.setCategories(DEFAULT_CATEGORIES);
        this.setActivationType("");
        this.setActivationServiceReference("");
        this.setActivationPoolingPolicy(DEFAULT_ACTIVATION_POOLING_POLICY);
        this.setActivationMaxReferences(1);
        this.setActivationMaxConnections(1);
        this.setActivationKeepAliveTime(0);
        this.setActivationPoolingService(DEFAULT_ACTIVATION_POOLING_SERVICE);
        this.setActivationServerTimeout(720);
        this.store();
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        Configuration.printProperty(printStream, "Description", this.getDescription());
        Configuration.printProperty(printStream, "Owner", this.getOwner());
        Configuration.printProperty(printStream, "Company number", "" + this.getCompanyNumber());
        if (this.hasDefaultUserSession()) {
            printStream.println("Default user session:");
            Configuration.printProperty(printStream, "  User name", this.getUsername());
            Configuration.printProperty(printStream, "  Password", "********");
        } else {
            printStream.println("No default user session");
        }
        if (this.getActivationType().length() > 0) {
            printStream.println("Activation enabled:");
            Configuration.printProperty(printStream, "  Activation type", this.getActivationType());
            Configuration.printProperty(printStream, "  Service Reference", this.getActivationServiceReference());
            Configuration.printProperty(printStream, "  Pooling policy", this.getActivationPoolingPolicy());
            Configuration.printProperty(printStream, "  Maximum References", "" + this.getActivationMaxReferences());
            Configuration.printProperty(printStream, "  Maximum Connections", "" + this.getActivationMaxConnections());
            Configuration.printProperty(printStream, "  Keep Alive Time", "" + this.getActivationKeepAliveTime());
            if (this.getActivationPoolingService() != null) {
                Configuration.printProperty(printStream, "  APS service", this.getActivationPoolingService());
            } else {
                Configuration.printProperty(printStream, "  APS service", "disabled");
            }
            Configuration.printProperty(printStream, "  Server timeout", "" + this.getActivationServerTimeout());
        } else {
            printStream.println("Activation disabled");
        }
        Configuration.printArrayProperty(printStream, "Connection Points", this.getConnectionPoints());
        Configuration.printArrayProperty(printStream, "Categories", this.getCategories());
    }

    public String getValue(String string) {
        return (String)this.m_configurationData.getProperty(string);
    }

    public void setValue(String string, String string2) {
        this.m_configurationData.setProperty(string, string2);
    }

    public String getOwner() {
        return (String)this.m_configurationData.getProperty(OWNER);
    }

    public void setOwner(String string) {
        this.m_configurationData.setProperty(OWNER, string);
    }

    public String getAdministrator() {
        return (String)this.m_configurationData.getProperty(ADMINISTRATOR);
    }

    public void setAdministrator(String string) {
        this.m_configurationData.setProperty(ADMINISTRATOR, string);
    }

    public String getDescription() {
        return (String)this.m_configurationData.getProperty(DESCRIPTION);
    }

    public void setDescription(String string) {
        this.m_configurationData.setProperty(DESCRIPTION, string);
    }

    public int getCompanyNumber() {
        Integer n = (Integer)this.m_configurationData.getProperty(COMPANY_NUMBER);
        return n;
    }

    public void setCompanyNumber(int n) {
        this.m_configurationData.setProperty(COMPANY_NUMBER, new Integer(n));
    }

    public boolean hasDefaultUserSession() {
        Boolean bl = (Boolean)this.m_configurationData.getProperty(USERSESSION);
        return bl;
    }

    public void setDefaultUserSession(boolean bl) {
        this.m_configurationData.setProperty(USERSESSION, new Boolean(bl));
    }

    public String getUsername() {
        String string = (String)this.m_configurationData.getProperty(USERNAME);
        try {
            return BlockEncryption.DecryptToString(string, M_KEY1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setUsername(String string, boolean bl) {
        if (!bl) {
            string = BlockEncryption.Encrypt(string, M_KEY1);
        }
        this.m_configurationData.setProperty(USERNAME, string);
    }

    public IUserSession getDefaultUserSession() {
        IUserSession iUserSession;
        block2: {
            iUserSession = null;
            Boolean bl = (Boolean)this.m_configurationData.getProperty(USERSESSION);
            if (!bl.booleanValue()) break block2;
            try {
                String string = (String)this.m_configurationData.getProperty(USERNAME);
                String string2 = (String)this.m_configurationData.getProperty(PASSWORD);
                BoiToolkit boiToolkit = BoiToolkit.getDefaultToolkit();
                IUserInfo iUserInfo = boiToolkit.createUserInfo();
                iUserInfo.setUsername(BlockEncryption.DecryptToString(string, M_KEY1));
                iUserInfo.setPassword(BlockEncryption.DecryptToString(string2, M_KEY2));
                iUserSession = boiToolkit.createUserSession(iUserInfo);
            }
            catch (Exception exception) {}
        }
        return iUserSession;
    }

    public void setPassword(String string, boolean bl) {
        if (!bl) {
            string = BlockEncryption.Encrypt(string, M_KEY2);
        }
        this.m_configurationData.setProperty(PASSWORD, string);
    }

    public String[] getConnectionPoints() {
        Vector vector = (Vector)this.m_configurationData.getProperty(CONNECTION_POINTS);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setConnectionPoints(String[] stringArray) throws OWConfigurationException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            try {
                URI uRI = URI.createTransportURI(string);
                vector.addElement(string);
            }
            catch (MalformedURIException malformedURIException) {
                throw new OWConfigurationException(string + " is an invalid URI, " + malformedURIException.getMessage());
            }
            ++n;
        }
        this.m_configurationData.setProperty(CONNECTION_POINTS, vector);
    }

    public String[] getCategories() {
        Vector vector = (Vector)this.m_configurationData.getProperty(CATEGORIES);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setCategories(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        this.m_configurationData.setProperty(CATEGORIES, vector);
    }

    public String getActivationType() {
        return (String)this.m_configurationData.getProperty(ACTIVATION_TYPE);
    }

    public void setActivationType(String string) {
        this.m_configurationData.setProperty(ACTIVATION_TYPE, string);
    }

    public String getActivationServiceReference() {
        return (String)this.m_configurationData.getProperty(ACTIVATION_SERVICE_REFERENCE);
    }

    public void setActivationServiceReference(String string) {
        this.m_configurationData.setProperty(ACTIVATION_SERVICE_REFERENCE, string);
    }

    public String getActivationPoolingPolicy() {
        return (String)this.m_configurationData.getProperty(ACTIVATION_POOLING_POLICY);
    }

    public void setActivationPoolingPolicy(String string) {
        this.m_configurationData.setProperty(ACTIVATION_POOLING_POLICY, string);
    }

    public int getActivationMaxReferences() {
        Integer n = (Integer)this.m_configurationData.getProperty(ACTIVATION_MAX_REFERENCES);
        return n;
    }

    public void setActivationMaxReferences(int n) {
        this.m_configurationData.setProperty(ACTIVATION_MAX_REFERENCES, new Integer(n));
    }

    public int getActivationMaxConnections() {
        Integer n = (Integer)this.m_configurationData.getProperty(ACTIVATION_MAX_CONNECTIONS);
        return n;
    }

    public void setActivationMaxConnections(int n) {
        this.m_configurationData.setProperty(ACTIVATION_MAX_CONNECTIONS, new Integer(n));
    }

    public int getActivationKeepAliveTime() {
        Integer n = (Integer)this.m_configurationData.getProperty(ACTIVATION_KEEPALIVE_TIME);
        return n;
    }

    public void setActivationKeepAliveTime(int n) {
        this.m_configurationData.setProperty(ACTIVATION_KEEPALIVE_TIME, new Integer(n));
    }

    public String getActivationPoolingService() {
        String string = (String)this.m_configurationData.getProperty(ACTIVATION_POOLING_SERVICE);
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    public void setActivationPoolingService(String string) {
        if (string == null) {
            string = "";
        }
        this.m_configurationData.setProperty(ACTIVATION_POOLING_SERVICE, string);
    }

    public int getActivationServerTimeout() {
        Integer n = (Integer)this.m_configurationData.getProperty(ACTIVATION_SERVER_TIMEOUT);
        return n;
    }

    public void setActivationServerTimeout(int n) {
        this.m_configurationData.setProperty(ACTIVATION_SERVER_TIMEOUT, new Integer(n));
    }
}

