/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.fw.ccf;

import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.Configuration;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SmartConfiguration;
import java.io.PrintStream;

public class AdapterClientConfiguration
extends SmartConfiguration {
    public static final int VERSION = 1;
    private static final String ITERATOR_SIZE = "bus.bdf.iterator.size";
    private static final int DEFAULT_ITERATOR_SIZE = 250;
    private static final String DEFAULT_TIMEOUT = "bus.bdf.manager.timeout";
    private static final int DEFAULT_DEFAULT_TIMEOUT = 60000;
    private static final String DEFAULT_BACKEND = "bus.default.backend";
    private static final String DEFAULT_DEFAULT_BACKEND = "";
    private static final String CLIENT_BUSCOMPONENT = "bus.component";
    private static final String DEFAULT_CLIENT_BUSCOMPONENT = "";
    private static final String DEFAULT_PROTOCOL = "bus.default.protocol";
    private static final String DEFAULT_DEFAULT_PROTOCOL = "socket";
    private static final String MAX_READERS = "bus.connection.max.readers";
    private static final int DEFAULT_MAX_READERS = 50;
    private static final String NUMBER_OF_XML_PARSERS = "bus.num.xml.parse.threads";
    private static final int DEFAULT_NUMBER_OF_XML_PARSERS = 1;

    public AdapterClientConfiguration(AdapterClientContext adapterClientContext, String string, String string2, String string3, boolean bl) throws OWConfigurationException {
        super(adapterClientContext, string, string2, string3, bl);
    }

    public void storeDefaults() throws OWConfigurationException {
        this.setIteratorSize(250);
        this.setTimeout(60000);
        this.setDefaultBackend("");
        this.setClientBusComponent("");
        this.setDefaultProtocol(DEFAULT_DEFAULT_PROTOCOL);
        this.setMaxReaders(50);
        this.setNumberOfParsers(1);
        this.store();
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        Configuration.printProperty(printStream, "Iterator size", "" + this.getIteratorSize());
        Configuration.printProperty(printStream, "Timeout", "" + this.getTimeout());
        Configuration.printProperty(printStream, "Default Backend", this.getDefaultBackend());
        Configuration.printProperty(printStream, "Client BusComponent", this.getClientBusComponent());
    }

    public int getIteratorSize() {
        Integer n = (Integer)this.m_configurationData.getProperty(ITERATOR_SIZE);
        return n;
    }

    public void setIteratorSize(int n) {
        this.m_configurationData.setProperty(ITERATOR_SIZE, new Integer(n));
    }

    public int getTimeout() {
        Integer n = (Integer)this.m_configurationData.getProperty(DEFAULT_TIMEOUT);
        return n;
    }

    public void setTimeout(int n) {
        this.m_configurationData.setProperty(DEFAULT_TIMEOUT, new Integer(n));
    }

    public String getDefaultBackend() {
        return (String)this.m_configurationData.getProperty(DEFAULT_BACKEND);
    }

    public void setDefaultBackend(String string) {
        this.m_configurationData.setProperty(DEFAULT_BACKEND, string);
    }

    public String getClientBusComponent() {
        return (String)this.m_configurationData.getProperty(CLIENT_BUSCOMPONENT);
    }

    public void setClientBusComponent(String string) {
        this.m_configurationData.setProperty(CLIENT_BUSCOMPONENT, string);
    }

    public String getDefaultProtocol() {
        return (String)this.m_configurationData.getProperty(DEFAULT_PROTOCOL);
    }

    public void setDefaultProtocol(String string) {
        this.m_configurationData.setProperty(DEFAULT_PROTOCOL, string);
    }

    public int getMaxReaders() {
        Integer n = (Integer)this.m_configurationData.getProperty(MAX_READERS);
        return n;
    }

    public void setMaxReaders(int n) {
        this.m_configurationData.setProperty(MAX_READERS, new Integer(n));
    }

    public int getNumberOfParsers() {
        Integer n = (Integer)this.m_configurationData.getProperty(NUMBER_OF_XML_PARSERS);
        return n;
    }

    public void setNumberOfParsers(int n) {
        this.m_configurationData.setProperty(NUMBER_OF_XML_PARSERS, new Integer(n));
    }
}

