/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.oledb;

import com.baan.b3impl.about.IInstallationComponentInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class OLEDBServerComponentInfo
implements IInstallationComponentInfo {
    private static IInstallationComponentInfo s_instance = new OLEDBServerComponentInfo();
    private static boolean OLEDBInstalled = false;
    private static boolean giveWarning = true;
    private static final String VERSION = "\"Version\"=\"";
    private static final String PATCHLEVEL = "\"PatchLevel\"=\"";
    private static final String BUILDNR = "\"BuildNr\"=\"";
    private static final String BLDGUID = "\"BuildGUID\"=\"";
    private static final String BLDDATE = "\"BuildDate\"=\"";
    private static final String CONFIGSPEC = "\"ConfigSpec\"=hex(2):";
    private static final String tempfile = "_tmp_.txt";
    private static String B3VERSIONSTRING = "";
    private static String B3PATCHLEVEL = "";
    private static String B3BUILDNUMBER = "";
    private static String BUILDGUID = "";
    private static String BUILDDATE = "";
    private static String CCCONFIGSPEC = "";

    static String getValue(String string, String string2) {
        int n = string.indexOf(string2);
        if (n > 0) {
            String string3 = string.substring(n += string2.length());
            int n2 = string3.indexOf(34);
            if (n2 > 0) {
                return string.substring(n, n + n2);
            }
            return string3;
        }
        return "";
    }

    static String parseHex(String string) throws Exception {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\\ ");
        int n = 0;
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            string2 = new String(stringTokenizer.nextToken());
            try {
                byte by = Byte.parseByte(string2, 16);
                byArray[n++] = by;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string2 = new String(byArray, 0, n - 1, "UTF-16LE");
        return OLEDBServerComponentInfo.replace(string2, "\\n", "\n                   ");
    }

    static String replace(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(string2)) >= 0) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string3);
            string = string.substring(n + string2.length());
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getComponentName() {
        return "Connector for OLE DB";
    }

    public static String getInfoString() {
        return s_instance.getComponentName() + "\n\n" + s_instance.getCopyrightMessage() + "\n" + "\nVersion          : " + s_instance.getVersion() + "\nPatch level      : " + s_instance.getPatchLevel();
    }

    public static String getAllInfo() {
        return OLEDBServerComponentInfo.getInfoString() + "\n" + "\nBuild nr         : " + s_instance.getBuildNumber() + "\nBuild GUID       : " + s_instance.getBuildGuid() + "\nBuild date       : " + s_instance.getBuildDateString() + "\nConfig spec      : " + s_instance.getSourceControlConfiguration();
    }

    public static void main(String[] stringArray) {
        if (!OLEDBInstalled || System.getProperty("os.name").indexOf("Unix") != -1) {
            System.out.println("Connector for OLE DB is not installed on this system.");
            return;
        }
        int n = 0;
        if (stringArray.length > 0) {
            n = stringArray[0].charAt(0);
        }
        switch (n) {
            case 0: {
                System.out.println(OLEDBServerComponentInfo.getInfoString());
                System.out.println("Build date       : " + s_instance.getBuildDateString());
                break;
            }
            case 65: {
                System.out.println(OLEDBServerComponentInfo.getAllInfo());
                break;
            }
            case 66: {
                System.out.println(s_instance.getBuildNumber());
                break;
            }
            case 99: {
                System.out.println(s_instance.getSourceControlConfiguration());
                break;
            }
            case 100: {
                System.out.println(s_instance.getBuildDateString());
                break;
            }
            case 103: {
                System.out.println(s_instance.getBuildGuid());
                break;
            }
            case 80: {
                System.out.println(s_instance.getPatchLevel());
                break;
            }
            case 86: {
                System.out.println(s_instance.getVersion());
                break;
            }
            default: {
                System.out.println("Syntax: " + s_instance.getClass().getName() + " [A|B|c|d|g|h|P|V]");
                System.out.println("\t(no options) - User readable information");
                System.out.println("\t           A - print all version information");
                System.out.println("\t           B - print only the build nr");
                System.out.println("\t           c - print only the source control configuration");
                System.out.println("\t           d - print only the build date");
                System.out.println("\t           g - print only the build GUID");
                System.out.println("\t           h - print this help");
                System.out.println("\t           P - print only the patch level");
                System.out.println("\t           V - print only the version");
            }
        }
    }

    public boolean isInstalled() {
        return OLEDBInstalled;
    }

    public boolean giveWarning() {
        return giveWarning;
    }

    public String getVersion() {
        return B3VERSIONSTRING;
    }

    public String getPatchLevel() {
        return B3PATCHLEVEL;
    }

    public String getBuildNumber() {
        return B3BUILDNUMBER;
    }

    public String getBuildGuid() {
        return BUILDGUID;
    }

    public String getBuildDateString() {
        return BUILDDATE;
    }

    public String getSourceControlConfiguration() {
        return CCCONFIGSPEC;
    }

    public String getCopyrightMessage() {
        return "(c) Copyright 2006 SSA Global Technologies, Inc. and its Subsidiaries and Affiliates";
    }

    static {
        File file2 = new File(tempfile);
        file2.delete();
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec("regedit //e _tmp_.txt \"HKEY_LOCAL_MACHINE\\SOFTWARE\\Baan\\iBaan OpenWorldX Connector for OLE DB\"");
            process.waitFor();
            int n = process.exitValue();
            try {
                FileInputStream fileInputStream = new FileInputStream(tempfile);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-16");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                char[] cArray = new char[10240];
                int n2 = bufferedReader.read(cArray, 0, 10240);
                bufferedReader.close();
                String string = new String(cArray, 0, n2);
                String string2 = OLEDBServerComponentInfo.getValue(string, VERSION);
                String string3 = OLEDBServerComponentInfo.getValue(string, BLDDATE);
                String string4 = OLEDBServerComponentInfo.getValue(string, BLDGUID);
                String string5 = OLEDBServerComponentInfo.getValue(string, BUILDNR);
                String string6 = OLEDBServerComponentInfo.getValue(string, CONFIGSPEC);
                boolean bl = OLEDBInstalled = string2 != null;
                if (string2 != null) {
                    int n3 = string2.lastIndexOf(".");
                    B3VERSIONSTRING = string2.substring(0, n3);
                    B3PATCHLEVEL = string2.substring(n3 + 1);
                    B3BUILDNUMBER = string5;
                    BUILDDATE = string3;
                    BUILDGUID = string4;
                    CCCONFIGSPEC = OLEDBServerComponentInfo.parseHex(string6);
                }
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        file2.delete();
    }
}

