/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.odbc;

import com.baan.owimpl.fw.ccf.LoggingConfiguration;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.dt.LogLevelEnum;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;

public final class LogUtil {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.b3.odbc", "odbc");
    private static final String LOG_PREFIX = "ODBC: ";
    private static LoggingConfiguration s_lc = null;

    public static boolean isFlowEnabled() {
        if (s_lc != null) {
            LogLevelEnum logLevelEnum = s_lc.getLevel();
            return logLevelEnum == LogLevelEnum.FLOW;
        }
        return false;
    }

    public static boolean isInfoEnabled() {
        if (s_lc != null) {
            LogLevelEnum logLevelEnum = s_lc.getLevel();
            return logLevelEnum == LogLevelEnum.INFO || logLevelEnum == LogLevelEnum.FLOW;
        }
        return false;
    }

    public static void errorMessage(String string) {
        s_logger.errorMessage(LOG_PREFIX + string);
    }

    public static void infoMessage(String string) {
        s_logger.message(LOG_PREFIX + string);
    }

    public static void flowMessage(String string) {
        s_logger.flowMessage(LOG_PREFIX + string);
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_ODBC_CONNECTOR);
        try {
            s_lc = LoggingContext.getInstance().search();
        }
        catch (Throwable throwable) {}
    }
}

