/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms.uri;

import com.baan.owimpl.b3.jms.uri.AbstractSection;
import com.baan.owimpl.b3.jms.uri.PutQcfJndiReference;
import com.baan.owimpl.b3.jms.uri.PutQueueJndiReference;
import com.baan.owimpl.b3.jms.util.Util;

public final class PutSection
extends AbstractSection {
    private final PutQcfJndiReference m_queueConnectionFactory;
    private final PutQueueJndiReference m_queue;
    private final boolean m_useLocalJndiContextFactory;
    private final boolean m_useLocalJndiProviderUrl;
    private final boolean m_isPersistent;
    private final long m_timeToLive;

    public PutSection(String string, String string2, PutQcfJndiReference putQcfJndiReference, PutQueueJndiReference putQueueJndiReference, boolean bl, boolean bl2) {
        this(string, string2, putQcfJndiReference, putQueueJndiReference, bl, bl2, false, -1L);
    }

    public PutSection(String string, String string2, PutQcfJndiReference putQcfJndiReference, PutQueueJndiReference putQueueJndiReference, boolean bl, boolean bl2, boolean bl3, long l) {
        super(string, string2);
        if (bl && string != null) {
            throw new IllegalArgumentException("p_useLocalJndiContextFactory==true implies p_jndiContextFactory==null");
        }
        if (bl2 && string2 != null) {
            throw new IllegalArgumentException("p_useLocalJndiProviderUrl==true implies p_jndiProviderUrl==null");
        }
        this.m_queueConnectionFactory = putQcfJndiReference;
        this.m_queue = putQueueJndiReference;
        this.m_useLocalJndiContextFactory = bl;
        this.m_useLocalJndiProviderUrl = bl2;
        this.m_isPersistent = bl3;
        this.m_timeToLive = l;
    }

    public PutQcfJndiReference getQueueConnectionFactoryReference() {
        return this.m_queueConnectionFactory;
    }

    public PutQueueJndiReference getQueueReference() {
        return this.m_queue;
    }

    public boolean useLocalJndiContextFactory() {
        return this.m_useLocalJndiContextFactory;
    }

    public boolean useLocalJndiProviderUrl() {
        return this.m_useLocalJndiProviderUrl;
    }

    public boolean isPersistent() {
        return this.m_isPersistent;
    }

    public long getTimeToLive() {
        return this.m_timeToLive;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof PutSection) {
            PutSection putSection = (PutSection)object;
            boolean bl = this.m_useLocalJndiContextFactory == putSection.m_useLocalJndiContextFactory && this.m_useLocalJndiProviderUrl == putSection.m_useLocalJndiProviderUrl && Util.areEqual(this.m_queueConnectionFactory, putSection.m_queueConnectionFactory) && Util.areEqual(this.m_queue, putSection.m_queue) && this.m_isPersistent == putSection.m_isPersistent && this.m_timeToLive == putSection.m_timeToLive && super.equals(putSection);
            return bl;
        }
        return false;
    }

    StringBuffer appendParametersTo(StringBuffer stringBuffer) {
        super.appendParametersTo(stringBuffer).append(',');
        Util.appendObjectTo(stringBuffer, this.m_queueConnectionFactory).append(',');
        Util.appendObjectTo(stringBuffer, this.m_queue);
        stringBuffer.append(',').append(this.m_useLocalJndiContextFactory);
        stringBuffer.append(',').append(this.m_useLocalJndiProviderUrl);
        stringBuffer.append(',').append(this.m_isPersistent);
        stringBuffer.append(',').append(this.m_timeToLive);
        return stringBuffer;
    }

    StringBuffer appendToUri(StringBuffer stringBuffer) {
        stringBuffer.append("put[");
        int n = stringBuffer.length();
        super.appendToUri(stringBuffer);
        int n2 = Util.countTerms(new boolean[]{this.m_useLocalJndiContextFactory, this.m_useLocalJndiProviderUrl, this.m_isPersistent}, new Object[]{this.m_queueConnectionFactory, this.m_queue}, new long[]{this.m_timeToLive});
        if (n != stringBuffer.length() && n2 > 0) {
            stringBuffer.append(',');
        }
        int n3 = n2 - 1;
        if (this.m_useLocalJndiContextFactory) {
            stringBuffer.append("jndiContextFactory=useLocal");
            Util.appendComma(stringBuffer, n3--);
        }
        if (this.m_useLocalJndiProviderUrl) {
            stringBuffer.append("jndiProviderUrl=useLocal");
            Util.appendComma(stringBuffer, n3--);
        }
        if (this.m_queueConnectionFactory != null) {
            stringBuffer.append("queueConnectionFactory=");
            this.m_queueConnectionFactory.appendToUri(stringBuffer);
            Util.appendComma(stringBuffer, n3--);
        }
        if (this.m_queue != null) {
            stringBuffer.append("queue=");
            this.m_queue.appendToUri(stringBuffer);
            Util.appendComma(stringBuffer, n3--);
        }
        if (this.m_isPersistent) {
            stringBuffer.append("persistent");
            Util.appendComma(stringBuffer, n3--);
        }
        if (this.m_timeToLive != -1L) {
            stringBuffer.append("timeToLive=");
            stringBuffer.append(this.m_timeToLive);
        }
        stringBuffer.append(']');
        return stringBuffer;
    }
}

