/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms.uri;

import com.baan.owimpl.b3.jms.uri.AbstractRemainder;
import com.baan.owimpl.b3.jms.uri.ConfiguredRemainder;
import com.baan.owimpl.b3.jms.uri.parser.ParseException;
import com.baan.owimpl.b3.jms.uri.parser.RemainderParser;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.URI;
import java.io.StringReader;

public final class Parser {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$jms$uri$Parser == null ? (class$com$baan$owimpl$b3$jms$uri$Parser = Parser.class$("com.baan.owimpl.b3.jms.uri.Parser")) : class$com$baan$owimpl$b3$jms$uri$Parser);
    private static final String JMS_URI_VERSION_PREFIX = "v1.";
    static /* synthetic */ Class class$com$baan$owimpl$b3$jms$uri$Parser;

    private Parser() {
        s_logger.flowMessage("-> Parser()");
        s_logger.flowMessage("<- Parser()");
        throw new RuntimeException("Attempt to instantiate " + this.getClass().getName());
    }

    public static ConfiguredRemainder getConfiguredRemainder(URI uRI) throws ParseException {
        s_logger.flowMessage("-> getConfiguredRemainder(URI)");
        int n = Parser.checkUriTypeAndVersion(uRI);
        boolean bl = true;
        if (n > 0) {
            bl = false;
        }
        String string = uRI.getRemainder();
        StringReader stringReader = new StringReader(string);
        RemainderParser remainderParser = new RemainderParser(stringReader, bl);
        s_logger.message("Parsing configured URI (" + uRI + ") with " + (bl ? "strict" : "loose") + " grammar.");
        ConfiguredRemainder configuredRemainder = remainderParser.configuredRemainder();
        s_logger.message("URI parsed as " + configuredRemainder);
        s_logger.flowMessage("<- getConfiguredRemainder(URI)");
        return configuredRemainder;
    }

    public static AbstractRemainder getRemainder(URI uRI) throws ParseException {
        s_logger.flowMessage("-> getRemainder(URI)");
        int n = Parser.checkUriTypeAndVersion(uRI);
        boolean bl = true;
        if (n > 0) {
            bl = false;
        }
        String string = uRI.getRemainder();
        StringReader stringReader = new StringReader(string);
        RemainderParser remainderParser = new RemainderParser(stringReader, bl);
        s_logger.message("Parsing URI (" + uRI + ") with " + (bl ? "strict" : "loose") + " grammar.");
        AbstractRemainder abstractRemainder = remainderParser.remainder();
        s_logger.message("URI parsed as " + abstractRemainder);
        s_logger.flowMessage("<- getRemainder(URI)");
        return abstractRemainder;
    }

    private static int checkUriTypeAndVersion(URI uRI) throws ParseException {
        s_logger.flowMessage("-> checkUriTypeAndVersion(URI)");
        String string = uRI.getProtocol();
        if (!"jms".equals(string)) {
            s_logger.flowMessage("<- checkUriTypeAndVersion(URI)1");
            throw new ParseException("Expected protocol jms but found protocol " + string + " in URI " + uRI);
        }
        String string2 = uRI.getHost();
        if (string2 == null) {
            s_logger.flowMessage("<- checkUriTypeAndVersion(URI)2");
            throw new ParseException("JMS URI is not versioned. Expected URI of form jms://v<majorVersion>.<minorVersion>/#<configData>");
        }
        s_logger.message("URI has version " + string2 + ", current version is " + Parser.currentUriVersionToString());
        if (!string2.startsWith(JMS_URI_VERSION_PREFIX)) {
            s_logger.flowMessage("<- checkUriTypeAndVersion(URI)3");
            throw new ParseException("Unknown URI version " + string2 + " (probably newer). Current URI version is " + Parser.currentUriVersionToString());
        }
        String string3 = string2.substring(JMS_URI_VERSION_PREFIX.length());
        try {
            int n = Integer.parseInt(string3);
            s_logger.flowMessage("<- checkUriTypeAndVersion(URI)4");
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            s_logger.flowMessage("<- checkUriTypeAndVersion(URI)5");
            throw new ParseException("JMS URI minor version is not an integer (" + string3 + ") in uri " + uRI);
        }
    }

    private static String currentUriVersionToString() {
        return "1.0";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

