/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms.uri;

import com.baan.owimpl.b3.jms.uri.GetSection;
import com.baan.owimpl.b3.jms.uri.PutSection;
import com.baan.owimpl.b3.jms.util.Util;

public abstract class AbstractRemainder {
    private final GetSection m_getSection;
    private final PutSection m_putSection;

    AbstractRemainder(GetSection getSection, PutSection putSection) {
        this.m_getSection = getSection;
        this.m_putSection = putSection;
    }

    public GetSection getGetSection() {
        return this.m_getSection;
    }

    public PutSection getPutSection() {
        return this.m_putSection;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractRemainder) {
            AbstractRemainder abstractRemainder = (AbstractRemainder)object;
            boolean bl = Util.areEqual(this.m_getSection, abstractRemainder.m_getSection) && Util.areEqual(this.m_putSection, abstractRemainder.m_putSection);
            return bl;
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Not implemented! If you need this, you will have to program it.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        return this.appendTo(stringBuffer).toString();
    }

    private StringBuffer appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.getClass().getName()).append('(');
        Util.appendObjectTo(stringBuffer, this.m_getSection).append(',');
        Util.appendObjectTo(stringBuffer, this.m_putSection).append(')');
        stringBuffer.append(Integer.toHexString(super.hashCode()));
        return stringBuffer;
    }

    public String toUriString() {
        StringBuffer stringBuffer = new StringBuffer("jms");
        stringBuffer.append("://v").append(1);
        stringBuffer.append('.').append(0);
        stringBuffer.append("/#");
        this.appendToUri(stringBuffer);
        return stringBuffer.toString();
    }

    StringBuffer appendToUri(StringBuffer stringBuffer) {
        if (this.m_getSection != null) {
            this.m_getSection.appendToUri(stringBuffer);
        }
        if (this.m_putSection != null) {
            this.m_putSection.appendToUri(stringBuffer);
        }
        return stringBuffer;
    }
}

