/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms.uri;

import com.baan.owimpl.b3.jms.uri.AbstractJndiReference;
import com.baan.owimpl.b3.jms.util.Util;

public abstract class AbstractPutJndiReference
extends AbstractJndiReference {
    private final boolean m_useLocalContextFactory;
    private final boolean m_useLocalProviderUrl;

    AbstractPutJndiReference(String string, String string2, String string3, boolean bl, boolean bl2) {
        super(string, string2, string3);
        if (bl && string != null) {
            throw new IllegalArgumentException("p_useLocalContextFactory==true implies p_contextFactory==null");
        }
        if (bl2 && string2 != null) {
            throw new IllegalArgumentException("p_useLocalProviderUrl==true implies p_providerUrl==null");
        }
        this.m_useLocalContextFactory = bl;
        this.m_useLocalProviderUrl = bl2;
    }

    public boolean useLocalContextFactory() {
        return this.m_useLocalContextFactory;
    }

    public boolean useLocalProviderUrl() {
        return this.m_useLocalProviderUrl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractPutJndiReference) {
            AbstractPutJndiReference abstractPutJndiReference = (AbstractPutJndiReference)object;
            boolean bl = this.m_useLocalContextFactory == abstractPutJndiReference.m_useLocalContextFactory && this.m_useLocalProviderUrl == abstractPutJndiReference.m_useLocalProviderUrl && super.equals(abstractPutJndiReference);
            return bl;
        }
        return false;
    }

    StringBuffer appendParametersTo(StringBuffer stringBuffer) {
        super.appendParametersTo(stringBuffer);
        stringBuffer.append(',').append(this.m_useLocalContextFactory);
        stringBuffer.append(',').append(this.m_useLocalProviderUrl);
        return stringBuffer;
    }

    StringBuffer appendToUri(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        super.appendToUri(stringBuffer);
        int n2 = Util.countTerms(new boolean[]{this.m_useLocalContextFactory, this.m_useLocalProviderUrl}, null);
        if (n2 > 0 && n != stringBuffer.length()) {
            stringBuffer.append(',');
        }
        int n3 = n2 - 1;
        if (this.m_useLocalContextFactory) {
            stringBuffer.append("jndiContextFactory=useLocal");
            Util.appendComma(stringBuffer, n3--);
        }
        if (this.m_useLocalProviderUrl) {
            stringBuffer.append("jndiProviderUrl=useLocal");
        }
        return stringBuffer;
    }
}

