/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms.uri;

import com.baan.owimpl.b3.jms.util.Util;

public abstract class AbstractJndiReference {
    private final String m_contextFactory;
    private final String m_providerUrl;
    private final String m_name;

    AbstractJndiReference(String string, String string2, String string3) {
        this.m_contextFactory = string;
        this.m_providerUrl = string2;
        this.m_name = string3;
    }

    public final String getContextFactory() {
        return this.m_contextFactory;
    }

    public final String getProviderUrl() {
        return this.m_providerUrl;
    }

    public final String getName() {
        return this.m_name;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractJndiReference) {
            AbstractJndiReference abstractJndiReference = (AbstractJndiReference)object;
            boolean bl = Util.areEqual(this.m_contextFactory, abstractJndiReference.m_contextFactory) && Util.areEqual(this.m_providerUrl, abstractJndiReference.m_providerUrl) && Util.areEqual(this.m_name, abstractJndiReference.m_name);
            return bl;
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Not implemented! If you need this, you will have to program it.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        return this.appendTo(stringBuffer).toString();
    }

    private StringBuffer appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.getClass().getName()).append('(');
        this.appendParametersTo(stringBuffer).append(')');
        stringBuffer.append(Integer.toHexString(super.hashCode()));
        return stringBuffer;
    }

    StringBuffer appendParametersTo(StringBuffer stringBuffer) {
        Util.appendLiteralTo(stringBuffer, this.m_contextFactory).append(',');
        Util.appendLiteralTo(stringBuffer, this.m_providerUrl).append(',');
        Util.appendLiteralTo(stringBuffer, this.m_name);
        return stringBuffer;
    }

    StringBuffer appendToUri(StringBuffer stringBuffer) {
        int n = Util.countTerms(null, new Object[]{this.m_contextFactory, this.m_providerUrl, this.m_name});
        int n2 = n - 1;
        if (this.m_contextFactory != null) {
            stringBuffer.append("jndiContextFactory=\"");
            Util.appendEscaped(stringBuffer, this.m_contextFactory).append('\"');
            Util.appendComma(stringBuffer, n2--);
        }
        if (this.m_providerUrl != null) {
            stringBuffer.append("jndiProviderUrl=\"");
            Util.appendEscaped(stringBuffer, this.m_providerUrl).append('\"');
            Util.appendComma(stringBuffer, n2--);
        }
        if (this.m_name != null) {
            stringBuffer.append("name=\"");
            Util.appendEscaped(stringBuffer, this.m_name).append('\"');
        }
        return stringBuffer;
    }
}

