/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms;

import com.baan.owimpl.b3.jms.ConfigurationException;
import com.baan.owimpl.b3.jms.IJmsConstants;
import com.baan.owimpl.b3.jms.PutConfiguration;
import com.baan.owimpl.b3.jms.UnexpectedClassException;
import com.baan.owimpl.b3.jms.util.ILoggers;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.NamingException;

class JmsMessageSender
implements ExceptionListener {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$jms$JmsMessageSender == null ? (class$com$baan$owimpl$b3$jms$JmsMessageSender = JmsMessageSender.class$("com.baan.owimpl.b3.jms.JmsMessageSender")) : class$com$baan$owimpl$b3$jms$JmsMessageSender);
    private final PutConfiguration m_putConfiguration;
    private final QueueConnection m_queueConnection;
    private final QueueSession m_queueSession;
    private final Queue m_queue;
    private final QueueSender m_queueSender;
    static /* synthetic */ Class class$com$baan$owimpl$b3$jms$JmsMessageSender;

    JmsMessageSender(PutConfiguration putConfiguration) throws JMSException, NamingException, ConfigurationException, UnexpectedClassException {
        s_logger.flowEntry("JmsMessageSender(PutConfiguration)");
        s_logger.message("Message Sender instance created.");
        this.m_putConfiguration = putConfiguration;
        QueueConnectionFactory queueConnectionFactory = putConfiguration.getQueueConnectionFactory();
        ILoggers.QCF.flowEntry("createQueueConnection()");
        this.m_queueConnection = queueConnectionFactory.createQueueConnection();
        ILoggers.QCF.flowExit("createQueueConnection()");
        ILoggers.QCF.flowEntry("setExceptionListener(ExceptionListener)");
        this.m_queueConnection.setExceptionListener((ExceptionListener)this);
        ILoggers.QCF.flowExit("setExceptionListener(ExceptionListener)");
        ILoggers.QCONNECTION.flowEntry("createQueueSession(boolean,int)");
        this.m_queueSession = this.m_queueConnection.createQueueSession(false, 1);
        ILoggers.QCONNECTION.flowExit("createQueueSession(boolean,int)");
        this.m_queue = putConfiguration.getQueue();
        ILoggers.QSESSION.flowEntry("createSender(Queue)");
        this.m_queueSender = this.m_queueSession.createSender(this.m_queue);
        ILoggers.QSESSION.flowExit("createSender(Queue)");
        int n = this.m_putConfiguration.getDeliveryMode();
        ILoggers.QSENDER.flowEntry("setDeliveryMode(int)");
        this.m_queueSender.setDeliveryMode(n);
        ILoggers.QSENDER.flowExit("setDeliveryMode(int)");
        long l = this.m_putConfiguration.getTimeToLive();
        ILoggers.QSENDER.flowEntry("setTimeToLive(long)");
        this.m_queueSender.setTimeToLive(l);
        ILoggers.QSENDER.flowExit("setTimeToLive(long)");
        s_logger.flowExit("JmsMessageSender(PutConfiguration)");
    }

    public void send(com.eibus.connection.Message message) throws JMSException {
        s_logger.flowEntry("send(Message)");
        ILoggers.QSESSION.flowEntry("createBytesMessage()");
        BytesMessage bytesMessage = this.m_queueSession.createBytesMessage();
        ILoggers.QSESSION.flowExit("createBytesMessage()");
        s_logger.message("Created an Empty JMS Bytes Message.");
        ILoggers.BMESSAGE.flowEntry("writeBytes(byte[])");
        bytesMessage.writeBytes(IJmsConstants.MAGIC_NUMBER);
        ILoggers.BMESSAGE.flowExit("writeBytes(byte[])");
        ILoggers.BMESSAGE.flowEntry("writeInt(int)");
        bytesMessage.writeInt(1);
        ILoggers.BMESSAGE.flowExit("writeInt(int)");
        ILoggers.BMESSAGE.flowEntry("writeInt(int)");
        bytesMessage.writeInt(1);
        ILoggers.BMESSAGE.flowExit("writeInt(int)");
        int n = message.getText().length;
        ILoggers.BMESSAGE.flowEntry("writeInt(int)");
        bytesMessage.writeInt(n);
        ILoggers.BMESSAGE.flowExit("writeInt(int)");
        s_logger.message("Written data length = " + n + " bytes to the message.");
        ILoggers.BMESSAGE.flowEntry("writeBytes(byte[])");
        bytesMessage.writeBytes(message.getText());
        ILoggers.BMESSAGE.flowExit("writeBytes(byte[])");
        this.m_putConfiguration.setReplyToProperties((Message)bytesMessage);
        s_logger.message("Bytes Message generated: " + bytesMessage.toString());
        s_logger.message("Sending a message using the Message Sender " + this.m_queueSender);
        ILoggers.QSENDER.flowEntry("send(Message)");
        this.m_queueSender.send((Message)bytesMessage);
        ILoggers.QSENDER.flowExit("send(Message)");
        s_logger.message("Message sent!");
        s_logger.flowExit("send(Message)");
    }

    public void onException(JMSException jMSException) {
        s_logger.flowEntry("onException(JMSException p_exception)");
        s_logger.errorMessage("Asynchronous exception report from JMS provider:");
        s_logger.errorException(jMSException);
        s_logger.flowExit("onException(JMSException p_exception)");
    }

    public String toString() {
        return "com.baan.owimpl.b3.jms.JmsMessageSender";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

