/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms;

import com.baan.owimpl.b3.jms.ConfigurationException;
import com.baan.owimpl.b3.jms.ConfigurationManager;
import com.baan.owimpl.b3.jms.GetConfiguration;
import com.baan.owimpl.b3.jms.IJmsConstants;
import com.baan.owimpl.b3.jms.UnexpectedClassException;
import com.baan.owimpl.b3.jms.util.ILoggers;
import com.baan.owimpl.b3.jms.util.Util;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.NotHandledException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.NamingException;

class JmsMessageReader
implements ExceptionListener,
MessageListener {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$jms$JmsMessageReader == null ? (class$com$baan$owimpl$b3$jms$JmsMessageReader = JmsMessageReader.class$("com.baan.owimpl.b3.jms.JmsMessageReader")) : class$com$baan$owimpl$b3$jms$JmsMessageReader);
    private static final int INITIALIZED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static final String[] STATUS_DESC = new String[]{"Initialized", "Started", "Stopped"};
    private static final String STATUS_DESC_CHOICE_FORMAT = Util.getChoiceFormatString(STATUS_DESC, "Unknown");
    private final GetConfiguration m_getConfiguration;
    private int m_status;
    private BusListener m_listener = null;
    private QueueConnectionFactory m_queueConFact = null;
    private QueueConnection m_queueConnection = null;
    private QueueSession m_queueSession = null;
    private QueueReceiver m_queueReceiver = null;
    private Queue m_queue = null;
    static /* synthetic */ Class class$com$baan$owimpl$b3$jms$JmsMessageReader;

    public JmsMessageReader(GetConfiguration getConfiguration) throws JMSException, NamingException, UnexpectedClassException {
        s_logger.flowEntry("JmsMessageReader(GetConfiguration)");
        this.m_getConfiguration = getConfiguration;
        s_logger.message("Message Reader instance created.");
        s_logger.message("Preparing the JMS Framework.");
        this.m_queueConFact = getConfiguration.getQueueConnectionFactory();
        s_logger.message("Queue Connection Factory obtained: " + this.m_queueConFact);
        ILoggers.QCF.flowEntry("createQueueConnection()");
        this.m_queueConnection = this.m_queueConFact.createQueueConnection();
        ILoggers.QCF.flowExit("createQueueConnection()");
        s_logger.message("Queue Connection obtained: " + this.m_queueConnection);
        ILoggers.QCF.flowEntry("setExceptionListener(ExceptionListener)");
        this.m_queueConnection.setExceptionListener((ExceptionListener)this);
        ILoggers.QCF.flowExit("setExceptionListener(ExceptionListener)");
        ILoggers.QCONNECTION.flowEntry("createQueueSession(boolean,int)");
        this.m_queueSession = this.m_queueConnection.createQueueSession(false, 2);
        ILoggers.QCONNECTION.flowExit("createQueueSession(boolean,int)");
        this.m_queueReceiver = getConfiguration.createQueueReceiver(this.m_queueSession);
        ILoggers.QRECEIVER.flowEntry("setMessageListener(MessageListener)");
        this.m_queueReceiver.setMessageListener((MessageListener)this);
        ILoggers.QRECEIVER.flowExit("setMessageListener(MessageListener)");
        s_logger.flowExit("JmsMessageReader(GetConfiguration)");
    }

    public Queue getQueue() {
        s_logger.flowEntry("getQueue()");
        s_logger.flowExit("getQueue()");
        return this.m_queue;
    }

    public void start() throws JMSException {
        s_logger.flowEntry("start()");
        if (this.m_status == 1) {
            s_logger.flowExit("start()1");
            return;
        }
        ILoggers.QCONNECTION.flowEntry("start()");
        this.m_queueConnection.start();
        ILoggers.QCONNECTION.flowExit("start()");
        this.m_status = 1;
        s_logger.message("Queue Connection " + STATUS_DESC[this.m_status] + ". Can start receiving messages...");
        s_logger.flowExit("start()2");
    }

    public void stop() throws JMSException {
        s_logger.flowEntry("stop()");
        if (this.m_status == 2) {
            s_logger.flowExit("stop()1");
            return;
        }
        ILoggers.QCONNECTION.flowEntry("stop()");
        this.m_queueConnection.stop();
        ILoggers.QCONNECTION.flowExit("stop()");
        this.m_status = 2;
        s_logger.message("Queue Connection " + STATUS_DESC[this.m_status] + ". Cannot receive messages anymore. Bye Bye.");
        this.m_queue = null;
        this.m_queueSession = null;
        this.m_queueConnection = null;
        this.m_queueConFact = null;
        s_logger.flowExit("stop()2");
    }

    public void installBusListener(BusListener busListener) {
        s_logger.flowEntry("installBusListener(BusListener)");
        this.m_listener = busListener;
        s_logger.message("BusListener installed.");
        this.m_status = 0;
        s_logger.flowExit("installBusListener(BusListener)");
    }

    public void onMessage(Message message) {
        s_logger.flowEntry("onMessage(javax.jms.Message)");
        if (message == null) {
            s_logger.errorMessage("Received onMessage() event from JMS provider with null parameter.");
            return;
        }
        try {
            ILoggers.MESSAGE.flowEntry("acknowledge()");
            message.acknowledge();
            ILoggers.MESSAGE.flowExit("acknowledge()");
        }
        catch (JMSException jMSException) {
            s_logger.errorMessage("Could not acknowledge message.");
            s_logger.errorException(jMSException);
            s_logger.flowExit("onMessage(javax.jms.Message)1");
            return;
        }
        if (this.m_status != 1) {
            s_logger.errorMessage("The received message cannot be processed when the status of the message reader is '" + STATUS_DESC[this.m_status] + "'.");
            this.postDeadLetter(message);
            s_logger.flowExit("onMessage(javax.jms.Message)1.1");
            return;
        }
        s_logger.message("In onMessage, a new message is available.");
        if (!(message instanceof BytesMessage)) {
            s_logger.errorMessage("Received a message that is not of type javax.jms.BytesMessage.");
            this.postDeadLetter(message);
            return;
        }
        BytesMessage bytesMessage = (BytesMessage)message;
        try {
            byte[] byArray = new byte[4];
            ILoggers.BMESSAGE.flowEntry("readBytes(byte[],int)");
            bytesMessage.readBytes(byArray, 4);
            ILoggers.BMESSAGE.flowExit("readBytes(byte[],int)");
            s_logger.message("Magic Number: " + new String(byArray));
            if (byArray[0] != IJmsConstants.MAGIC_NUMBER[0] || byArray[1] != IJmsConstants.MAGIC_NUMBER[1] || byArray[2] != IJmsConstants.MAGIC_NUMBER[2] || byArray[3] != IJmsConstants.MAGIC_NUMBER[3]) {
                s_logger.errorMessage("Received message with incorrect Magic Number (found " + byArray[0] + '.' + byArray[1] + '.' + byArray[2] + '.' + byArray[3] + ", expected " + IJmsConstants.MAGIC_NUMBER[0] + '.' + IJmsConstants.MAGIC_NUMBER[1] + '.' + IJmsConstants.MAGIC_NUMBER[2] + '.' + IJmsConstants.MAGIC_NUMBER[3] + ").");
                this.postDeadLetter((Message)bytesMessage);
                s_logger.flowExit("onMessage(javax.jms.Message)2");
                return;
            }
            s_logger.message("Magic Number OK, the message is indeed from our JMS implementation.");
            ILoggers.BMESSAGE.flowEntry("readInt()");
            int n = bytesMessage.readInt();
            ILoggers.BMESSAGE.flowExit("readInt()");
            s_logger.message("Format Major Version: " + n);
            if (n != 1) {
                s_logger.errorMessage("Received message with incorrect Format Major Version (found " + n + ", expected " + 1 + ").");
                this.postDeadLetter((Message)bytesMessage);
                s_logger.flowExit("onMessage(javax.jms.Message)3");
                return;
            }
            s_logger.message("Format Major Version OK, the message is of the correct format.");
            ILoggers.BMESSAGE.flowEntry("readInt()");
            int n2 = bytesMessage.readInt();
            ILoggers.BMESSAGE.flowExit("readInt()");
            s_logger.message("Format Minor Version: " + n2);
            if (n2 != 1) {
                s_logger.message("Received message with Format Minor Version that is newer or older (found " + n2 + ", current is " + 1 + "); should be compatible; continuing.");
            }
            s_logger.message("Format Minor Version OK.");
            ILoggers.BMESSAGE.flowEntry("readInt()");
            int n3 = bytesMessage.readInt();
            ILoggers.BMESSAGE.flowExit("readInt()");
            s_logger.message("The messsage length is " + n3);
            byte[] byArray2 = new byte[n3];
            ILoggers.BMESSAGE.flowEntry("readBytes(byte[],int)");
            int n4 = bytesMessage.readBytes(byArray2, n3);
            ILoggers.BMESSAGE.flowExit("readBytes(byte[],int)");
            if (n4 < 0) {
                s_logger.message("Cannot read the actual message Data from the Bytes Message.");
                this.postDeadLetter((Message)bytesMessage);
                s_logger.flowExit("onMessage(javax.jms.Message)4");
                return;
            }
            s_logger.message("Read " + n4 + " bytes from the Message. Constructing OW message.");
            com.eibus.connection.Message message2 = new com.eibus.connection.Message(byArray2);
            ILoggers.BMESSAGE.flowEntry("getStringProperty(String)");
            String string = bytesMessage.getStringProperty("B3_SENDER_GUID");
            ILoggers.BMESSAGE.flowExit("getStringProperty(String)");
            if (string != null) {
                ILoggers.BMESSAGE.flowEntry("getJMSReplyTo()");
                Destination destination = bytesMessage.getJMSReplyTo();
                ILoggers.BMESSAGE.flowExit("getJMSReplyTo()");
                if (destination == null) {
                    s_logger.errorMessage("Received a JMS message with valid sender GUID (" + string + ") but no JMSReplyTo field.");
                    this.postDeadLetter((Message)bytesMessage);
                    s_logger.flowExit("onMessage(javax.jms.Message)4.1");
                    return;
                }
                if (!(destination instanceof Queue)) {
                    s_logger.errorMessage("Received a JMS message with a valid JMSReplyTo field (replyTo=" + destination + ") but the associated object is not of type javax.jms.Queue (it is of type " + destination.getClass().getName() + ").");
                    this.postDeadLetter((Message)bytesMessage);
                    return;
                }
                Queue queue = (Queue)destination;
                ConfigurationManager.addReplyDestination(string, queue, this.m_getConfiguration);
            }
            s_logger.message("Passing the message to the bus listener " + this.m_listener);
            this.m_listener.onReceive(message2);
        }
        catch (NotHandledException notHandledException) {
            s_logger.message("Listener could not handle the message. Ignoring it. Exception: " + notHandledException);
            this.postDeadLetter(message);
        }
        catch (JMSException jMSException) {
            s_logger.message("Error during the read operation on the the incoming message " + (Object)((Object)jMSException));
            this.postDeadLetter(message);
        }
        catch (ConfigurationException configurationException) {
            s_logger.message("Configuration problem detected while receiving message: " + configurationException);
            this.postDeadLetter(message);
        }
        s_logger.flowExit("onMessage(javax.jms.Message)5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postDeadLetter(Message message) {
        s_logger.flowEntry("handleDeadLetter(javax.jms.Message)");
        try {
            Queue queue = this.m_getConfiguration.getDeadLetterQueue();
            if (queue == null) {
                s_logger.errorMessage(this.m_getConfiguration.getClass().getName() + ".getDeadLetterQueue() returned null (which should never happen)");
                s_logger.flowExit("handleDeadLetter(javax.jms.Message)1");
                return;
            }
            ILoggers.QCONNECTION.flowEntry("createQueueSession(boolean,int)");
            QueueSession queueSession = this.m_queueConnection.createQueueSession(false, 1);
            ILoggers.QCONNECTION.flowExit("createQueueSession(boolean,int)");
            try {
                QueueSender queueSender = queueSession.createSender(queue);
                ILoggers.QSENDER.flowEntry("send(Message)");
                queueSender.send(message);
                ILoggers.QSENDER.flowExit("send(Message)");
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                queueSession.close();
                throw throwable;
            }
            queueSession.close();
            s_logger.flowExit("handleDeadLetter(javax.jms.Message)2");
        }
        catch (JMSException jMSException) {
            s_logger.errorMessage("While posting to dead letter queue:");
            s_logger.errorException(jMSException);
        }
        catch (NamingException namingException) {
            s_logger.errorMessage("Could not retrieve JMS configuration object for dead letter queue:");
            s_logger.errorException(namingException);
        }
        catch (UnexpectedClassException unexpectedClassException) {
            s_logger.errorMessage("While posting to dead letter queue:");
            s_logger.errorException(unexpectedClassException);
        }
        s_logger.flowExit("handleDeadLetter(javax.jms.Message)3");
    }

    public void onException(JMSException jMSException) {
        s_logger.flowEntry("onException(JMSException p_exception)");
        s_logger.errorMessage("Asynchronous exception report from JMS provider: ");
        s_logger.errorException(jMSException);
        s_logger.flowExit("onException(JMSException p_exception)");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

