/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms;

import com.baan.owimpl.b3.jms.ConfigurationException;
import com.baan.owimpl.b3.jms.ConfigurationManager;
import com.baan.owimpl.b3.jms.GetConfiguration;
import com.baan.owimpl.b3.jms.IJmsConstants;
import com.baan.owimpl.b3.jms.JmsMessageReader;
import com.baan.owimpl.b3.jms.JmsMessageSender;
import com.baan.owimpl.b3.jms.PutConfiguration;
import com.baan.owimpl.b3.jms.UnexpectedClassException;
import com.baan.owimpl.b3.jms.uri.ConfiguredRemainder;
import com.baan.owimpl.b3.jms.uri.Parser;
import com.baan.owimpl.b3.jms.uri.parser.ParseException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.URI;
import javax.jms.JMSException;
import javax.naming.NamingException;

public class JmsConnection
implements IConnection,
IJmsConstants {
    private ConfigurationManager m_configurationManager = null;
    private BusListener m_listener = null;
    private JmsMessageReader m_messageReader = null;
    private boolean m_initialized = false;
    private static final int OPENED = 1;
    private static final int CLOSED = 2;
    private int m_state;
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$jms$JmsConnection == null ? (class$com$baan$owimpl$b3$jms$JmsConnection = JmsConnection.class$("com.baan.owimpl.b3.jms.JmsConnection")) : class$com$baan$owimpl$b3$jms$JmsConnection);
    static /* synthetic */ Class class$com$baan$owimpl$b3$jms$JmsConnection;

    public JmsConnection() {
        s_logger.flowEntry("JmsConnection()");
        s_logger.message("Created JMS Connection instance.");
        s_logger.flowExit("JmsConnection()");
    }

    public void initialize(BusComponent busComponent) throws BusException {
        s_logger.flowEntry("initialize(BusComponent)");
        if (this.m_initialized) {
            s_logger.flowExit("initialize(BusComponent)1");
            return;
        }
        if (busComponent == null) {
            s_logger.flowExit("initialize(BusComponent)2");
            throw new BusException("Bus Component cannot be null.");
        }
        s_logger.message("Initializing Bus Component: " + busComponent);
        try {
            this.m_configurationManager = ConfigurationManager.getConfigurationManager(busComponent);
        }
        catch (ParseException parseException) {
            s_logger.flowExit("initialize(BusComponent)3");
            throw new BusException("Could not parse bus component: " + parseException.getMessage());
        }
        if (this.m_configurationManager == null) {
            s_logger.flowExit("initialize(BusComponent)4");
            throw new BusException("Could not initialise the connection; no valid bus component specified.");
        }
        this.initialize();
        s_logger.flowExit("initialize(BusComponent)5");
    }

    public void initialize(ConnectionPoint connectionPoint) throws BusException {
        s_logger.flowEntry("initialize(ConnectionPoint)");
        if (this.m_initialized) {
            s_logger.flowExit("initialize(ConnectionPoint)1");
            return;
        }
        if (connectionPoint == null) {
            s_logger.flowExit("initialize(ConnectionPoint)2");
            throw new BusException("Null argument not allowed for initialize.");
        }
        s_logger.message("Initializing ConnectionPoint on " + this);
        try {
            this.m_configurationManager = ConfigurationManager.getConfigurationManager(connectionPoint);
        }
        catch (ParseException parseException) {
            s_logger.flowExit("initialize(ConnectionPoint)3");
            throw new BusException("Could not parse connection point: " + parseException.getMessage());
        }
        this.initialize();
        s_logger.flowExit("initialize(ConnectionPoint)4");
    }

    private void initialize() throws BusException {
        s_logger.flowEntry("initialize()");
        try {
            GetConfiguration getConfiguration = this.m_configurationManager.getGetConfiguration();
            this.m_messageReader = new JmsMessageReader(getConfiguration);
        }
        catch (JMSException jMSException) {
            s_logger.message("JMS Linked Exception: " + jMSException.getLinkedException());
            s_logger.flowExit("initialize()1");
            throw new BusException((Exception)((Object)jMSException));
        }
        catch (NamingException namingException) {
            s_logger.flowExit("initialize()2");
            throw new BusException(namingException);
        }
        catch (UnexpectedClassException unexpectedClassException) {
            s_logger.flowExit("initialize()3");
            throw new BusException(unexpectedClassException);
        }
        this.m_initialized = true;
        s_logger.flowExit("initialize()4");
    }

    public synchronized void installBusListener(BusListener busListener) throws BusException {
        s_logger.flowEntry("installBusListener(BusListener)");
        if (busListener == null) {
            s_logger.flowExit("installBusListener(BusListener)1");
            throw new BusException("Null argument not allowed for installBusListener().");
        }
        s_logger.message("Installing Buslistener on " + this);
        this.m_listener = busListener;
        if (this.m_messageReader == null) {
            s_logger.flowExit("installBusListener(BusListener)2");
            throw new BusException("Cannot Install Listener, the object is not yet initialized.");
        }
        this.m_messageReader.installBusListener(busListener);
        s_logger.flowExit("installBusListener(BusListener)3");
    }

    public void open() throws BusException {
        s_logger.flowEntry("open()");
        if (this.m_messageReader == null) {
            s_logger.flowExit("open()1");
            throw new BusException("Connection not yet initialized, cannot open.");
        }
        try {
            this.m_messageReader.start();
        }
        catch (JMSException jMSException) {
            s_logger.flowExit("open()2");
            throw new BusException((Exception)((Object)jMSException));
        }
        this.m_state = 1;
        s_logger.message("Connection Open on " + this + ". Message Reader Started.");
        s_logger.flowExit("open()3");
    }

    public void close() throws BusException {
        s_logger.flowEntry("close()");
        if (this.m_messageReader == null) {
            s_logger.flowExit("close()1");
            throw new BusException("Connection not initialized, cannot close.");
        }
        try {
            this.m_messageReader.stop();
        }
        catch (JMSException jMSException) {
            s_logger.flowExit("close()2");
            throw new BusException((Exception)((Object)jMSException));
        }
        this.m_state = 2;
        s_logger.message("Connection closed on " + this + ". Message Reader stopped, no more messages will be recieved.");
        s_logger.flowExit("close()3");
    }

    public synchronized void send(Message message) throws BusException {
        s_logger.flowEntry("send(Message)");
        s_logger.message("Sending on Connection " + this);
        if (this.m_state != 1) {
            s_logger.flowExit("send(Message)1");
            throw new BusException("Cannot send message, the object is not opened.");
        }
        try {
            PutConfiguration putConfiguration = this.m_configurationManager.getPutConfiguration(message);
            if (putConfiguration == null) {
                s_logger.flowExit("send(Message)2");
                throw new BusException("Cannot send the message " + message + ". No valid receiver specified.");
            }
            JmsMessageSender jmsMessageSender = new JmsMessageSender(putConfiguration);
            jmsMessageSender.send(message);
            s_logger.message("Sent message " + message + " through " + this + ".\n");
        }
        catch (JMSException jMSException) {
            s_logger.flowExit("send(Message)3");
            throw new BusException((Exception)((Object)jMSException));
        }
        catch (ParseException parseException) {
            s_logger.flowExit("send(Message)4");
            throw new BusException("Could not parse destination URI: " + parseException.getMessage());
        }
        catch (NamingException namingException) {
            s_logger.flowExit("send(Message)5");
            throw new BusException(namingException);
        }
        catch (UnexpectedClassException unexpectedClassException) {
            s_logger.flowExit("send(Message)6");
            throw new BusException(unexpectedClassException);
        }
        catch (ConfigurationException configurationException) {
            s_logger.flowExit("send(Message)7");
            throw new BusException(configurationException);
        }
        s_logger.flowExit("send(Message)8");
    }

    public boolean isURIVariable(URI uRI) {
        try {
            ConfiguredRemainder configuredRemainder = Parser.getConfiguredRemainder(uRI);
            if (configuredRemainder.getGetSection().getQueueReference() == null) {
                s_logger.flowMessage("JmsConnection.isURIVariable = true");
                return true;
            }
            s_logger.flowMessage("JmsConnection.isURIVariable = false");
            return false;
        }
        catch (ParseException parseException) {
            s_logger.errorMessage(parseException.getMessage());
            return false;
        }
    }

    public String toString() {
        return "com.baan.owimpl.b3.jms.JmsConnection";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

