/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms;

import com.baan.owimpl.b3.jms.AbstractConfiguration;
import com.baan.owimpl.b3.jms.UnexpectedClassException;
import com.baan.owimpl.b3.jms.uri.ConfiguredRemainder;
import com.baan.owimpl.b3.jms.uri.GetQueueJndiReference;
import com.baan.owimpl.b3.jms.uri.GetSection;
import com.baan.owimpl.b3.jms.uri.Parser;
import com.baan.owimpl.b3.jms.uri.RuntimeRemainder;
import com.baan.owimpl.b3.jms.uri.SimpleJndiReference;
import com.baan.owimpl.b3.jms.uri.parser.ParseException;
import com.baan.owimpl.b3.jms.util.ILoggers;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.naming.NamingException;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDGenerator;

final class GetConfiguration
extends AbstractConfiguration {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$jms$GetConfiguration == null ? (class$com$baan$owimpl$b3$jms$GetConfiguration = GetConfiguration.class$("com.baan.owimpl.b3.jms.GetConfiguration")) : class$com$baan$owimpl$b3$jms$GetConfiguration);
    private static final String WDM_TEMPQ_WITH_VARPOL = "ConnectionPoint specifies a temporary queue but policy is variable.";
    private final ConnectionPoint m_connectionPoint;
    private final ConfiguredRemainder m_remainder;
    private final String m_contextFactoryName;
    private final String m_providerUrl;
    private Queue m_queue = null;
    private String m_guid = null;
    static /* synthetic */ Class class$com$baan$owimpl$b3$jms$GetConfiguration;
    static /* synthetic */ Class class$javax$jms$QueueConnectionFactory;
    static /* synthetic */ Class class$javax$jms$Queue;

    GetConfiguration(ConnectionPoint connectionPoint) throws ParseException, MalformedURIException {
        s_logger.flowEntry("GetConfiguration(ConnectionPoint)");
        this.m_connectionPoint = connectionPoint;
        URI uRI = connectionPoint.getURI();
        this.m_remainder = Parser.getConfiguredRemainder(uRI);
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null) {
            this.m_contextFactoryName = getSection.getJndiContextFactory();
            this.m_providerUrl = getSection.getJndiProviderUrl();
        } else {
            this.m_contextFactoryName = null;
            this.m_providerUrl = null;
        }
        s_logger.flowExit("GetConfiguration(ConnectionPoint)");
    }

    final String getJndiContextFactoryName() {
        s_logger.flowEntry("getJndiContextFactoryName()");
        s_logger.flowExit("getJndiContextFactoryName()");
        return this.m_contextFactoryName;
    }

    final String getJndiProviderUrl() {
        s_logger.flowEntry("getJndiProviderUrl()");
        s_logger.flowExit("getJndiProviderUrl()");
        return this.m_providerUrl;
    }

    String getQcfJndiContextFactoryName() {
        SimpleJndiReference simpleJndiReference;
        s_logger.flowEntry("getQcfJndiContextFactoryName()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (simpleJndiReference = getSection.getQueueConnectionFactoryReference()) != null) {
            string = simpleJndiReference.getContextFactory();
        }
        if (string == null) {
            string = this.getJndiContextFactoryName();
        }
        s_logger.flowExit("getQcfJndiContextFactoryName()2");
        return string;
    }

    String getQcfJndiProviderUrl() {
        SimpleJndiReference simpleJndiReference;
        s_logger.flowEntry("getQcfJndiProviderUrl()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (simpleJndiReference = getSection.getQueueConnectionFactoryReference()) != null) {
            string = simpleJndiReference.getProviderUrl();
        }
        if (string == null) {
            string = this.getJndiProviderUrl();
        }
        s_logger.flowExit("getQcfJndiProviderUrl()2");
        return string;
    }

    String getQcfJndiName() {
        SimpleJndiReference simpleJndiReference;
        s_logger.flowEntry("getQcfJndiName()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (simpleJndiReference = getSection.getQueueConnectionFactoryReference()) != null) {
            string = simpleJndiReference.getName();
        }
        if (string == null) {
            string = "cn=defaultQueueConnectionFactory";
        }
        s_logger.flowExit("getQcfJndiName()2");
        return string;
    }

    String getQueueJndiContextFactoryName() {
        GetQueueJndiReference getQueueJndiReference;
        s_logger.flowEntry("getQueueJndiContextFactoryName()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (getQueueJndiReference = getSection.getQueueReference()) != null) {
            string = getQueueJndiReference.getContextFactory();
        }
        if (string == null) {
            string = this.getJndiContextFactoryName();
        }
        s_logger.flowExit("getQueueJndiContextFactoryName()2");
        return string;
    }

    String getQueueJndiProviderUrl() {
        GetQueueJndiReference getQueueJndiReference;
        s_logger.flowEntry("getQueueJndiProviderUrl()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (getQueueJndiReference = getSection.getQueueReference()) != null) {
            string = getQueueJndiReference.getProviderUrl();
        }
        if (string == null) {
            string = this.getJndiProviderUrl();
        }
        s_logger.flowExit("getQueueJndiProviderUrl()2");
        return string;
    }

    String getQueueJndiName() {
        GetQueueJndiReference getQueueJndiReference;
        s_logger.flowEntry("getQueueJndiName()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (getQueueJndiReference = getSection.getQueueReference()) != null) {
            string = getQueueJndiReference.getName();
        }
        s_logger.flowExit("getQueueJndiName()3");
        return string;
    }

    String getDlqJndiContextFactoryName() {
        SimpleJndiReference simpleJndiReference;
        s_logger.flowEntry("getDlqJndiContextFactoryName()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (simpleJndiReference = getSection.getDeadLetterQueueReference()) != null) {
            string = simpleJndiReference.getContextFactory();
        }
        if (string == null) {
            string = this.getJndiContextFactoryName();
        }
        s_logger.flowExit("getDlqJndiContextFactoryName()2");
        return string;
    }

    String getDlqJndiProviderUrl() {
        SimpleJndiReference simpleJndiReference;
        s_logger.flowEntry("getDlqJndiProviderUrl()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (simpleJndiReference = getSection.getDeadLetterQueueReference()) != null) {
            string = simpleJndiReference.getProviderUrl();
        }
        if (string == null) {
            string = this.getJndiProviderUrl();
        }
        s_logger.flowExit("getDlqJndiProviderUrl()2");
        return string;
    }

    String getDlqJndiName() {
        SimpleJndiReference simpleJndiReference;
        s_logger.flowEntry("getDlqJndiName()");
        String string = null;
        GetSection getSection = this.m_remainder.getGetSection();
        if (getSection != null && (simpleJndiReference = getSection.getDeadLetterQueueReference()) != null) {
            string = simpleJndiReference.getName();
        }
        if (string == null) {
            string = "cn=deadLetterQueue";
        }
        s_logger.flowExit("getDlqJndiName()2");
        return string;
    }

    QueueConnectionFactory getQueueConnectionFactory() throws NamingException, UnexpectedClassException {
        s_logger.flowEntry("getQueueConnectionFactory()");
        String string = this.getQcfJndiContextFactoryName();
        String string2 = this.getQcfJndiProviderUrl();
        String string3 = this.getQcfJndiName();
        QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)this.getDirectoryObject(string, string2, string3, class$javax$jms$QueueConnectionFactory == null ? (class$javax$jms$QueueConnectionFactory = GetConfiguration.class$("javax.jms.QueueConnectionFactory")) : class$javax$jms$QueueConnectionFactory);
        s_logger.flowExit("getQueueConnectionFactory()");
        return queueConnectionFactory;
    }

    QueueReceiver createQueueReceiver(QueueSession queueSession) throws JMSException, NamingException, UnexpectedClassException {
        s_logger.flowEntry("createQueueReceiver(QueueSession)");
        Queue queue = this.retrieveQueue(queueSession);
        ILoggers.QSESSION.flowEntry("createReceiver(Queue)");
        QueueReceiver queueReceiver = queueSession.createReceiver(queue);
        ILoggers.QSESSION.flowExit("createReceiver(Queue)");
        s_logger.flowExit("createQueueReceiver(QueueSession)");
        return queueReceiver;
    }

    private Queue getQueue() {
        s_logger.flowEntry("getQueue()");
        if (this.m_queue != null) {
            s_logger.flowExit("getQueue()1");
            return this.m_queue;
        }
        s_logger.flowExit("getQueue()2");
        throw new IllegalStateException("There is a bug in the JMS transport code. " + this.getClass().getName() + ".getQueue() has been called before the m_queue member variable was defined.");
    }

    Queue getDeadLetterQueue() throws NamingException, UnexpectedClassException {
        s_logger.flowEntry("getDeadLetterQueue()");
        String string = this.getDlqJndiContextFactoryName();
        String string2 = this.getDlqJndiProviderUrl();
        String string3 = this.getDlqJndiName();
        Queue queue = (Queue)this.getDirectoryObject(string, string2, string3, class$javax$jms$Queue == null ? (class$javax$jms$Queue = GetConfiguration.class$("javax.jms.Queue")) : class$javax$jms$Queue);
        s_logger.flowExit("getDeadLetterQueue()");
        return queue;
    }

    private Queue retrieveQueue(QueueSession queueSession) throws JMSException, NamingException, UnexpectedClassException {
        s_logger.flowEntry("retrieveQueue(QueueSession)");
        if (this.m_queue != null) {
            s_logger.flowExit("retrieveQueue(QueueSession)1");
            return this.m_queue;
        }
        String string = this.getQueueJndiContextFactoryName();
        String string2 = this.getQueueJndiProviderUrl();
        String string3 = this.getQueueJndiName();
        this.m_queue = (Queue)this.getDirectoryObject(string, string2, string3, class$javax$jms$Queue == null ? (class$javax$jms$Queue = GetConfiguration.class$("javax.jms.Queue")) : class$javax$jms$Queue);
        if (this.m_queue == null) {
            ILoggers.QSESSION.flowEntry("createTemporaryQueue()");
            this.m_queue = queueSession.createTemporaryQueue();
            ILoggers.QSESSION.flowExit("createTemporaryQueue()");
            UUIDGenerator uUIDGenerator = UUIDGenerator.getInstance();
            UUID uUID = uUIDGenerator.generateRandomBasedUUID();
            this.m_guid = uUID.toString();
            RuntimeRemainder runtimeRemainder = new RuntimeRemainder(this.m_remainder, this.m_guid);
            String string4 = runtimeRemainder.toUriString();
            URI uRI = null;
            try {
                uRI = URI.createURI(string4);
            }
            catch (MalformedURIException malformedURIException) {
                throw new RuntimeException("URI.createURI() failed this should never happen: " + malformedURIException);
            }
            this.m_connectionPoint.setURI(uRI);
            String string5 = null;
            try {
                string5 = this.m_connectionPoint.getPolicy();
            }
            catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                s_logger.message("ConnectionPoint's policy attribute is not specified.");
            }
            if (!"variable".equalsIgnoreCase(string5)) {
                s_logger.errorMessage("Warning: ConnectionPoint specifies a temporary queue but policy is variable.");
            }
        }
        s_logger.flowExit("retrieveQueue(QueueSession)2");
        return this.m_queue;
    }

    void setReplyToProperties(Message message) throws JMSException {
        s_logger.flowEntry("setReplyToProperties(Message)");
        if (this.m_guid != null) {
            ILoggers.MESSAGE.flowEntry("setStringProperty(String,String)");
            message.setStringProperty("B3_SENDER_GUID", this.m_guid);
            ILoggers.MESSAGE.flowExit("setStringProperty(String,String)");
            Queue queue = this.getQueue();
            ILoggers.MESSAGE.flowEntry("setJMSReplyTo(Queue)");
            message.setJMSReplyTo((Destination)queue);
            ILoggers.MESSAGE.flowExit("setJMSReplyTo(Queue)");
        }
        s_logger.flowExit("setReplyToProperties(Message)");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

