/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.jms;

import com.baan.owimpl.b3.jms.ConfigurationException;
import com.baan.owimpl.b3.jms.GetConfiguration;
import com.baan.owimpl.b3.jms.PutConfiguration;
import com.baan.owimpl.b3.jms.ReplyDestination;
import com.baan.owimpl.b3.jms.uri.parser.ParseException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.Message;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Queue;

final class ConfigurationManager {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$jms$ConfigurationManager == null ? (class$com$baan$owimpl$b3$jms$ConfigurationManager = ConfigurationManager.class$("com.baan.owimpl.b3.jms.ConfigurationManager")) : class$com$baan$owimpl$b3$jms$ConfigurationManager);
    private static final Hashtable s_replyDestinations = new Hashtable();
    private final GetConfiguration m_getConfiguration;
    static /* synthetic */ Class class$com$baan$owimpl$b3$jms$ConfigurationManager;
    static /* synthetic */ Class class$com$baan$owimpl$b3$jms$ConfigurationManager$ReplyDestinationReference;

    private ConfigurationManager(ConnectionPoint connectionPoint) throws ParseException, MalformedURIException {
        this.m_getConfiguration = new GetConfiguration(connectionPoint);
    }

    static ConfigurationManager getConfigurationManager(ConnectionPoint connectionPoint) throws MalformedURIException, ParseException {
        s_logger.flowEntry("getConfigurationManager(ConnectionPoint)");
        ConfigurationManager configurationManager = new ConfigurationManager(connectionPoint);
        s_logger.flowExit("getConfigurationManager(ConnectionPoint)");
        return configurationManager;
    }

    static ConfigurationManager getConfigurationManager(BusComponent busComponent) throws MalformedURIException, ParseException {
        s_logger.flowEntry("getConfigurationManager(BusComponent)");
        ConnectionPoint connectionPoint = ConfigurationManager.getJmsConnectionPoint(busComponent);
        if (connectionPoint == null) {
            s_logger.flowExit("getConfigurationManager(BusComponent)1");
            return null;
        }
        ConfigurationManager configurationManager = new ConfigurationManager(connectionPoint);
        s_logger.flowExit("getConfigurationManager(BusComponent)2");
        return configurationManager;
    }

    private static URI getJmsUri(BusComponent busComponent) throws MalformedURIException {
        s_logger.flowEntry("getJmsUri(BusComponent)");
        ConnectionPoint connectionPoint = ConfigurationManager.getJmsConnectionPoint(busComponent);
        if (connectionPoint == null) {
            s_logger.flowExit("getJmsUri(BusComponent)1");
            return null;
        }
        URI uRI = connectionPoint.getURI();
        s_logger.flowExit("getJmsUri(BusComponent)2");
        return uRI;
    }

    private static ConnectionPoint getJmsConnectionPoint(BusComponent busComponent) throws MalformedURIException {
        s_logger.flowEntry("getJmsConnectionPoint(BusComponent)");
        ConnectionPoint connectionPoint = busComponent.getPreferredConnection();
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        while (true) {
            URI uRI;
            if (connectionPoint != null && (uRI = connectionPoint.getURI()).getProtocol().equals("jms")) {
                s_logger.message("Retrieved Connection Point: " + connectionPoint + "\n");
                s_logger.flowExit("getJmsConnectionPoint(BusComponent)1");
                return connectionPoint;
            }
            if (!enumeration2.hasMoreElements()) break;
            connectionPoint = (ConnectionPoint)enumeration2.nextElement();
        }
        s_logger.message("Could not find a Connection Point.");
        s_logger.flowExit("getJmsConnectionPoint(BusComponent)2");
        return null;
    }

    static void addReplyDestination(String string, Queue queue, GetConfiguration getConfiguration) throws ConfigurationException {
        s_logger.flowEntry("addReplyDestination(String)");
        ReplyDestinationReference.addReference(string, queue, getConfiguration);
        s_logger.flowExit("addReplyDestination(String)1");
    }

    static ReplyDestination removeReplyDestination(String string) {
        s_logger.flowEntry("removeReplyDestination(String)");
        ReplyDestination replyDestination = ReplyDestinationReference.removeReference(string);
        s_logger.flowExit("removeReplyDestination(String)1");
        return replyDestination;
    }

    GetConfiguration getGetConfiguration() {
        s_logger.flowEntry("getGetConfiguration()");
        s_logger.flowExit("getGetConfiguration()");
        return this.m_getConfiguration;
    }

    PutConfiguration getPutConfiguration(Message message) throws MalformedURIException, ParseException {
        Object object;
        s_logger.flowEntry("getPutConfiguration(Message)");
        URI uRI = message.getURI();
        if (uRI == null && (object = message.getReceiver()) != null) {
            uRI = ConfigurationManager.getJmsUri((BusComponent)object);
        }
        if (uRI == null) {
            s_logger.flowExit("getPutConfiguration(Message)1");
            return null;
        }
        object = new PutConfiguration(uRI, this.getGetConfiguration());
        s_logger.flowExit("getPutConfiguration(Message)2");
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ReplyDestinationReference {
        private static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$jms$ConfigurationManager$ReplyDestinationReference == null ? (class$com$baan$owimpl$b3$jms$ConfigurationManager$ReplyDestinationReference = ConfigurationManager.class$("com.baan.owimpl.b3.jms.ConfigurationManager$ReplyDestinationReference")) : class$com$baan$owimpl$b3$jms$ConfigurationManager$ReplyDestinationReference);
        private final ReplyDestination m_replyDestination;
        private int m_referenceCount = 1;

        ReplyDestinationReference(ReplyDestination replyDestination) {
            this.m_replyDestination = replyDestination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void addReference(String string, Queue queue, GetConfiguration getConfiguration) throws ConfigurationException {
            s_logger.flowEntry("addReference(String,Queue,GetConfiguration)");
            Hashtable hashtable = s_replyDestinations;
            synchronized (hashtable) {
                ReplyDestination replyDestination = new ReplyDestination(queue, getConfiguration);
                ReplyDestinationReference replyDestinationReference = (ReplyDestinationReference)s_replyDestinations.get(string);
                if (replyDestinationReference != null) {
                    ReplyDestination replyDestination2 = replyDestinationReference.m_replyDestination;
                    replyDestination2.checkThatItEquals(replyDestination);
                    ++replyDestinationReference.m_referenceCount;
                } else {
                    ReplyDestinationReference replyDestinationReference2 = new ReplyDestinationReference(replyDestination);
                    s_replyDestinations.put(string, replyDestinationReference2);
                }
            }
            s_logger.flowExit("addReference(String,Queue,GetConfiguration)");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ReplyDestination removeReference(String string) {
            s_logger.flowEntry("removeReference(String)");
            Hashtable hashtable = s_replyDestinations;
            synchronized (hashtable) {
                ReplyDestinationReference replyDestinationReference = (ReplyDestinationReference)s_replyDestinations.get(string);
                if (replyDestinationReference == null) {
                    s_logger.flowExit("removeReference(String)1");
                    throw new IllegalStateException("Sender GUID " + string + " is not known; internal state is probably corrupt.");
                }
                --replyDestinationReference.m_referenceCount;
                if (replyDestinationReference.m_referenceCount <= 0) {
                    s_replyDestinations.remove(string);
                }
                s_logger.flowExit("removeReference(String)2");
                return replyDestinationReference.m_replyDestination;
            }
        }
    }
}

