/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.dotnet;

import com.baan.b3.server.IServerApplicationCallBack;
import com.baan.b3.server.ServerActivationCallBack;
import com.baan.b3.server.ServerLicenseException;
import com.baan.owimpl.b3.dotnet.CPPDispatch;
import com.baan.owimpl.b3.dotnet.DotNetServerComponentInfo;
import com.baan.owimpl.b3.dotnet.ServerImpl;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.io.IOException;

public class Server
implements IServerApplicationCallBack {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.b3.dotnet", "Server");
    public static String ASM_PORT;

    public Server(String string) {
        int n;
        ServerImpl serverImpl = null;
        try {
            serverImpl = new ServerImpl(this, null);
            serverImpl.enableDeactivation();
            n = CPPDispatch.initializeCOMImplLocal();
            if (n != 0) {
                System.out.println("Error in initializing COM Implementation (" + n + ")");
                serverImpl.stopServerRuntime();
                System.exit(1);
            }
        }
        catch (ServerLicenseException serverLicenseException) {
            System.out.println(serverLicenseException.toString());
            System.exit(1);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError.getMessage());
            serverImpl.stopServerRuntime();
            System.exit(1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("Cannot start connector, OW Adapter not installed, Check your installation");
            System.exit(1);
        }
        n = serverImpl.startComponent(string);
        if (n < 0) {
            System.out.println("An error occured while starting BusComponent '" + string + "'");
            System.exit(1);
        }
        try {
            System.out.println("Press any key to stop Server ...");
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        serverImpl.stopComponent(n);
        try {
            CPPDispatch.closeCOMImpl();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        serverImpl.stopServerRuntime();
    }

    public Server(String string, ServerActivationCallBack serverActivationCallBack) {
        ServerImpl serverImpl = null;
        try {
            serverImpl = new ServerImpl(this, null);
            int n = CPPDispatch.initializeCOMImplLocal();
            if (n != 0) {
                serverActivationCallBack.setActivationError("Error initializing COM/.NET (" + n + ")");
                serverActivationCallBack.returnActivationError();
                serverImpl.stopServerRuntime();
                return;
            }
        }
        catch (ServerLicenseException serverLicenseException) {
            s_logger.message(".NET SERVER: License error, " + serverLicenseException.toString());
            serverActivationCallBack.setActivationError(serverLicenseException.toString());
            serverActivationCallBack.returnActivationError();
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            s_logger.message(".NET SERVER: Installation error, " + unsatisfiedLinkError.toString());
            serverActivationCallBack.setActivationError(unsatisfiedLinkError.toString());
            serverActivationCallBack.returnActivationError();
            serverImpl.stopServerRuntime();
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            s_logger.message(".NET SERVER: NoClassDefFoundError error, Check your installation");
            serverActivationCallBack.setActivationError(".NET SERVER: NoClassDefFoundError error, Check your installation");
            serverActivationCallBack.returnActivationError();
            return;
        }
        serverImpl.startActivationComponent(string, serverActivationCallBack);
    }

    public void output(String string) {
        System.out.println(string);
    }

    public void error(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        System.out.println("Server for .NET");
        System.out.println(new DotNetServerComponentInfo().getCopyrightMessage());
        System.out.println();
        if (stringArray.length == 1) {
            string = stringArray[0];
            s_logger.message(".NET SERVER: Starting BC='" + string + "'");
            new Server(string);
        } else if (stringArray.length == 3) {
            String string3 = stringArray[1];
            if (ASM_PORT.equalsIgnoreCase(string3)) {
                string = stringArray[0];
                string2 = stringArray[2];
                s_logger.message(".NET SERVER: Starting with ASM Activation BC='" + string + "' ASM-Port='" + string2 + "'");
                ServerActivationCallBack serverActivationCallBack = ServerActivationCallBack.getActivationCallBackASM();
                int n = Integer.parseInt(string2);
                serverActivationCallBack.setASMPortNr(n);
                new Server(string, serverActivationCallBack);
            } else {
                s_logger.message(".NET SERVER: Wrong arguments passed. expecting '" + ASM_PORT + "'");
                System.out.println("usage : Server <BusComponentId> [-asmp <ASM Port Nr>]");
                System.exit(1);
            }
        } else {
            System.out.println("usage : Server <BusComponentId> [-asmp <ASM Port Nr>]");
            s_logger.message(".NET SERVER: Started with incorrect arguments, showing usage.");
            System.exit(1);
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_DOTNET_SERVER);
        ASM_PORT = "-asmp";
    }
}

