/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database_direct;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IParameterMetaData;
import com.baan.ow.b3.database.IPreparedStatement;
import com.baan.ow.b3.database.IResultSet;
import com.baan.ow.b3.database.IResultSetMetaData;
import com.baan.owimpl.b3.database.Statement;
import com.baan.owimpl.b3.database_direct.ParameterMetaData;
import com.baan.owimpl.b3.database_direct.ResultSet;
import com.baan.owimpl.b3.database_direct.ResultSetMetaData;
import com.ssa.ow.BaanERP.ServerInstance;
import java.util.Vector;

public class PreparedStatement
extends com.baan.owimpl.b3.database_direct.Statement
implements IPreparedStatement {
    private Vector m_vParameters = new Vector();
    private IResultSetMetaData m_resultSetMetaData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement(ServerInstance serverInstance, String string) throws DatabaseException {
        super(serverInstance);
        Statement.s_logger.message("Prepare Statement with SQL ='" + string + "'");
        try {
            Object object = ServerInstance.SyncObject;
            synchronized (object) {
                this.m_statementID = serverInstance.DB_prepareStatement(string);
            }
        }
        catch (Exception exception) {
            String string2 = "Error, Preparing Statement " + exception.getMessage();
            Statement.s_logger.errorMessage(string2);
            throw new DatabaseException(string2, "08S01", 0);
        }
    }

    public void setParameter(int n, String string) throws DatabaseException {
        this.checkClosed();
        Statement.s_logger.flowMessage("setParameter index " + n + ", data='" + string + "'");
        if (n >= this.m_vParameters.size()) {
            this.m_vParameters.setSize(n);
        }
        this.m_vParameters.setElementAt(string, n - 1);
    }

    public IResultSetMetaData getMetaData() throws DatabaseException {
        this.checkClosed();
        if (this.m_resultSetMetaData == null) {
            this.m_resultSetMetaData = new ResultSetMetaData(this.m_serverInstance, this.m_statementID);
        }
        return this.m_resultSetMetaData;
    }

    public IParameterMetaData getParameterMetaData() throws DatabaseException {
        this.checkClosed();
        return new ParameterMetaData(this.m_serverInstance, this.m_statementID);
    }

    public void clearParameters() throws DatabaseException {
        this.m_vParameters = new Vector();
    }

    public boolean execute() throws DatabaseException {
        this.checkClosed();
        this.m_resultSet = this.executeQuery();
        return true;
    }

    public IResultSet executeQuery() throws DatabaseException {
        this.checkClosed();
        Object[] objectArray = new String[this.m_vParameters.size()];
        this.m_vParameters.copyInto(objectArray);
        return new ResultSet(this.m_serverInstance, this.m_statementID, (String[])objectArray);
    }
}

