/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database_direct;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IDatabaseInformation;
import com.baan.ow.b3.database.IDatabaseMetaData;
import com.baan.ow.b3.database.IPreparedStatement;
import com.baan.ow.b3.database.IStatement;
import com.baan.owimpl.b3.database_direct.DatabaseMetaData;
import com.baan.owimpl.b3.database_direct.Information;
import com.baan.owimpl.b3.database_direct.PreparedStatement;
import com.baan.owimpl.b3.database_direct.Statement;
import com.ssa.ow.BaanERP.DBDriver.Driver;
import com.ssa.ow.BaanERP.DBDriver.SQLException;
import com.ssa.ow.BaanERP.ServerInstance;

public class Connection
extends com.baan.owimpl.b3.database.Connection {
    private ServerInstance m_serverInstance = null;

    public Connection(String string, String string2, String string3, int n) throws DatabaseException {
        this.CheckLicense(n);
        com.baan.owimpl.b3.database.Connection.s_logger.message("DB Client: Creating BaanERP DB Driver");
        try {
            Driver driver = Driver.getDriver();
            com.baan.owimpl.b3.database.Connection.s_logger.message("DB Client: Version = " + driver.getVersion());
            this.m_serverInstance = new ServerInstance(null, driver);
            this.m_serverInstance.DB_initialize(n, string3);
        }
        catch (SQLException sQLException) {
            com.baan.owimpl.b3.database.Connection.s_logger.errorException(sQLException);
            throw new DatabaseException("Cannot initialize BaanDBDriver, " + sQLException.getReason(), "08001", 0);
        }
        catch (Exception exception) {
            com.baan.owimpl.b3.database.Connection.s_logger.errorException(exception);
            throw new DatabaseException("Cannot initialize BaanDBDriver, " + exception.getMessage(), "08001", 0);
        }
    }

    public IPreparedStatement prepareStatement(String string) throws DatabaseException {
        return new PreparedStatement(this.m_serverInstance, string);
    }

    public IStatement createStatement() throws DatabaseException {
        return new Statement(this.m_serverInstance);
    }

    public IDatabaseMetaData getDatabaseMetaData() {
        return new DatabaseMetaData(this.m_serverInstance);
    }

    public IDatabaseInformation getInformation() throws DatabaseException {
        return new Information(this.m_serverInstance);
    }

    public String getDatabaseProductName() throws DatabaseException {
        if (this.m_productName == null) {
            this.identifyBackend();
        }
        return this.m_productName;
    }

    public String getDatabaseProductVersion() throws DatabaseException {
        if (this.m_productVersion == null) {
            this.identifyBackend();
        }
        return this.m_productVersion;
    }

    private void identifyBackend() throws DatabaseException {
        this.m_productName = this.m_serverInstance.DB_productName();
        this.m_productVersion = this.m_serverInstance.DB_productVersion();
    }

    public void close() throws DatabaseException {
        com.baan.owimpl.b3.database.Connection.s_logger.message("DB Client: Releasing license for connection");
        this.m_license.release();
        try {
            this.m_serverInstance.close();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }
}

