/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.b3.dom.Element;
import com.baan.ow.b3.database.DatabaseException;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.TextImpl;

public class XMLRowSetHelper {
    private Element m_xmlCurrent = null;
    private static final String ROW_PREFIX = "R";
    private Element m_Server_CurrentRow = null;
    private int rowcounter = 1;

    public XMLRowSetHelper() {
    }

    public XMLRowSetHelper(String string) {
        this.m_xmlCurrent = new ElementImpl(string);
    }

    public int getRowCount() throws DatabaseException {
        try {
            return this.m_xmlCurrent.getChildNodes().getLength();
        }
        catch (Throwable throwable) {
            throw new DatabaseException("XMLRowSetHelper, Error getting column count");
        }
    }

    boolean getBoolValue(int n, String string) throws DatabaseException {
        try {
            return this.getStringValue(n, string).equals("true");
        }
        catch (Throwable throwable) {
            throw new DatabaseException("XMLRowSetHelper, Cannot find " + string + " value for index " + n + ", not an boolean ");
        }
    }

    int getIntValue(int n, String string) throws DatabaseException {
        try {
            return Integer.parseInt(this.getStringValue(n, string));
        }
        catch (Throwable throwable) {
            throw new DatabaseException("XMLRowSetHelper, Cannot find " + string + " value for index " + n + ", not an integer ");
        }
    }

    String getStringValue(int n, String string) throws DatabaseException {
        --n;
        try {
            Element element = (Element)this.m_xmlCurrent.getChildNodes().item(n);
            element = (Element)element.getElementsByTagName(string).item(0);
            if (element.getFirstChild() == null) {
                return "";
            }
            return element.getFirstChild().getNodeValue();
        }
        catch (Throwable throwable) {
            throw new DatabaseException("XMLRowSetHelper, Cannot find " + string + " value for index " + n);
        }
    }

    public void addField(String string, String string2) {
        if (string2 != null) {
            ElementImpl elementImpl = new ElementImpl(string);
            elementImpl.appendChild(new TextImpl(string2));
            this.m_Server_CurrentRow.appendChild(elementImpl);
        } else {
            ElementImpl elementImpl = new ElementImpl(string);
            elementImpl.setAttribute("null", "true");
            this.m_Server_CurrentRow.appendChild(elementImpl);
        }
    }

    public void addField(String string, Integer n) {
        if (n == null) {
            this.addField(string, (String)null);
        } else {
            this.addField(string, n.toString());
        }
    }

    public void addField(String string, int n) {
        this.addField(string, "" + n);
    }

    public void addField(String string, Short s) {
        if (s == null) {
            this.addField(string, (String)null);
        } else {
            this.addField(string, s.toString());
        }
    }

    public void addField(String string, Boolean bl) {
        if (bl == null) {
            this.addField(string, (String)null);
        } else {
            this.addField(string, bl.toString());
        }
    }

    public void addRow() {
        this.m_Server_CurrentRow = new ElementImpl(ROW_PREFIX + this.rowcounter++);
        this.m_xmlCurrent.appendChild(this.m_Server_CurrentRow);
    }

    public Element getXMLData() {
        return this.m_xmlCurrent;
    }

    public void setXMLData(Element element) {
        this.m_xmlCurrent = element;
    }
}

