/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IResultSet;
import com.baan.ow.b3.database.IStatement;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.ResultSet;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;

public class Statement
implements IStatement {
    protected static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$database$Statement == null ? (class$com$baan$owimpl$b3$database$Statement = Statement.class$("com.baan.owimpl.b3.database.Statement")) : class$com$baan$owimpl$b3$database$Statement);
    protected BackendConnection m_backendConnection = null;
    protected String m_statementID = null;
    protected IResultSet m_resultSet = null;
    protected int m_fetchSize;
    private int m_queryTimeout;
    protected boolean bClosed = false;
    static /* synthetic */ Class class$com$baan$owimpl$b3$database$Statement;

    protected Statement() {
    }

    public Statement(BackendConnection backendConnection) throws DatabaseException {
        this.m_backendConnection = backendConnection;
        try {
            s_logger.message("Retreiving Adapter Client Iterator size & timeout");
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            this.m_fetchSize = adapterClientConfiguration.getIteratorSize();
            int n = adapterClientConfiguration.getTimeout();
            if (n == 0) {
                this.m_queryTimeout = 0;
            } else {
                n /= 1000;
                this.m_queryTimeout = n++;
            }
            s_logger.message("QueryTimeout = " + this.m_queryTimeout + " seconds");
            s_logger.message("FetchSize = " + this.m_fetchSize + " rows/fetch");
        }
        catch (OWConfigurationException oWConfigurationException) {
            s_logger.errorMessage("Error Retreiving Adapter Client properties, " + oWConfigurationException.getMessage());
            throw new DatabaseException("Error Retreiving Adapter Client Properties, " + oWConfigurationException.getMessage());
        }
    }

    public void reset() throws DatabaseException {
        this.checkClosed();
        this.m_resultSet.close();
        this.m_resultSet = null;
    }

    public boolean execute(String string) throws DatabaseException {
        this.checkClosed();
        this.m_resultSet = this.executeQuery(string);
        return true;
    }

    public void close() throws DatabaseException {
        this.checkClosed();
        this.bClosed = true;
        try {
            Constructor constructor = new Constructor();
            constructor.addCloseStatement(this.m_statementID);
            DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            String string = data.getStringData();
            s_logger.message("Close Statement with statementID='" + this.m_statementID + "' returned " + string);
        }
        catch (BusException busException) {
            s_logger.errorMessage("Error, Close Statement with statementID='" + this.m_statementID + "' : " + busException.getMessage());
            throw new DatabaseException("Error Close Statement " + busException.getMessage());
        }
    }

    public void setFetchSize(int n) throws DatabaseException {
        this.m_fetchSize = n;
    }

    public int getFetchSize() throws DatabaseException {
        return this.m_fetchSize;
    }

    public IResultSet executeQuery(String string) throws DatabaseException {
        this.checkClosed();
        try {
            s_logger.message("Prepare Statement with SQL ='" + string + "'");
            Constructor constructor = new Constructor();
            constructor.addPrepareStatement(string);
            DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            this.m_statementID = data.getStringData();
            s_logger.message("Prepare Statement OK, StatementID = '" + this.m_statementID + "'");
        }
        catch (BusException busException) {
            s_logger.errorMessage("Error, Preparing Statement " + busException.getMessage());
            throw new DatabaseException("Error, Preparing Statement " + busException.getMessage());
        }
        return new ResultSet(this.m_backendConnection, this.m_statementID, this.m_fetchSize, null);
    }

    public int getQueryTimeout() throws DatabaseException {
        this.checkClosed();
        return this.m_queryTimeout;
    }

    public void setQueryTimeout(int n) throws DatabaseException {
        this.checkClosed();
        this.m_queryTimeout = n;
    }

    public IResultSet getResultSet() throws DatabaseException {
        this.checkClosed();
        if (this.m_resultSet == null) {
            throw new DatabaseException("Resultset not available, Statement is not executed");
        }
        return this.m_resultSet;
    }

    protected void checkClosed() throws DatabaseException {
        if (this.bClosed) {
            throw new DatabaseException("Statement is Closed");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

