/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.NodeList;
import com.baan.b3.server.IDBRowSet;
import com.baan.ow.b3.database.DatabaseException;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.XMLRowSetHelper;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;

public class RowSet
extends XMLRowSetHelper
implements IDBRowSet {
    protected static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$database$RowSet == null ? (class$com$baan$owimpl$b3$database$RowSet = RowSet.class$("com.baan.owimpl.b3.database.RowSet")) : class$com$baan$owimpl$b3$database$RowSet);
    protected Element m_xmlRowSet = null;
    protected Element m_xmlRow = null;
    private int m_size = -1;
    protected int m_counter = 0;
    static /* synthetic */ Class class$com$baan$owimpl$b3$database$RowSet;

    public RowSet() {
        super("Rows");
    }

    public RowSet(BackendConnection backendConnection, String string, int n, int n2) throws DatabaseException {
        try {
            Constructor constructor = new Constructor();
            constructor.addFetchRowsStatement(string, n, n2);
            DataSet dataSet = backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            this.m_xmlRowSet = data.getFirstNodeData();
            this.m_xmlRow = null;
            this.m_counter = 0;
            this.m_size = n2;
        }
        catch (BusException busException) {
            s_logger.errorMessage("Error, fetching data with statementID='" + string + "' : " + busException.getMessage());
            throw new DatabaseException("Communication link failure, fetching data", "08S01", 0);
        }
    }

    public int size() {
        return this.m_size;
    }

    public int ActualSize() {
        return this.m_xmlRowSet.getChildNodes().getLength();
    }

    public int counter() {
        return this.m_counter;
    }

    public boolean next() {
        this.m_xmlRow = this.m_xmlRow == null ? (Element)this.m_xmlRowSet.getFirstChild() : (Element)this.m_xmlRow.getNextSibling();
        if (this.m_xmlRow == null) {
            return false;
        }
        ++this.m_counter;
        return true;
    }

    protected String getRawData(int n) throws DatabaseException {
        if (this.m_xmlRow == null) {
            throw new DatabaseException("Record not exists");
        }
        NodeList nodeList = this.m_xmlRow.getChildNodes();
        if (n > nodeList.getLength()) {
            throw new DatabaseException("field " + n + " not exists");
        }
        Element element = (Element)nodeList.item(n - 1);
        if (element.getFirstChild() == null) {
            String string = element.getAttribute("null");
            if (string.equals("true")) {
                return null;
            }
            return "";
        }
        return element.getFirstChild().getNodeValue();
    }

    protected RowSet(Element element) {
        this.m_xmlRowSet = element;
    }

    public void addTableRowODBC(String string, String string2, String string3) {
        this.addRow();
        this.addField("_1", (String)null);
        this.addField("_2", (String)null);
        this.addField("_3", string);
        this.addField("_4", string2);
        this.addField("_5", string3);
    }

    public void addColumnRowODBC(String string, String string2, String string3, String string4, short s, String string5, Integer n, Integer n2, Short s2, Short s3, short s4, String string6, String string7, short s5, Short s6, Integer n3, int n4, String string8) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", string2);
        this.addField("_3", string3);
        this.addField("_4", string4);
        this.addField("_5", "" + s);
        this.addField("_6", string5);
        this.addField("_7", n);
        this.addField("_8", n2);
        this.addField("_9", s2);
        this.addField("_10", s3);
        this.addField("_11", "" + s4);
        this.addField("_12", string6);
        this.addField("_13", string7);
        this.addField("_14", "" + s5);
        this.addField("_15", s6);
        this.addField("_16", n3);
        this.addField("_17", "" + n4);
        this.addField("_18", string8);
    }

    public void addPrimaryKeyRowODBC(String string, String string2, String string3, String string4, short s, String string5) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", string2);
        this.addField("_3", string3);
        this.addField("_4", string4);
        this.addField("_5", "" + s);
        this.addField("_6", string5);
    }

    public void addIndexInfoRowJDBC(String string, String string2, String string3, boolean bl, String string4, String string5, short s, Short s2, String string6, String string7, int n, int n2, String string8) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", string2);
        this.addField("_3", string3);
        this.addField("_4", "" + bl);
        this.addField("_5", string4);
        this.addField("_6", string5);
        this.addField("_7", "" + s);
        this.addField("_8", s2);
        this.addField("_9", string6);
        this.addField("_10", string7);
        this.addField("_11", "" + n);
        this.addField("_12", "" + n2);
        this.addField("_13", string8);
    }

    public void addIndexInfoRowODBC(String string, String string2, String string3, short s, String string4, String string5, short s2, Short s3, String string6, String string7, int n, int n2, String string8) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", string2);
        this.addField("_3", string3);
        this.addField("_4", "" + s);
        this.addField("_5", string4);
        this.addField("_6", string5);
        this.addField("_7", "" + s2);
        this.addField("_8", s3);
        this.addField("_9", string6);
        this.addField("_10", string7);
        this.addField("_11", "" + n);
        this.addField("_12", "" + n2);
        this.addField("_13", string8);
    }

    public void addForeignKeyODBC(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s, Short s2, Short s3, String string9, String string10, Short s4) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", string2);
        this.addField("_3", string3);
        this.addField("_4", string4);
        this.addField("_5", string5);
        this.addField("_6", string6);
        this.addField("_7", string7);
        this.addField("_8", string8);
        this.addField("_9", "" + s);
        this.addField("_10", s2);
        this.addField("_11", s3);
        this.addField("_12", string9);
        this.addField("_13", string10);
        this.addField("_14", s4);
    }

    public void addTypeRowODBC(String string, short s, Integer n, String string2, String string3, String string4, short s2, short s3, short s4, Short s5, short s6, Short s7, String string5, Short s8, Short s9, short s10, Short s11, Integer n2, Short s12) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", "" + s);
        this.addField("_3", n);
        this.addField("_4", string2);
        this.addField("_5", string3);
        this.addField("_6", string4);
        this.addField("_7", "" + s2);
        this.addField("_8", "" + s3);
        this.addField("_9", "" + s4);
        this.addField("_10", s5);
        this.addField("_11", "" + s6);
        this.addField("_12", s7);
        this.addField("_13", string5);
        this.addField("_14", s8);
        this.addField("_15", s9);
        this.addField("_16", "" + s10);
        this.addField("_17", s11);
        this.addField("_18", n2);
        this.addField("_19", s12);
    }

    public void addColumnRowJDBC(String string, String string2, String string3, String string4, int n, String string5, int n2, int n3, int n4, int n5, int n6, String string6, String string7, int n7, int n8, int n9, int n10, String string8) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", string2);
        this.addField("_3", string3);
        this.addField("_4", string4);
        this.addField("_5", "" + n);
        this.addField("_6", string5);
        this.addField("_7", n2);
        this.addField("_8", n3);
        this.addField("_9", n4);
        this.addField("_10", n5);
        this.addField("_11", "" + n6);
        this.addField("_12", string6);
        this.addField("_13", string7);
        this.addField("_14", "" + n7);
        this.addField("_15", n8);
        this.addField("_16", n9);
        this.addField("_17", "" + n10);
        this.addField("_18", string8);
        this.addField("_19", (String)null);
        this.addField("_20", (String)null);
        this.addField("_21", (String)null);
        this.addField("_22", (Short)null);
    }

    public void addTableRowJDBC(String string, String string2, String string3) {
        this.addRow();
        this.addField("_1", (String)null);
        this.addField("_2", (String)null);
        this.addField("_3", string);
        this.addField("_4", string2);
        this.addField("_5", string3);
        this.addField("_6", (String)null);
        this.addField("_7", (String)null);
        this.addField("_8", (String)null);
        this.addField("_9", (String)null);
        this.addField("_10", (String)null);
    }

    public void addTypeRowJDBC(String string, int n, int n2, String string2, String string3, String string4, short s, boolean bl, short s2, boolean bl2, boolean bl3, boolean bl4, String string5, short s3, short s4, int n3, Integer n4, int n5) {
        this.addRow();
        this.addField("_1", string);
        this.addField("_2", "" + n);
        this.addField("_3", "" + n2);
        this.addField("_4", string2);
        this.addField("_5", string3);
        this.addField("_6", string4);
        this.addField("_7", "" + s);
        this.addField("_8", "" + bl);
        this.addField("_9", "" + s2);
        this.addField("_10", "" + bl2);
        this.addField("_11", "" + bl3);
        this.addField("_12", "" + bl4);
        this.addField("_13", string5);
        this.addField("_14", (int)s3);
        this.addField("_15", (int)s4);
        this.addField("_16", "" + n3);
        this.addField("_17", n4);
        this.addField("_18", n5);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

