/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.b3.dom.Element;
import com.baan.b3.server.IDBRowSetMetaData;
import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IResultSetMetaData;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.XMLRowSetHelper;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;

public class ResultSetMetaData
extends XMLRowSetHelper
implements IResultSetMetaData,
IDBRowSetMetaData {
    protected static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.b3.database", "ResultSetMetaData");
    private Element m_Server_CurrentRow = null;

    public ResultSetMetaData() {
        super("ResultSetMetaData");
    }

    public ResultSetMetaData(Element element) throws DatabaseException {
        this.setXMLData(element);
    }

    public ResultSetMetaData(BackendConnection backendConnection, String string) throws DatabaseException {
        try {
            s_logger.message("GetResultSetMetaData with statementID='" + string + "'");
            Constructor constructor = new Constructor();
            constructor.addResultSetMetaData(string);
            DataSet dataSet = backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            this.setXMLData(data.getFirstNodeData());
        }
        catch (BusException busException) {
            s_logger.errorMessage("Error, GetResultSetMetaData with statementID='" + string + "' : " + busException.getMessage());
            throw new DatabaseException("Communication link failure, GetResultSetMetaData " + busException.getMessage(), "08S01", 0);
        }
    }

    public int getColumnCount() throws DatabaseException {
        return this.getRowCount();
    }

    public boolean isAutoIncrement(int n) throws DatabaseException {
        return this.getBoolValue(n, "AutoIncrement");
    }

    public boolean isCaseSensitive(int n) throws DatabaseException {
        return this.getBoolValue(n, "CaseSensitive");
    }

    public boolean isSearchable(int n) throws DatabaseException {
        return this.getBoolValue(n, "Searchable");
    }

    public boolean isCurrency(int n) throws DatabaseException {
        return this.getBoolValue(n, "Currency");
    }

    public int isNullable(int n) throws DatabaseException {
        return this.getIntValue(n, "Nullable");
    }

    public boolean isSigned(int n) throws DatabaseException {
        return this.getBoolValue(n, "Signed");
    }

    public int getColumnDisplaySize(int n) throws DatabaseException {
        return this.getIntValue(n, "ColumnDisplaySize");
    }

    public String getColumnLabel(int n) throws DatabaseException {
        return this.getStringValue(n, "ColumnLabel");
    }

    public String getColumnName(int n) throws DatabaseException {
        return this.getStringValue(n, "ColumnName");
    }

    public String getSchemaName(int n) throws DatabaseException {
        return this.getStringValue(n, "SchemaName");
    }

    public int getPrecision(int n) throws DatabaseException {
        return this.getIntValue(n, "Precision");
    }

    public int getScale(int n) throws DatabaseException {
        return this.getIntValue(n, "Scale");
    }

    public String getTableName(int n) throws DatabaseException {
        return this.getStringValue(n, "TableName");
    }

    public String getCatalogName(int n) throws DatabaseException {
        return this.getStringValue(n, "CatalogName");
    }

    public int getColumnType(int n) throws DatabaseException {
        return this.getIntValue(n, "ColumnType");
    }

    public String getColumnTypeName(int n) throws DatabaseException {
        return this.getStringValue(n, "ColumnTypeName");
    }

    public boolean isReadOnly(int n) throws DatabaseException {
        return this.getBoolValue(n, "ReadOnly");
    }

    public boolean isWritable(int n) throws DatabaseException {
        return this.getBoolValue(n, "Writable");
    }

    public boolean isDefinitelyWritable(int n) throws DatabaseException {
        return this.getBoolValue(n, "DefinitelyWritable");
    }

    public void setDefinitelyWritable(boolean bl) {
        this.addField("DefinitelyWritable", "" + bl);
    }

    public void setWritable(boolean bl) {
        this.addField("Writable", "" + bl);
    }

    public void setAutoIncrement(boolean bl) {
        this.addField("AutoIncrement", "" + bl);
    }

    public void setCaseSensitive(boolean bl) {
        this.addField("CaseSensitive", "" + bl);
    }

    public void setCatalogName(String string) {
        this.addField("CatalogName", string);
    }

    public void setColumnDisplaySize(int n) {
        this.addField("ColumnDisplaySize", "" + n);
    }

    public void setColumnLabel(String string) {
        this.addField("ColumnLabel", string);
    }

    public void setColumnName(String string) {
        this.addField("ColumnName", string);
    }

    public void setColumnType(int n) {
        this.addField("ColumnType", "" + n);
    }

    public void setColumnTypeName(String string) {
        this.addField("ColumnTypeName", string);
    }

    public void setCurrency(boolean bl) {
        this.addField("Currency", "" + bl);
    }

    public void setNullable(int n) {
        this.addField("Nullable", "" + n);
    }

    public void setPrecision(int n) {
        this.addField("Precision", "" + n);
    }

    public void setReadOnly(boolean bl) {
        this.addField("ReadOnly", "" + bl);
    }

    public void setScale(int n) {
        this.addField("Scale", "" + n);
    }

    public void setSchemaName(String string) {
        this.addField("SchemaName", string);
    }

    public void setSearchable(boolean bl) {
        this.addField("Searchable", "" + bl);
    }

    public void setSigned(boolean bl) {
        this.addField("Signed", "" + bl);
    }

    public void setTableName(String string) {
        this.addField("TableName", string);
    }

    public void addRow(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, int n2, String string, String string2, int n3, int n4, String string3, int n5, String string4, boolean bl6, boolean bl7, boolean bl8) {
        this.addRow();
        this.setAutoIncrement(bl);
        this.setCaseSensitive(bl2);
        this.setColumnDisplaySize(n2);
        this.setColumnLabel(string);
        this.setColumnName(string2);
        this.setColumnType(n5);
        this.setColumnTypeName(string4);
        this.setCurrency(bl4);
        this.setNullable(n);
        this.setPrecision(n3);
        this.setReadOnly(bl6);
        this.setScale(n4);
        this.setSearchable(bl3);
        this.setSigned(bl5);
        this.setTableName(string3);
        this.setDefinitelyWritable(bl8);
        this.setWritable(bl7);
    }

    public void addRowFromType(int n, String string) {
        this.addRowFromType(n, string, 0);
    }

    public void addRowFromType(int n, String string, String string2, int n2, int n3) {
        switch (n) {
            case 16: {
                this.addRow(false, true, true, false, 0, false, 1, string, string, 1, 0, string2, n, "BOOLEAN", true, false, false);
                break;
            }
            case 91: {
                this.addRow(false, true, true, false, 0, false, 10, string, string, 10, 0, string2, n, "DATE", true, false, false);
                break;
            }
            case 8: {
                this.addRow(false, true, true, false, 0, true, 15, string, string, 10, 0, string2, n, "DOUBLE", true, false, false);
                break;
            }
            case 4: {
                this.addRow(false, true, true, false, 0, true, 10, string, string, 10, 0, string2, n, "INTEGER", true, false, false);
                break;
            }
            case 103: {
                this.addRow(false, true, true, false, 0, true, 10, string, string, 10, 0, string2, n, "INTERVAL_DAY", true, false, false);
                break;
            }
            case 106: {
                this.addRow(false, true, true, false, 0, true, 10, string, string, 10, 0, string2, n, "INTERVAL_SECOND", true, false, false);
                break;
            }
            case 5: {
                this.addRow(false, true, true, false, 0, true, 5, string, string, 5, 0, string2, n, "SMALLINT", true, false, false);
                break;
            }
            case 93: {
                this.addRow(false, true, true, false, 0, false, 19, string, string, 19, 0, string2, n, "TIMESTAMP", true, false, false);
                break;
            }
            case 12: {
                if (n2 == 0) {
                    n2 = 3092;
                }
                this.addRow(false, true, true, false, 0, false, n2, string, string, n2, 0, string2, n, "VARCHAR", true, false, false);
            }
        }
    }

    public void addRowFromType(int n, String string, int n2) {
        switch (n) {
            case 16: {
                this.addRow(false, true, true, false, n2, false, 1, string, string, 1, 0, "DBMetaData", n, "BOOLEAN", true, false, false);
                break;
            }
            case 91: {
                this.addRow(false, true, true, false, n2, false, 10, string, string, 10, 0, "DBMetaData", n, "DATE", true, false, false);
                break;
            }
            case 8: {
                this.addRow(false, true, true, false, n2, true, 15, string, string, 15, 0, "DBMetaData", n, "DOUBLE", true, false, false);
                break;
            }
            case 4: {
                this.addRow(false, true, true, false, n2, true, 10, string, string, 10, 0, "DBMetaData", n, "INTEGER", true, false, false);
                break;
            }
            case 5: {
                this.addRow(false, true, true, false, n2, true, 5, string, string, 5, 0, "DBMetaData", n, "SMALLINT", true, false, false);
                break;
            }
            case 93: {
                this.addRow(false, true, true, false, n2, false, 19, string, string, 19, 0, "DBMetaData", n, "TIMESTAMP", true, false, false);
                break;
            }
            case 12: {
                this.addRow(false, true, true, false, n2, false, 3092, string, string, 3092, 0, "DBMetaData", n, "VARCHAR", true, false, false);
            }
        }
    }
}

