/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IResultSet;
import com.baan.ow.b3.database.IResultSetMetaData;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.ResultSetMetaData;
import com.baan.owimpl.b3.database.RowSet;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;

public class ResultSet
implements IResultSet {
    protected static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.b3.database", "ResultSet");
    private BackendConnection m_backendConnection = null;
    protected int m_fetchSize;
    protected String m_statementID = null;
    protected boolean m_closed = false;
    protected boolean m_afterLast = false;
    protected boolean m_beforeFirst = true;
    protected int m_CurrentRow = 0;
    protected IResultSetMetaData m_rsMetaData = null;
    protected RowSet m_rowSet = null;
    protected RowSet m_nextRowSet = null;
    protected int m_CurrentRowSetStart = 0;

    public ResultSet() {
    }

    public ResultSet(BackendConnection backendConnection, String string, int n, String[] stringArray) throws DatabaseException {
        this.m_fetchSize = n;
        this.m_statementID = string;
        this.m_backendConnection = backendConnection;
        try {
            s_logger.message("Execute Statement with statementID='" + this.m_statementID + "'");
            Constructor constructor = new Constructor();
            constructor.addExecuteStatement(this.m_statementID, stringArray);
            DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            String string2 = data.getStringData();
            s_logger.message("Execute Statement with statementID='" + this.m_statementID + "' returned " + string2);
        }
        catch (BusException busException) {
            s_logger.errorMessage("Error, Execute Statement with statementID='" + this.m_statementID + "' : " + busException.getMessage());
            throw new DatabaseException("Communication link failure, Executing Statement " + busException.getMessage(), "08S01", 0);
        }
    }

    public ResultSet(RowSet rowSet) {
        this.m_rowSet = rowSet;
    }

    public void close() throws DatabaseException {
        this.checkClosed();
        this.m_closed = true;
        if (this.m_backendConnection != null) {
            try {
                Constructor constructor = new Constructor();
                constructor.addResetStatement(this.m_statementID);
                DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor);
                Data data = dataSet.getFirstData();
                String string = data.getStringData();
                s_logger.message("Reset Statement with statementID='" + this.m_statementID + "' returned " + string);
            }
            catch (BusException busException) {
                s_logger.errorMessage("Error, Reset Statement with statementID='" + this.m_statementID + "' : " + busException.getMessage());
                throw new DatabaseException("Communication link failure, resetting Statement " + busException.getMessage(), "08S01", 0);
            }
        }
    }

    public IResultSetMetaData getMetaData() throws DatabaseException {
        this.checkClosed();
        if (this.m_rsMetaData == null) {
            this.m_rsMetaData = new ResultSetMetaData(this.m_backendConnection, this.m_statementID);
        }
        return this.m_rsMetaData;
    }

    public void setMetaData(IResultSetMetaData iResultSetMetaData) {
        this.m_rsMetaData = iResultSetMetaData;
    }

    public boolean next() throws DatabaseException {
        boolean bl;
        this.checkClosed();
        this.m_beforeFirst = false;
        if (this.m_rowSet == null) {
            this.m_rowSet = new RowSet(this.m_backendConnection, this.m_statementID, 1, this.m_fetchSize);
        }
        if (bl = this.m_rowSet.next()) {
            ++this.m_CurrentRow;
            return true;
        }
        if (this.m_rowSet.size() == this.m_rowSet.counter()) {
            if (this.m_nextRowSet == null) {
                this.m_rowSet = new RowSet(this.m_backendConnection, this.m_statementID, this.m_CurrentRow + 1, this.m_fetchSize);
            } else {
                this.m_rowSet = this.m_nextRowSet;
                this.m_nextRowSet = null;
            }
            bl = this.m_rowSet.next();
            if (bl) {
                ++this.m_CurrentRow;
                return true;
            }
            this.m_rowSet = null;
            this.m_afterLast = true;
            return false;
        }
        this.m_rowSet = null;
        this.m_afterLast = true;
        return false;
    }

    public boolean previous() throws DatabaseException {
        this.checkClosed();
        return true;
    }

    public boolean first() throws DatabaseException {
        this.checkClosed();
        return true;
    }

    public boolean last() throws DatabaseException {
        this.checkClosed();
        return true;
    }

    public boolean absolute(int n) throws DatabaseException {
        this.checkClosed();
        return true;
    }

    public boolean relative(int n) throws DatabaseException {
        this.checkClosed();
        return true;
    }

    public String getRawData(int n) throws DatabaseException {
        this.checkClosed();
        if (this.m_rowSet != null) {
            return this.m_rowSet.getRawData(n);
        }
        throw new DatabaseException("Current row not exists");
    }

    public String getCursorName() throws DatabaseException {
        this.checkClosed();
        return null;
    }

    public int getRow() throws DatabaseException {
        this.checkClosed();
        return this.m_CurrentRow;
    }

    public boolean isBeforeFirst() throws DatabaseException {
        this.checkClosed();
        return this.m_beforeFirst;
    }

    public boolean isAfterLast() throws DatabaseException {
        this.checkClosed();
        return this.m_afterLast;
    }

    public boolean isFirst() throws DatabaseException {
        this.checkClosed();
        if (this.m_CurrentRow == 1) {
            return !this.isAfterLast();
        }
        return false;
    }

    public boolean isLast() throws DatabaseException {
        this.checkClosed();
        if (this.m_rowSet == null) {
            return false;
        }
        if (this.m_rowSet.ActualSize() < this.m_rowSet.size()) {
            return this.m_rowSet.counter() == this.m_rowSet.ActualSize();
        }
        if (this.m_rowSet.size() == this.m_rowSet.counter()) {
            if (this.m_nextRowSet == null) {
                this.m_nextRowSet = new RowSet(this.m_backendConnection, this.m_statementID, this.m_CurrentRow + 1, this.m_fetchSize);
            }
            return this.m_nextRowSet.size() == 0;
        }
        if (this.m_rowSet.counter() == this.m_rowSet.ActualSize()) {
            return this.m_rowSet.ActualSize() != 0;
        }
        return false;
    }

    public void beforeFirst() throws DatabaseException {
        this.checkClosed();
    }

    public void afterLast() throws DatabaseException {
        this.checkClosed();
    }

    public void setFetchSize(int n) throws DatabaseException {
        this.checkClosed();
        this.m_fetchSize = n;
    }

    public int getFetchSize() throws DatabaseException {
        this.checkClosed();
        return this.m_fetchSize;
    }

    protected void checkClosed() throws DatabaseException {
        if (this.m_closed) {
            throw new DatabaseException("this ResultSet is Closed");
        }
    }

    public int findColumn(String string) throws DatabaseException {
        this.getMetaData();
        int n = this.m_rsMetaData.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.m_rsMetaData.getColumnName(n2))) {
                return n2 + 1;
            }
            ++n2;
        }
        throw new DatabaseException("Could not find couln with column name '" + string + "'");
    }
}

