/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IParameterMetaData;
import com.baan.ow.b3.database.IPreparedStatement;
import com.baan.ow.b3.database.IResultSet;
import com.baan.ow.b3.database.IResultSetMetaData;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.ParameterMetaData;
import com.baan.owimpl.b3.database.ResultSet;
import com.baan.owimpl.b3.database.ResultSetMetaData;
import com.baan.owimpl.b3.database.Statement;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;
import java.util.Vector;

public class PreparedStatement
extends Statement
implements IPreparedStatement {
    private Vector m_vParameters = new Vector();
    private IResultSetMetaData m_resultSetMetaData = null;

    public PreparedStatement(BackendConnection backendConnection, String string) throws DatabaseException {
        super(backendConnection);
        try {
            Statement.s_logger.message("Prepare Statement with SQL ='" + string + "'");
            Constructor constructor = new Constructor();
            constructor.addPrepareStatement(string);
            DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            this.m_statementID = data.getStringData();
            Statement.s_logger.message("Prepare Statement OK, StatementID = '" + this.m_statementID + "'");
        }
        catch (BusException busException) {
            Statement.s_logger.errorMessage("Error, Preparing Statement " + busException.getMessage());
            throw new DatabaseException("Communication link failure, Preparing Statement " + busException.getMessage(), "08S01", 0);
        }
    }

    public void setParameter(int n, String string) throws DatabaseException {
        this.checkClosed();
        Statement.s_logger.flowMessage("setParameter index " + n + ", data='" + string + "'");
        if (n >= this.m_vParameters.size()) {
            this.m_vParameters.setSize(n);
        }
        this.m_vParameters.setElementAt(string, n - 1);
    }

    public IResultSetMetaData getMetaData() throws DatabaseException {
        this.checkClosed();
        if (this.m_resultSetMetaData == null) {
            this.m_resultSetMetaData = new ResultSetMetaData(this.m_backendConnection, this.m_statementID);
        }
        return this.m_resultSetMetaData;
    }

    public IParameterMetaData getParameterMetaData() throws DatabaseException {
        this.checkClosed();
        return new ParameterMetaData(this.m_backendConnection, this.m_statementID);
    }

    public void clearParameters() throws DatabaseException {
        this.m_vParameters = new Vector();
    }

    public boolean execute() throws DatabaseException {
        this.checkClosed();
        this.m_resultSet = this.executeQuery();
        return true;
    }

    public IResultSet executeQuery() throws DatabaseException {
        this.checkClosed();
        Object[] objectArray = new String[this.m_vParameters.size()];
        this.m_vParameters.copyInto(objectArray);
        return new ResultSet(this.m_backendConnection, this.m_statementID, this.m_fetchSize, (String[])objectArray);
    }
}

