/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.b3.server.IDBParameterMetaData;
import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IParameterMetaData;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.XMLRowSetHelper;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;

public class ParameterMetaData
extends XMLRowSetHelper
implements IParameterMetaData,
IDBParameterMetaData {
    protected static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.b3.database", "ParameterMetaData");

    public ParameterMetaData() {
        super("ParamMD");
    }

    public ParameterMetaData(BackendConnection backendConnection, String string) throws DatabaseException {
        try {
            s_logger.message("Get Parameter MetaData with statementID='" + string + "'");
            Constructor constructor = new Constructor();
            constructor.addParameterMetaData(string);
            DataSet dataSet = backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            this.setXMLData(data.getFirstNodeData());
        }
        catch (BusException busException) {
            s_logger.errorMessage("Error, Get Parameter MetaData with statementID='" + string + "' : " + busException.getMessage());
            throw new DatabaseException("Communication link failure, getting parameter MetaData " + busException.getMessage(), "08S01", 0);
        }
    }

    public int getParameterCount() throws DatabaseException {
        return this.getRowCount();
    }

    public int getParameterMode(int n) throws DatabaseException {
        return this.getIntValue(n, "ParameterMode");
    }

    public int getParameterType(int n) throws DatabaseException {
        return this.getIntValue(n, "ParameterType");
    }

    public String getParameterTypeName(int n) throws DatabaseException {
        return this.getStringValue(n, "ParameterTypeName");
    }

    public int getPrecision(int n) throws DatabaseException {
        return this.getIntValue(n, "Precision");
    }

    public int getScale(int n) throws DatabaseException {
        return this.getIntValue(n, "Scale");
    }

    public int isNullable(int n) throws DatabaseException {
        return this.getIntValue(n, "Nullable");
    }

    public boolean isSigned(int n) throws DatabaseException {
        return this.getBoolValue(n, "Signed");
    }

    public void addParameterMetaDataRow(int n, int n2, String string, int n3, int n4, int n5, boolean bl) {
        this.addRow();
        this.addField("ParameterMode", "" + n);
        this.addField("ParameterType", "" + n2);
        this.addField("ParameterTypeName", string);
        this.addField("Precision", "" + n3);
        this.addField("Scale", "" + n4);
        this.addField("Nullable", "" + n5);
        this.addField("Signed", "" + bl);
    }
}

