/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.server.IDBInformation;
import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IDatabaseInformation;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.TextImpl;

public class Information
implements IDatabaseInformation,
IDBInformation {
    protected static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$database$Information == null ? (class$com$baan$owimpl$b3$database$Information = Information.class$("com.baan.owimpl.b3.database.Information")) : class$com$baan$owimpl$b3$database$Information);
    private BackendConnection m_backendConnection = null;
    protected Element m_xmlData = null;
    public static String LOG_PREFIX = "ERP DB: ";
    private static int MAX_INT = 0x7FFFFFF7;
    private static int MAX_BYTE = 256;
    private static int MAX_SHORT = 65536;
    static /* synthetic */ Class class$com$baan$owimpl$b3$database$Information;

    public Information(BackendConnection backendConnection) throws DatabaseException {
        this.m_backendConnection = backendConnection;
        try {
            Constructor constructor = new Constructor();
            constructor.addDatabaseInformation();
            DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            this.m_xmlData = data.getFirstNodeData();
        }
        catch (BusException busException) {
            s_logger.errorMessage(busException.getMessage());
            throw new DatabaseException("Communication link failure, " + busException.getMessage(), "08S01", 0);
        }
    }

    public Information() {
        this.m_xmlData = new ElementImpl("DatabaseInformation");
    }

    private int getIntValue(String string) {
        try {
            String string2 = this.getNode(string).getFirstChild().getNodeValue();
            int n = Integer.parseInt(string2);
            s_logger.flowMessage(LOG_PREFIX + string + " = " + n);
            return n;
        }
        catch (Throwable throwable) {
            s_logger.flowMessage(LOG_PREFIX + string + " = -1");
            return -1;
        }
    }

    private boolean getBoolValue(String string) {
        try {
            String string2 = this.getNode(string).getFirstChild().getNodeValue();
            boolean bl = string2.equals("true");
            s_logger.flowMessage(LOG_PREFIX + string + " = " + bl);
            return bl;
        }
        catch (Throwable throwable) {
            s_logger.flowMessage(LOG_PREFIX + string + " = false");
            return false;
        }
    }

    private String getStringValue(String string) {
        try {
            String string2 = this.getNode(string).getFirstChild().getNodeValue();
            s_logger.flowMessage(LOG_PREFIX + string + " = '" + string2 + "'");
            return string2;
        }
        catch (Throwable throwable) {
            s_logger.flowMessage(LOG_PREFIX + string + " = ''");
            return "";
        }
    }

    private Node getNode(String string) {
        try {
            return this.m_xmlData.getElementsByTagName(string).item(0);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void setStringValue(String string, String string2) {
        try {
            this.m_xmlData.removeChild(this.getNode(string));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ElementImpl elementImpl = new ElementImpl(string);
            elementImpl.appendChild(new TextImpl(string2));
            this.m_xmlData.appendChild(elementImpl);
        }
        catch (Throwable throwable) {}
    }

    private void setIntValue(String string, int n) {
        this.setStringValue(string, "" + n);
    }

    private void setBoolValue(String string, boolean bl) {
        this.setStringValue(string, "" + bl);
    }

    public boolean isReadOnly() {
        return true;
    }

    public int getMaxConnections() {
        return MAX_BYTE;
    }

    public int getMaxBinaryLiteralLength() {
        return this.getIntValue("MaxBinaryLiteralLength");
    }

    public int getMaxCatalogNameLength() {
        return this.getIntValue("MaxCatalogNameLength");
    }

    public int getMaxCharLiteralLength() {
        return this.getIntValue("MaxCharLiteralLength");
    }

    public int getMaxColumnNameLength() {
        return this.getIntValue("MaxColumnNameLength");
    }

    public int getMaxColumnsInGroupBy() {
        return this.getIntValue("MaxColumnsInGroupBy");
    }

    public int getMaxColumnsInIndex() {
        return this.getIntValue("MaxColumnsInIndex");
    }

    public int getMaxColumnsInOrderBy() {
        return this.getIntValue("MaxColumnsInOrderBy");
    }

    public int getMaxColumnsInSelect() {
        return this.getIntValue("MaxColumnsInSelect");
    }

    public int getMaxColumnsInTable() {
        return this.getIntValue("MaxColumnsInTable");
    }

    public int getMaxCursorNameLength() {
        return this.getIntValue("MaxCursorNameLength");
    }

    public int getMaxIndexLength() {
        return this.getIntValue("MaxIndexLength");
    }

    public int getMaxProcedureNameLength() {
        return this.getIntValue("MaxProcedureNameLength");
    }

    public int getMaxRowSize() {
        return this.getIntValue("MaxRowSize");
    }

    public int getMaxSchemaNameLength() {
        return this.getIntValue("MaxSchemaNameLength");
    }

    public int getMaxStatementLength() {
        return this.getIntValue("MaxStatementLength");
    }

    public int getMaxStatements() {
        return this.getIntValue("MaxStatements");
    }

    public int getMaxTableNameLength() {
        return this.getIntValue("MaxTableNameLength");
    }

    public int getMaxTablesInSelect() {
        return this.getIntValue("MaxTablesInSelect");
    }

    public int getMaxUserNameLength() {
        return this.getIntValue("MaxUserNameLength");
    }

    public boolean allTablesAreSelectable() {
        return this.getBoolValue("allTablesAreSelectable");
    }

    public boolean nullPlusNonNullIsNull() {
        return this.getBoolValue("nullPlusNonNullIsNull");
    }

    public boolean nullsAreSortedAtEnd() {
        return this.getBoolValue("nullsAreSortedAtEnd");
    }

    public boolean nullsAreSortedAtStart() {
        return this.getBoolValue("nullsAreSortedAtStart");
    }

    public boolean nullsAreSortedHigh() {
        return this.getBoolValue("nullsAreSortedHigh");
    }

    public boolean nullsAreSortedLow() {
        return this.getBoolValue("nullsAreSortedLow");
    }

    public boolean supportsAlterTableWithAddColumn() {
        return this.getBoolValue("AlterTableWithAddColumn");
    }

    public boolean supportsAlterTableWithDropColumn() {
        return this.getBoolValue("AlterTableWithDropColumn");
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return this.getBoolValue("ANSI92EntryLevelSQL");
    }

    public boolean supportsANSI92FullSQL() {
        return this.getBoolValue("ANSI92FullSQL");
    }

    public boolean supportsANSI92IntermediateSQL() {
        return this.getBoolValue("ANSI92IntermediateSQL");
    }

    public boolean supportsBatchUpdates() {
        return this.getBoolValue("BatchUpdates");
    }

    public boolean supportsCatalogsInDataManipulation() {
        return this.getBoolValue("CatalogsInDataManipulation");
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return this.getBoolValue("CatalogsInIndexDefinitions");
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return this.getBoolValue("CatalogsInPrivilegeDefinitions");
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return this.getBoolValue("CatalogsInProcedureCalls");
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return this.getBoolValue("CatalogsInTableDefinitions");
    }

    public boolean supportsColumnAliasing() {
        return this.getBoolValue("ColumnAliasing");
    }

    public boolean supportsCoreSQLGrammar() {
        return this.getBoolValue("CoreSQLGrammar");
    }

    public boolean supportsCorrelatedSubqueries() {
        return this.getBoolValue("CorrelatedSubqueries");
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return this.getBoolValue("DataDefinitionAndDataManipulationTransactions");
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return this.getBoolValue("DataManipulationTransactionsOnly");
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return this.getBoolValue("DifferentTableCorrelationNames");
    }

    public boolean supportsExpressionsInOrderBy() {
        return this.getBoolValue("ExpressionsInOrderBy");
    }

    public boolean supportsExtendedSQLGrammar() {
        return this.getBoolValue("ExtendedSQLGrammar");
    }

    public boolean supportsFullOuterJoins() {
        return this.getBoolValue("FullOuterJoins");
    }

    public boolean supportsGetGeneratedKeys() {
        return this.getBoolValue("GeneratedKeys");
    }

    public boolean supportsGroupBy() {
        return this.getBoolValue("GroupBy");
    }

    public boolean supportsGroupByBeyondSelect() {
        return this.getBoolValue("GroupByBeyondSelect");
    }

    public boolean supportsGroupByUnrelated() {
        return this.getBoolValue("GroupByUnrelated");
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return this.getBoolValue("IntegrityEnhancementFacility");
    }

    public boolean supportsLikeEscapeClause() {
        return this.getBoolValue("LikeEscapeClause");
    }

    public boolean supportsLimitedOuterJoins() {
        return this.getBoolValue("LimitedOuterJoins");
    }

    public boolean supportsMinimumSQLGrammar() {
        return this.getBoolValue("MinimumSQLGrammar");
    }

    public boolean supportsMixedCaseIdentifiers() {
        return this.getBoolValue("MixedCaseIdentifiers");
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return this.getBoolValue("MixedCaseQuotedIdentifiers");
    }

    public boolean supportsMultipleOpenResults() {
        return this.getBoolValue("MultipleOpenResults");
    }

    public boolean supportsMultipleResultSets() {
        return this.getBoolValue("MultipleResultSets");
    }

    public boolean supportsMultipleTransactions() {
        return this.getBoolValue("MultipleTransactions");
    }

    public boolean supportsNamedParameters() {
        return this.getBoolValue("NamedParameters");
    }

    public boolean supportsNonNullableColumns() {
        return this.getBoolValue("NonNullableColumns");
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return this.getBoolValue("OpenCursorsAcrossCommit");
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return this.getBoolValue("OpenCursorsAcrossRollback");
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return this.getBoolValue("OpenStatementsAcrossCommit");
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return this.getBoolValue("OpenStatementsAcrossRollback");
    }

    public boolean supportsOrderByUnrelated() {
        return this.getBoolValue("OrderByUnrelated");
    }

    public boolean supportsOuterJoins() {
        return this.getBoolValue("OuterJoins");
    }

    public boolean supportsPositionedDelete() {
        return this.getBoolValue("PositionedDelete");
    }

    public boolean supportsPositionedUpdate() {
        return this.getBoolValue("PositionedUpdate");
    }

    public boolean supportsSavepoints() {
        return this.getBoolValue("Savepoints");
    }

    public boolean supportsSchemasInDataManipulation() {
        return this.getBoolValue("SchemasInDataManipulation");
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return this.getBoolValue("SchemasInIndexDefinitions");
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return this.getBoolValue("SchemasInPrivilegeDefinitions");
    }

    public boolean supportsSchemasInProcedureCalls() {
        return this.getBoolValue("SchemasInProcedureCalls");
    }

    public boolean supportsSchemasInTableDefinitions() {
        return this.getBoolValue("SchemasInTableDefinitions");
    }

    public boolean supportsSelectForUpdate() {
        return this.getBoolValue("SelectForUpdate");
    }

    public boolean supportsStatementPooling() {
        return this.getBoolValue("StatementPooling");
    }

    public boolean supportsStoredProcedures() {
        return this.getBoolValue("StoredProcedures");
    }

    public boolean supportsSubqueriesInComparisons() {
        return this.getBoolValue("SubqueriesInComparisons");
    }

    public boolean supportsSubqueriesInExists() {
        return this.getBoolValue("SubqueriesInExists");
    }

    public boolean supportsSubqueriesInIns() {
        return this.getBoolValue("SubqueriesInIns");
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return this.getBoolValue("SubqueriesInQuantifieds");
    }

    public boolean supportsTableCorrelationNames() {
        return this.getBoolValue("TableCorrelationNames");
    }

    public boolean supportsTransactions() {
        return this.getBoolValue("Transactions");
    }

    public boolean supportsUnion() {
        return this.getBoolValue("Union");
    }

    public boolean supportsUnionAll() {
        return this.getBoolValue("UnionAll");
    }

    public String getExtraNameCharacters() {
        return this.getStringValue("ExtraNameCharacters");
    }

    public String getIdentifierQuoteString() {
        return this.getStringValue("IdentifierQuoteString");
    }

    public String getSQLKeywords() {
        return this.getStringValue("SQLKeywords");
    }

    public String getSearchStringEscape() {
        return this.getStringValue("SearchStringEscape");
    }

    public String getNumericFunctions() {
        return this.getStringValue("NumericFunctions");
    }

    public String getAggregateFunctions() {
        return this.getStringValue("AggregateFunctions");
    }

    public String getStringFunctions() {
        return this.getStringValue("StringFunctions");
    }

    public String getSystemFunctions() {
        return this.getStringValue("SystemFunctions");
    }

    public String getTimeDateFunctions() {
        return this.getStringValue("TimeDateFunctions");
    }

    public void setMaxBinaryLiteralLength(int n) {
        this.setIntValue("MaxBinaryLiteralLength", n);
    }

    public void setMaxCatalogNameLength(int n) {
        this.setIntValue("MaxCatalogNameLength", n);
    }

    public void setMaxCharLiteralLength(int n) {
        this.setIntValue("MaxCharLiteralLength", n);
    }

    public void setMaxColumnNameLength(int n) {
        this.setIntValue("MaxColumnNameLength", n);
    }

    public void setMaxColumnsInGroupBy(int n) {
        this.setIntValue("MaxColumnsInGroupBy", n);
    }

    public void setMaxColumnsInIndex(int n) {
        this.setIntValue("MaxColumnsInIndex", n);
    }

    public void setMaxColumnsInOrderBy(int n) {
        this.setIntValue("MaxColumnsInOrderBy", n);
    }

    public void setMaxColumnsInSelect(int n) {
        this.setIntValue("MaxColumnsInSelect", n);
    }

    public void setMaxColumnsInTable(int n) {
        this.setIntValue("MaxColumnsInTable", n);
    }

    public void setMaxCursorNameLength(int n) {
        this.setIntValue("MaxCursorNameLength", n);
    }

    public void setMaxIndexLength(int n) {
        this.setIntValue("MaxIndexLength", n);
    }

    public void setMaxProcedureNameLength(int n) {
        this.setIntValue("MaxProcedureNameLength", n);
    }

    public void setMaxRowSize(int n) {
        this.setIntValue("MaxRowSize", n);
    }

    public void setMaxSchemaNameLength(int n) {
        this.setIntValue("MaxSchemaNameLength", n);
    }

    public void setMaxStatementLength(int n) {
        this.setIntValue("MaxStatementLength", n);
    }

    public void setMaxStatements(int n) {
        this.setIntValue("MaxStatements", n);
    }

    public void setMaxTableNameLength(int n) {
        this.setIntValue("MaxTableNameLength", n);
    }

    public void setMaxTablesInSelect(int n) {
        this.setIntValue("MaxTablesInSelect", n);
    }

    public void setMaxUserNameLength(int n) {
        this.setIntValue("MaxUserNameLength", n);
    }

    public void allTablesAreSelectable(boolean bl) {
        this.setBoolValue("allTablesAreSelectable", bl);
    }

    public void nullPlusNonNullIsNull(boolean bl) {
        this.setBoolValue("nullPlusNonNullIsNull", bl);
    }

    public void nullsAreSortedAtEnd(boolean bl) {
        this.setBoolValue("nullsAreSortedAtEnd", bl);
    }

    public void nullsAreSortedAtStart(boolean bl) {
        this.setBoolValue("nullsAreSortedAtStart", bl);
    }

    public void nullsAreSortedHigh(boolean bl) {
        this.setBoolValue("nullsAreSortedHigh", bl);
    }

    public void nullsAreSortedLow(boolean bl) {
        this.setBoolValue("nullsAreSortedLow", bl);
    }

    public void supportsAlterTableWithAddColumn(boolean bl) {
        this.setBoolValue("AlterTableWithAddColumn", bl);
    }

    public void supportsAlterTableWithDropColumn(boolean bl) {
        this.setBoolValue("AlterTableWithDropColumn", bl);
    }

    public void supportsANSI92EntryLevelSQL(boolean bl) {
        this.setBoolValue("ANSI92EntryLevelSQL", bl);
    }

    public void supportsANSI92FullSQL(boolean bl) {
        this.setBoolValue("ANSI92FullSQL", bl);
    }

    public void supportsANSI92IntermediateSQL(boolean bl) {
        this.setBoolValue("ANSI92IntermediateSQL", bl);
    }

    public void supportsBatchUpdates(boolean bl) {
        this.setBoolValue("BatchUpdates", bl);
    }

    public void supportsCatalogsInDataManipulation(boolean bl) {
        this.setBoolValue("CatalogsInDataManipulation", bl);
    }

    public void supportsCatalogsInIndexDefinitions(boolean bl) {
        this.setBoolValue("CatalogsInIndexDefinitions", bl);
    }

    public void supportsCatalogsInPrivilegeDefinitions(boolean bl) {
        this.setBoolValue("CatalogsInPrivilegeDefinitions", bl);
    }

    public void supportsCatalogsInProcedureCalls(boolean bl) {
        this.setBoolValue("CatalogsInProcedureCalls", bl);
    }

    public void supportsCatalogsInTableDefinitions(boolean bl) {
        this.setBoolValue("CatalogsInTableDefinitions", bl);
    }

    public void supportsColumnAliasing(boolean bl) {
        this.setBoolValue("ColumnAliasing", bl);
    }

    public void supportsCoreSQLGrammar(boolean bl) {
        this.setBoolValue("CoreSQLGrammar", bl);
    }

    public void supportsCorrelatedSubqueries(boolean bl) {
        this.setBoolValue("CorrelatedSubqueries", bl);
    }

    public void supportsDataDefinitionAndDataManipulationTransactions(boolean bl) {
        this.setBoolValue("DataDefinitionAndDataManipulationTransactions", bl);
    }

    public void supportsDataManipulationTransactionsOnly(boolean bl) {
        this.setBoolValue("DataManipulationTransactionsOnly", bl);
    }

    public void supportsDifferentTableCorrelationNames(boolean bl) {
        this.setBoolValue("DifferentTableCorrelationNames", bl);
    }

    public void supportsExpressionsInOrderBy(boolean bl) {
        this.setBoolValue("ExpressionsInOrderBy", bl);
    }

    public void supportsExtendedSQLGrammar(boolean bl) {
        this.setBoolValue("ExtendedSQLGrammar", bl);
    }

    public void supportsFullOuterJoins(boolean bl) {
        this.setBoolValue("FullOuterJoins", bl);
    }

    public void supportsGetGeneratedKeys(boolean bl) {
        this.setBoolValue("GetGeneratedKeys", bl);
    }

    public void supportsGroupBy(boolean bl) {
        this.setBoolValue("GroupBy", bl);
    }

    public void supportsGroupByBeyondSelect(boolean bl) {
        this.setBoolValue("GroupByBeyondSelect", bl);
    }

    public void supportsGroupByUnrelated(boolean bl) {
        this.setBoolValue("GroupByUnrelated", bl);
    }

    public void supportsIntegrityEnhancementFacility(boolean bl) {
        this.setBoolValue("IntegrityEnhancementFacility", bl);
    }

    public void supportsLikeEscapeClause(boolean bl) {
        this.setBoolValue("LikeEscapeClause", bl);
    }

    public void supportsLimitedOuterJoins(boolean bl) {
        this.setBoolValue("LimitedOuterJoins", bl);
    }

    public void supportsMinimumSQLGrammar(boolean bl) {
        this.setBoolValue("MinimumSQLGrammar", bl);
    }

    public void supportsMixedCaseIdentifiers(boolean bl) {
        this.setBoolValue("MixedCaseIdentifiers", bl);
    }

    public void supportsMixedCaseQuotedIdentifiers(boolean bl) {
        this.setBoolValue("MixedCaseQuotedIdentifiers", bl);
    }

    public void supportsMultipleOpenResults(boolean bl) {
        this.setBoolValue("MultipleOpenResults", bl);
    }

    public void supportsMultipleResultSets(boolean bl) {
        this.setBoolValue("MultipleResultSets", bl);
    }

    public void supportsMultipleTransactions(boolean bl) {
        this.setBoolValue("MultipleTransactions", bl);
    }

    public void supportsNamedParameters(boolean bl) {
        this.setBoolValue("NamedParameters", bl);
    }

    public void supportsNonNullableColumns(boolean bl) {
        this.setBoolValue("NonNullableColumns", bl);
    }

    public void supportsOpenCursorsAcrossCommit(boolean bl) {
        this.setBoolValue("OpenCursorsAcrossCommit", bl);
    }

    public void supportsOpenCursorsAcrossRollback(boolean bl) {
        this.setBoolValue("OpenCursorsAcrossRollback", bl);
    }

    public void supportsOpenStatementsAcrossCommit(boolean bl) {
        this.setBoolValue("OpenStatementsAcrossCommit", bl);
    }

    public void supportsOpenStatementsAcrossRollback(boolean bl) {
        this.setBoolValue("OpenStatementsAcrossRollback", bl);
    }

    public void supportsOrderByUnrelated(boolean bl) {
        this.setBoolValue("OrderByUnrelated", bl);
    }

    public void supportsOuterJoins(boolean bl) {
        this.setBoolValue("OuterJoins", bl);
    }

    public void supportsPositionedDelete(boolean bl) {
        this.setBoolValue("PositionedDelete", bl);
    }

    public void supportsPositionedUpdate(boolean bl) {
        this.setBoolValue("PositionedUpdate", bl);
    }

    public void supportsSavepoints(boolean bl) {
        this.setBoolValue("Savepoints", bl);
    }

    public void supportsSchemasInDataManipulation(boolean bl) {
        this.setBoolValue("SchemasInDataManipulation", bl);
    }

    public void supportsSchemasInIndexDefinitions(boolean bl) {
        this.setBoolValue("SchemasInIndexDefinitions", bl);
    }

    public void supportsSchemasInPrivilegeDefinitions(boolean bl) {
        this.setBoolValue("SchemasInPrivilegeDefinitions", bl);
    }

    public void supportsSchemasInProcedureCalls(boolean bl) {
        this.setBoolValue("SchemasInProcedureCalls", bl);
    }

    public void supportsSchemasInTableDefinitions(boolean bl) {
        this.setBoolValue("SchemasInTableDefinitions", bl);
    }

    public void supportsSelectForUpdate(boolean bl) {
        this.setBoolValue("SelectForUpdate", bl);
    }

    public void supportsStatementPooling(boolean bl) {
        this.setBoolValue("StatementPooling", bl);
    }

    public void supportsStoredProcedures(boolean bl) {
        this.setBoolValue("StoredProcedures", bl);
    }

    public void supportsSubqueriesInComparisons(boolean bl) {
        this.setBoolValue("SubqueriesInComparisons", bl);
    }

    public void supportsSubqueriesInExists(boolean bl) {
        this.setBoolValue("SubqueriesInExists", bl);
    }

    public void supportsSubqueriesInIns(boolean bl) {
        this.setBoolValue("SubqueriesInIns", bl);
    }

    public void supportsSubqueriesInQuantifieds(boolean bl) {
        this.setBoolValue("SubqueriesInQuantifieds", bl);
    }

    public void supportsTableCorrelationNames(boolean bl) {
        this.setBoolValue("TableCorrelationNames", bl);
    }

    public void supportsTransactions(boolean bl) {
        this.setBoolValue("Transactions", bl);
    }

    public void supportsUnion(boolean bl) {
        this.setBoolValue("Union", bl);
    }

    public void supportsUnionAll(boolean bl) {
        this.setBoolValue("UnionAll", bl);
    }

    public void setExtraNameCharacters(String string) {
        this.setStringValue("ExtraNameCharacters", string);
    }

    public void setIdentifierQuoteString(String string) {
        this.setStringValue("IdentifierQuoteString", string);
    }

    public void setSQLKeywords(String string) {
        this.setStringValue("SQLKeywords", string);
    }

    public void setSearchStringEscape(String string) {
        this.setStringValue("SearchStringEscape", string);
    }

    public void setNumericFunctions(String string) {
        this.setStringValue("NumericFunctions", string);
    }

    public void setAggregateFunctions(String string) {
        this.setStringValue("AggregateFunctions", string);
    }

    public void setStringFunctions(String string) {
        this.setStringValue("StringFunctions", string);
    }

    public void setSystemFunctions(String string) {
        this.setStringValue("SystemFunctions", string);
    }

    public void setTimeDateFunctions(String string) {
        this.setStringValue("TimeDateFunctions", string);
    }

    public String toString() {
        NodeList nodeList = this.m_xmlData.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            stringBuffer.append(this.printNode(element));
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private String printNode(Element element) {
        String string = element.getNodeName() + "                                  ";
        Node node = element.getFirstChild();
        String string2 = node != null ? node.getNodeValue() : "";
        return "     - " + string.substring(0, 30) + "= '" + string2 + "'";
    }

    public Element getXMLData() {
        return this.m_xmlData;
    }

    public void print() {
        System.out.println(XMLNode.FromXmlNode2String(this.m_xmlData));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

