/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IDatabaseMetaData;
import com.baan.ow.b3.database.IResultSet;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.ResultSet;
import com.baan.owimpl.b3.database.ResultSetMetaData;
import com.baan.owimpl.b3.database.RowSet;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;

public class DatabaseMetaData
implements IDatabaseMetaData {
    protected static final ILogger s_logger = LoggerFactory.createLogger("com.baan.owimpl.b3.database", "DatabaseMetaData");
    private BackendConnection m_backendConnection = null;
    public static final String GET_TABLES = "@getTables";
    public static final String GET_TABLE_TYPES = "@getTableTypes";
    public static final String GET_COLUMNS = "@getColumns";
    public static final String GET_SPECIAL_COLUMNS = "@getSpecialColumns";
    public static final String GET_PRIMARY_KEYS = "@getPrimaryKeys";
    public static final String GET_INDEX_INFO = "@getIndexInfo";
    public static final String GET_IMPORTED_KEYS = "@getImportedKeys";
    public static final String GET_EXPORTED_KEYS = "@getExportedKeys";
    public static final String GET_CROSS_REFERENCE = "@getCrossReference";
    public static final String GET_TYPE_INFO = "@getTypeInfo";

    public DatabaseMetaData() {
    }

    public DatabaseMetaData(BackendConnection backendConnection) {
        this.m_backendConnection = backendConnection;
    }

    public IResultSet getTables(String string, String string2) throws DatabaseException {
        String[] stringArray = new String[]{string, string2};
        int n = this.m_backendConnection.getTimeout() * 2;
        return this.getDBMetaData(GET_TABLES, stringArray, n);
    }

    public IResultSet getTableTypes() throws DatabaseException {
        return this.getDBMetaData(GET_TABLE_TYPES, null, -1);
    }

    public IResultSet getColumns(String string, String string2) throws DatabaseException {
        String[] stringArray = new String[]{string, string2};
        return this.getDBMetaData(GET_COLUMNS, stringArray, -1);
    }

    public IResultSet getSpecialColumns(String string, int n, int n2, int n3) throws DatabaseException {
        String[] stringArray = new String[]{string, "" + n, "" + n2, "" + n3};
        return this.getDBMetaData(GET_SPECIAL_COLUMNS, stringArray, -1);
    }

    public IResultSet getPrimaryKeys(String string) throws DatabaseException {
        String[] stringArray = new String[]{string};
        return this.getDBMetaData(GET_PRIMARY_KEYS, stringArray, -1);
    }

    public IResultSet getIndexInfo(String string, boolean bl, boolean bl2) throws DatabaseException {
        String[] stringArray = new String[]{string, "" + bl, "" + bl2};
        return this.getDBMetaData(GET_INDEX_INFO, stringArray, -1);
    }

    public IResultSet getImportedKeys(String string) throws DatabaseException {
        String[] stringArray = new String[]{string};
        return this.getDBMetaData(GET_IMPORTED_KEYS, stringArray, -1);
    }

    public IResultSet getExportedKeys(String string) throws DatabaseException {
        String[] stringArray = new String[]{string};
        return this.getDBMetaData(GET_EXPORTED_KEYS, stringArray, -1);
    }

    public IResultSet getCrossReference(String string, String string2) throws DatabaseException {
        String[] stringArray = new String[]{string, string2};
        return this.getDBMetaData(GET_CROSS_REFERENCE, stringArray, -1);
    }

    public IResultSet getTypeInfo(int n) throws DatabaseException {
        String[] stringArray = new String[]{"" + n};
        return this.getDBMetaData(GET_TYPE_INFO, stringArray, -1);
    }

    private IResultSet getDBMetaData(String string, String[] stringArray, int n) throws DatabaseException {
        try {
            s_logger.message("get DataBaseMetaData for function'" + string + "'");
            Constructor constructor = new Constructor();
            constructor.addDatabaseMetaData(string, stringArray);
            DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor, n);
            Data data = dataSet.getFirstData();
            ResultSet resultSet = new ResultSet(new RowSet(data.getFirstNodeData()));
            ResultSetMetaData resultSetMetaData = new ResultSetMetaData(data.getNextData().getFirstNodeData());
            resultSet.setMetaData(resultSetMetaData);
            return resultSet;
        }
        catch (BusException busException) {
            s_logger.errorMessage("Error, DataBaseMetaData " + busException.getMessage());
            throw new DatabaseException("Communication link failure, Error get DataBaseMetaData " + busException.getMessage(), "08S01", 0);
        }
    }
}

