/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.Text;
import com.eibus.co.dom.ConstructorImpl;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.TextImpl;

public class Constructor
extends ConstructorImpl {
    public static final String LANGUAGE = "db";
    public static final String TAG_DB_PREPARE_STATEMENT = "PrepareSt";
    public static final String TAG_DB_EXECUTE_STATEMENT = "ExecuteSt";
    public static final String TAG_DB_RESET_STATEMENT = "ResetSt";
    public static final String TAG_DB_CLOSE_STATEMENT = "CloseSt";
    public static final String TAG_DB_GET_DATABASE_METADATA = "getDBMD";
    public static final String TAG_DB_GET_RESULTSET_METADATA = "getRSMD";
    public static final String TAG_DB_GET_PARAMETER_METADATA = "getParMD";
    public static final String TAG_DB_FETCH = "FetchRows";
    public static final String TAG_DB_IDENTIFY = "Identify";
    public static final String TAG_DB_INFORMATION = "DatabaseInfo";
    public static final String TAG_PARAMETER = "p";
    public static final String ATTR_SQL = "SQL";
    public static final String ATTR_START_POS = "start";
    public static final String ATTR_NR_ROWS = "size";
    public static final String ATTR_STATEMENT_ID = "StatementID";
    public static final String ATTR_DB_META_FUNCTION = "Function";
    public static final String DB_PREPARE_STATEMENT = "Prepare Statement";
    public static final String DB_EXECUTE_STATEMENT = "Execute Statement";
    public static final String DB_RESET_STATEMENT = "Reset Statement";
    public static final String DB_CLOSE_STATEMENT = "Close Statement";
    public static final String DB_GET_DATABASE_METADATA = "get Database MetaData";
    public static final String DB_GET_RESULTSET_METADATA = "get resultSet MetaData";
    public static final String DB_GET_PARAMETER_METADATA = "get Parameter MetaData";
    public static final String DB_FETCH = "Fetch some Rows";
    public static final String DB_IDENTIFY = "Identify Database Implementation";
    public static final String DB_INFORMATION = "Database Information";
    public static final int TYPE_IDENTIFY = 1;
    public static final int TYPE_GET_RESULTSET_METADATA = 2;
    public static final int TYPE_INFORMATION = 3;
    public static final int TYPE_PREPARE_STATEMENT = 4;
    public static final int TYPE_EXECUTE_STATEMENT = 5;
    public static final int TYPE_GET_PARAMETER_METADATA = 6;
    public static final int TYPE_RESET_STATEMENT = 7;
    public static final int TYPE_FETCH = 8;
    public static final int TYPE_CLOSE_STATEMENT = 9;
    public static final int TYPE_GET_DATABASE_METADATA = 10;
    public static final int TYPE_TEST = 11;
    private NodeList m_Questions = null;

    public void addIdentify() {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_IDENTIFY);
        this.appendChild(elementImpl);
    }

    public void addDatabaseInformation() {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_INFORMATION);
        this.appendChild(elementImpl);
    }

    public void addDatabaseMetaData(String string, String[] stringArray) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_GET_DATABASE_METADATA);
        elementImpl.setAttribute(ATTR_DB_META_FUNCTION, string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                ElementImpl elementImpl2 = new ElementImpl(TAG_PARAMETER);
                String string2 = stringArray[n];
                if (string2 == null) {
                    string2 = "";
                }
                TextImpl textImpl = new TextImpl(string2);
                elementImpl2.appendChild(textImpl);
                elementImpl.appendChild(elementImpl2);
                ++n;
            }
        }
        this.appendChild(elementImpl);
    }

    public void addResultSetMetaData(String string) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_GET_RESULTSET_METADATA);
        elementImpl.setAttribute(ATTR_STATEMENT_ID, string);
        this.appendChild(elementImpl);
    }

    public void addParameterMetaData(String string) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_GET_PARAMETER_METADATA);
        elementImpl.setAttribute(ATTR_STATEMENT_ID, string);
        this.appendChild(elementImpl);
    }

    public void addPrepareStatement(String string) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_PREPARE_STATEMENT);
        elementImpl.setAttribute(ATTR_SQL, string);
        this.appendChild(elementImpl);
    }

    public void addExecuteStatement(String string, String[] stringArray) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_EXECUTE_STATEMENT);
        elementImpl.setAttribute(ATTR_STATEMENT_ID, string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                ElementImpl elementImpl2 = new ElementImpl(TAG_PARAMETER);
                TextImpl textImpl = new TextImpl(stringArray[n]);
                elementImpl2.appendChild(textImpl);
                elementImpl.appendChild(elementImpl2);
                ++n;
            }
        }
        this.appendChild(elementImpl);
    }

    public void addCloseStatement(String string) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_CLOSE_STATEMENT);
        elementImpl.setAttribute(ATTR_STATEMENT_ID, string);
        this.appendChild(elementImpl);
    }

    public void addResetStatement(String string) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_RESET_STATEMENT);
        elementImpl.setAttribute(ATTR_STATEMENT_ID, string);
        this.appendChild(elementImpl);
    }

    public void addFetchRowsStatement(String string, int n, int n2) {
        ElementImpl elementImpl = new ElementImpl(TAG_DB_FETCH);
        elementImpl.setAttribute(ATTR_STATEMENT_ID, string);
        elementImpl.setAttribute(ATTR_START_POS, "" + n);
        elementImpl.setAttribute(ATTR_NR_ROWS, "" + n2);
        this.appendChild(elementImpl);
    }

    public int getFetchStartPos(int n) {
        ElementImpl elementImpl = (ElementImpl)this.m_Questions.item(n);
        String string = elementImpl.getAttribute(ATTR_START_POS);
        return Integer.parseInt(string);
    }

    public int getFetchNumberRows(int n) {
        ElementImpl elementImpl = (ElementImpl)this.m_Questions.item(n);
        String string = elementImpl.getAttribute(ATTR_NR_ROWS);
        return Integer.parseInt(string);
    }

    public String getDataBaseMetaDataFunction(int n) {
        ElementImpl elementImpl = (ElementImpl)this.m_Questions.item(n);
        return elementImpl.getAttribute(ATTR_DB_META_FUNCTION);
    }

    public String[] getParameters(int n) {
        try {
            ElementImpl elementImpl = (ElementImpl)this.m_Questions.item(n);
            NodeList nodeList = elementImpl.getChildNodes();
            String[] stringArray = new String[nodeList.getLength()];
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Text text = (Text)nodeList.item(n2).getFirstChild();
                stringArray[n2] = text != null ? text.getNodeValue() : "";
                ++n2;
            }
            return stringArray;
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public String getPrepareSQL(int n) {
        ElementImpl elementImpl = (ElementImpl)this.m_Questions.item(n);
        return elementImpl.getAttribute(ATTR_SQL);
    }

    public String getStatementID(int n) {
        ElementImpl elementImpl = (ElementImpl)this.m_Questions.item(n);
        return elementImpl.getAttribute(ATTR_STATEMENT_ID);
    }

    public int getNrQuestions() {
        return this.m_Questions.getLength();
    }

    public int getQuestionType(int n) {
        try {
            String string = this.m_Questions.item(n).getNodeName();
            if (string.equals(TAG_DB_FETCH)) {
                return 8;
            }
            if (string.equals(TAG_DB_IDENTIFY)) {
                return 1;
            }
            if (string.equals(TAG_DB_GET_RESULTSET_METADATA)) {
                return 2;
            }
            if (string.equals(TAG_DB_INFORMATION)) {
                return 3;
            }
            if (string.equals(TAG_DB_PREPARE_STATEMENT)) {
                return 4;
            }
            if (string.equals(TAG_DB_EXECUTE_STATEMENT)) {
                return 5;
            }
            if (string.equals(TAG_DB_CLOSE_STATEMENT)) {
                return 9;
            }
            if (string.equals(TAG_DB_RESET_STATEMENT)) {
                return 7;
            }
            if (string.equals(TAG_DB_GET_DATABASE_METADATA)) {
                return 10;
            }
            if (string.equals(TAG_DB_GET_PARAMETER_METADATA)) {
                return 6;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Constructor() {
        this.setLanguage(LANGUAGE);
    }

    public Constructor(com.eibus.co.Constructor constructor) {
        this.setLanguage(constructor.getLanguage());
        this.m_Questions = constructor.getChildNodes();
    }

    public String toString() {
        String string = "";
        if (this.m_Questions != null) {
            int n = 0;
            while (n < this.m_Questions.getLength()) {
                string = string + XMLNode.FromXmlNode2String(this.m_Questions.item(n)) + " - ";
                ++n;
            }
        }
        return "XML:" + XMLNode.FromXmlNode2String(this) + string;
    }
}

