/*
 * Decompiled with CFR 0.152.
 */
package com.baan.owimpl.b3.database;

import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IConnection;
import com.baan.ow.b3.database.IDatabaseInformation;
import com.baan.ow.b3.database.IDatabaseMetaData;
import com.baan.ow.b3.database.IPreparedStatement;
import com.baan.ow.b3.database.IStatement;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.b3.database.DatabaseMetaData;
import com.baan.owimpl.b3.database.Information;
import com.baan.owimpl.b3.database.PreparedStatement;
import com.baan.owimpl.b3.database.Statement;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.exception.BusException;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;

public class Connection
implements IConnection {
    private static final String BC_LOCAL_PROCESS = "localprocess";
    protected static final ILogger s_logger = LoggerFactory.createLogger(class$com$baan$owimpl$b3$database$Connection == null ? (class$com$baan$owimpl$b3$database$Connection = Connection.class$("com.baan.owimpl.b3.database.Connection")) : class$com$baan$owimpl$b3$database$Connection);
    protected static final String LOG_PREFIX = "DB Client: ";
    protected BackendConnection m_backendConnection = null;
    protected String m_productName = null;
    protected String m_productVersion = null;
    protected ILicense m_license = null;
    static /* synthetic */ Class class$com$baan$owimpl$b3$database$Connection;
    static /* synthetic */ Class class$java$lang$String;

    public static IConnection createConnection(String string, String string2, String string3, String string4, int n) throws DatabaseException {
        if (BC_LOCAL_PROCESS.equalsIgnoreCase(string)) {
            try {
                Class<?> clazz = Class.forName("com.baan.owimpl.b3.database_direct.Connection");
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
                java.lang.reflect.Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string2, string3, string4, new Integer(n)};
                Object obj = constructor.newInstance(objectArray);
                return (IConnection)obj;
            }
            catch (Exception exception) {
                throw new DatabaseException("Client unable to create connection " + exception.getMessage(), "08001", 0);
            }
        }
        return new Connection(string, string2, string3, string4, n);
    }

    protected Connection() {
    }

    public Connection(String string, String string2, String string3, String string4, int n) throws DatabaseException {
        this.CheckLicense(n);
        try {
            UserSession userSession = null;
            if (string2 != null && string3 != null) {
                BoiToolkit boiToolkit = BoiToolkit.getDefaultToolkit();
                IUserInfo iUserInfo = boiToolkit.createUserInfo();
                iUserInfo.setUsername(string2);
                iUserInfo.setPassword(string3);
                userSession = (UserSession)boiToolkit.createUserSession(iUserInfo);
            }
            this.m_backendConnection = new BackendConnection(string, userSession, "" + n + string4);
        }
        catch (BusException busException) {
            s_logger.errorMessage("Database client unable to establish connection, " + busException.getMessage() + " (possible couse: Database Model not supported by backend)");
            throw new DatabaseException("Client unable to establish connection, " + busException.getMessage(), "08001", 0);
        }
    }

    protected void CheckLicense(int n) throws DatabaseException {
        String string = "unknown";
        int n2 = 0;
        switch (n) {
            case 0: 
            case 1: {
                string = "Connector for ODBC";
                n2 = 7067;
                break;
            }
            case 2: {
                string = "Connector for JDBC";
                n2 = 7068;
                break;
            }
            case 3: {
                string = "Connector for OLE DB";
                n2 = 7069;
                break;
            }
            default: {
                s_logger.message("DB Client: Unknown API type '" + n + "' passed, cannot obtain a license");
                throw new DatabaseException("Unknown API type '" + n + "' passed, cannot obtain a license", "HY000", 0);
            }
        }
        try {
            s_logger.message("DB Client: Trying to obtain a machine (server) license for " + string + " (per connection)");
            this.m_license = LicenseFactory.createServerLicense(n2, string);
            int n3 = this.m_license.getDaysLeft();
            if (n3 < 0) {
                throw new DatabaseException(this.m_license.getMessage(), "HY000", 0);
            }
            if (n3 <= 14) {
                s_logger.message("DB Client: Licensing: " + this.m_license.getMessage());
            }
        }
        catch (LicenseException licenseException) {
            throw new DatabaseException(licenseException.getMessage(), "HY000", 0);
        }
    }

    public IPreparedStatement prepareStatement(String string) throws DatabaseException {
        return new PreparedStatement(this.m_backendConnection, string);
    }

    public IStatement createStatement() throws DatabaseException {
        return new Statement(this.m_backendConnection);
    }

    public IDatabaseMetaData getDatabaseMetaData() {
        return new DatabaseMetaData(this.m_backendConnection);
    }

    public IDatabaseInformation getInformation() throws DatabaseException {
        return new Information(this.m_backendConnection);
    }

    public String getDatabaseProductName() throws DatabaseException {
        if (this.m_productName == null) {
            this.identifyBackend();
        }
        return this.m_productName;
    }

    public String getDatabaseProductVersion() throws DatabaseException {
        if (this.m_productVersion == null) {
            this.identifyBackend();
        }
        return this.m_productVersion;
    }

    private void identifyBackend() throws DatabaseException {
        try {
            Constructor constructor = new Constructor();
            constructor.addIdentify();
            DataSet dataSet = this.m_backendConnection.sendAndWaitForAnswer(constructor);
            Data data = dataSet.getFirstData();
            Data data2 = data.getNextData();
            this.m_productName = data.getStringData();
            this.m_productVersion = data2.getStringData();
        }
        catch (BusException busException) {
            throw new DatabaseException(busException.getMessage());
        }
    }

    public void close() throws DatabaseException {
        s_logger.message("DB Client: Releasing license for connection");
        this.m_license.release();
        try {
            this.m_backendConnection.close();
        }
        catch (BusException busException) {
            throw new DatabaseException(busException.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName("DB_client");
    }
}

