/*
 * Decompiled with CFR 0.152.
 */
package com.baan.ow.test;

import com.baan.b3.dom.NamedNodeMap;
import com.baan.b3.dom.Node;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

class TestToolDOMWriter {
    protected BufferedWriter writer;
    OutputStream output;
    private boolean initialized = false;
    private Node root;
    private int initialLevel = 0;
    private int initialIndent = 4;
    boolean needsNewLine = true;
    protected static final String COMMENT_START = "<!--";
    protected static final String COMMENT_END = "-->";
    protected static final String HEADER = "<?xml version=\"1.0\"?>";
    protected static final char WHITESPACE = ' ';
    protected static final char EQUALS = '=';
    protected static final char QUOTE = '\"';
    protected static final char START_TAG = '<';
    protected static final char END_TAG = '>';
    protected static final char SLASH = '/';
    protected static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    protected static final char[] LT = new char[]{'&', 'l', 't', ';'};
    protected static final char[] GT = new char[]{'&', 'g', 't', ';'};
    protected static final char[] QUOTE_ENTITY = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    protected static final char[] APOS_ENTITY = new char[]{'&', 'a', 'p', 'o', 's', ';'};

    protected void initialize() throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(this.output, "UTF8"));
        this.write(this.root, this.initialLevel, this.initialIndent);
        this.writer.flush();
        this.initialized = true;
    }

    protected void writeDocumentFragment(Node node) throws IOException {
    }

    String convertToString() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                if (!this.initialized) {
                    this.initialize();
                }
                return ((ByteArrayOutputStream)this.output).toString("UTF8");
            }
            catch (IOException iOException) {
                return super.toString();
            }
        }
        return super.toString();
    }

    TestToolDOMWriter() {
    }

    TestToolDOMWriter(Node node) {
        this(node, new ByteArrayOutputStream(), 0, 4);
    }

    TestToolDOMWriter(Node node, int n, int n2) {
        this(node, new ByteArrayOutputStream(), n, n2);
    }

    TestToolDOMWriter(Node node, OutputStream outputStream, int n, int n2) {
        this.root = node;
        this.output = outputStream;
        this.initialLevel = n;
        this.initialIndent = n2;
    }

    protected void writeDTD(Node node) throws IOException {
    }

    protected void writeNotation(Node node) throws IOException {
    }

    protected void writeEntityReference(Node node) throws IOException {
    }

    protected void writeEntity(Node node) throws IOException {
    }

    protected void write(Node node, int n, int n2) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            default: {
                break;
            }
            case 9: {
                this.writer.write(HEADER);
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.write(node2, n, n2);
                    node2 = node2.getNextSibling();
                }
                if (!this.needsNewLine) break;
                this.newLine();
                this.indent(n, n2);
                return;
            }
            case 1: {
                Node node3;
                NamedNodeMap namedNodeMap;
                this.newLine();
                this.indent(n, n2);
                this.writer.write(60);
                String string = node.getNodeName();
                if (string != null) {
                    this.writer.write(string);
                }
                if ((namedNodeMap = node.getAttributes()) != null) {
                    int n3 = namedNodeMap.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        this.write(namedNodeMap.item(n4), n + 1, n2);
                        ++n4;
                    }
                }
                if ((node3 = node.getFirstChild()) == null) {
                    this.writer.write(47);
                    this.writer.write(62);
                    return;
                }
                this.writer.write(62);
                while (node3 != null) {
                    this.write(node3, n + 1, n2);
                    node3 = node3.getNextSibling();
                }
                if (this.needsNewLine) {
                    this.newLine();
                    this.indent(n, n2);
                }
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(string);
                this.writer.write(62);
                this.needsNewLine = true;
                return;
            }
            case 3: {
                String string = node.getNodeValue();
                if (string == null) {
                    this.needsNewLine = false;
                    return;
                }
                if (this.isSpace(string)) {
                    this.needsNewLine = true;
                    return;
                }
                this.needsNewLine = false;
                int n5 = string.length();
                int n6 = 0;
                while (n6 < n5) {
                    char c = string.charAt(n6);
                    if (c == '<') {
                        this.writer.write(LT);
                    } else if (c == '&') {
                        this.writer.write(AMP);
                    } else if (c == '>') {
                        this.writer.write(GT);
                    } else {
                        this.writer.write(c);
                    }
                    ++n6;
                }
                return;
            }
            case 2: {
                this.writer.write(32);
                this.writer.write(node.getNodeName());
                this.writer.write(61);
                this.writer.write(34);
                String string = node.getNodeValue();
                if (string != null) {
                    int n7 = 0;
                    while (n7 < string.length()) {
                        char c = string.charAt(n7);
                        if (c == '\"') {
                            this.writer.write(QUOTE_ENTITY);
                        } else if (c == '\'') {
                            this.writer.write(APOS_ENTITY);
                        } else if (c == '<') {
                            this.writer.write(LT);
                        } else if (c == '&') {
                            this.writer.write(AMP);
                        } else {
                            this.writer.write(c);
                        }
                        ++n7;
                    }
                }
                this.writer.write(34);
                return;
            }
            case 4: {
                this.writeCDATA(node);
                return;
            }
            case 8: {
                this.newLine();
                this.indent(n, n2);
                this.writer.write(COMMENT_START);
                this.writer.write(node.getNodeValue());
                this.writer.write(COMMENT_END);
                return;
            }
            case 11: {
                this.writeDocumentFragment(node);
                return;
            }
            case 10: {
                this.writeDTD(node);
                return;
            }
            case 6: {
                this.writeEntity(node);
                return;
            }
            case 5: {
                this.writeEntityReference(node);
                return;
            }
            case 12: {
                this.writeNotation(node);
                return;
            }
            case 7: {
                this.writePI(node);
                return;
            }
        }
    }

    protected void newLine() throws IOException {
        this.writer.newLine();
    }

    void indent(int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.writer.write(32);
                ++n4;
            }
            ++n3;
        }
    }

    String writeNode(Node node, int n) {
        try {
            this.initialIndent = n;
            this.root = node;
            this.output = new ByteArrayOutputStream();
            this.initialize();
            return this.toString();
        }
        catch (IOException iOException) {
            return "Could not serialize node";
        }
    }

    protected void writeCDATA(Node node) throws IOException {
    }

    protected void writePI(Node node) throws IOException {
    }

    void flush() {
        try {
            if (!this.initialized) {
                this.initialize();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    byte[] getBytes() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                if (!this.initialized) {
                    this.initialize();
                }
                return ((ByteArrayOutputStream)this.output).toByteArray();
            }
            catch (IOException iOException) {
                return super.toString().getBytes();
            }
        }
        return super.toString().getBytes();
    }

    boolean isSpace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

