/*
 * Decompiled with CFR 0.152.
 */
package com.baan.ow.jndi.xml;

import com.baan.ow.jndi.xml.XmlCtx;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.sun.jndi.misc.BASE64Decoder;
import com.sun.jndi.misc.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlFile {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.ow.jndi.xml", "XmlFile");
    private static DocumentBuilderFactory s_documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static TransformerFactory s_transformerFactory = TransformerFactory.newInstance();
    private static BASE64Decoder s_decoder = new BASE64Decoder();
    private static BASE64Encoder s_encoder = new BASE64Encoder();
    public static final String ROOTNAME = "root";
    public static final String CONTEXTNAME = "context";
    public static final String ATTR_ID = "Id";
    public static final String ATTR_DATA = "Data";
    public static final String ATTR_CLASS = "Class";
    private String m_url;
    private Document m_document = null;
    private long m_lastTime = 0L;

    public XmlFile(String string) throws NamingException {
        this.m_url = string;
        this.loadFile();
    }

    public synchronized Vector list(XmlCtx xmlCtx) throws NamingException {
        s_logger.flowMessage("list");
        Element element = this.getElementFromPath(xmlCtx);
        Vector<NameClassPair> vector = new Vector<NameClassPair>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() != 3) {
                String string = ((Element)node).getAttribute(ATTR_ID);
                String string2 = ((Element)node).getAttribute(ATTR_CLASS);
                NameClassPair nameClassPair = new NameClassPair(string, string2);
                vector.addElement(nameClassPair);
            }
            node = node.getNextSibling();
        }
        return vector;
    }

    public synchronized Object lookup(XmlCtx xmlCtx, String string) throws NamingException {
        s_logger.flowMessage("lookup " + string);
        Element element = this.getElementFromPath(xmlCtx);
        Element element2 = XmlFile.findChild(element, string);
        if (element2 == null) {
            throw new NameNotFoundException(string + " not found");
        }
        if (element2.getAttribute(ATTR_DATA).equals("true")) {
            String string2 = XmlFile.getTextFromElement(element2);
            return XmlFile.decodeObject(string2);
        }
        return null;
    }

    public synchronized void appendChild(XmlCtx xmlCtx, String string, Object object, Class clazz) throws NamingException {
        try {
            s_logger.flowMessage("appendChild " + string);
            Element element = this.getElementFromPath(xmlCtx);
            if (XmlFile.findChild(element, string) != null) {
                throw new NameAlreadyBoundException(string + " already exists");
            }
            Element element2 = this.m_document.createElement(CONTEXTNAME);
            element2.setAttribute(ATTR_ID, string);
            element2.setAttribute(ATTR_CLASS, clazz.getName());
            if (object != null) {
                String string2 = XmlFile.encodeObject(object);
                element2.appendChild(this.m_document.createTextNode(string2));
                element2.setAttribute(ATTR_DATA, "true");
            }
            element.appendChild(element2);
            this.saveFile();
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("AppendChild failed " + string);
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    public synchronized void removeChild(XmlCtx xmlCtx, String string) throws NamingException {
        try {
            s_logger.flowMessage("removeChild");
            Element element = this.getElementFromPath(xmlCtx);
            Element element2 = XmlFile.findChild(element, string);
            if (element2 == null) {
                throw new IOException(string + " not found");
            }
            element.removeChild(element2);
            this.saveFile();
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("RemoveChild failed " + string);
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private Element getElementFromPath(XmlCtx xmlCtx) throws NamingException {
        String string = xmlCtx.getPath();
        try {
            s_logger.flowMessage("  Find element " + string);
            this.loadFile();
            return (Element)XPathAPI.selectSingleNode((Node)this.m_document, (String)string);
        }
        catch (TransformerException transformerException) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException("Cannot find element " + string);
            nameNotFoundException.setRootCause(transformerException);
            throw nameNotFoundException;
        }
    }

    private static Element findChild(Element element, String string) {
        if (element != null) {
            Node node = element.getFirstChild();
            while (node != null) {
                String string2;
                if (node instanceof Element && (string2 = ((Element)node).getAttribute(ATTR_ID)).equalsIgnoreCase(string)) {
                    return (Element)node;
                }
                node = node.getNextSibling();
            }
        }
        return null;
    }

    private static String getTextFromElement(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 3) {
                stringBuffer.append(node2.getNodeValue());
            }
            node2 = node2.getNextSibling();
        }
        return stringBuffer.toString().trim();
    }

    private long getLastModified() {
        try {
            URL uRL = new URL(this.m_url);
            URLConnection uRLConnection = uRL.openConnection();
            return uRLConnection.getLastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private void loadFile() throws NamingException {
        try {
            long l = this.getLastModified();
            if (this.m_document != null && l > 0L && l <= this.m_lastTime) {
                return;
            }
            this.m_lastTime = l;
            s_logger.flowMessage("  Parsing " + this.m_url);
            DocumentBuilder documentBuilder = s_documentBuilderFactory.newDocumentBuilder();
            this.m_document = documentBuilder.parse(this.m_url);
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("Cannot parse file " + this.m_url);
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private void saveFile() throws NamingException {
        try {
            s_logger.message("  Saving configuration to " + this.m_url);
            OutputStream outputStream = XmlFile.getOutputStreamFromUrl(this.m_url);
            Transformer transformer = s_transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.m_document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
            outputStream.flush();
            outputStream.close();
            this.m_lastTime = this.getLastModified();
        }
        catch (Exception exception) {
            NoPermissionException noPermissionException = new NoPermissionException("Cannot save file " + this.m_url);
            noPermissionException.setRootCause(exception);
            throw noPermissionException;
        }
    }

    private static OutputStream getOutputStreamFromUrl(String string) throws IOException {
        URL uRL = new URL(string);
        try {
            return uRL.openConnection().getOutputStream();
        }
        catch (UnknownServiceException unknownServiceException) {
            return new FileOutputStream(uRL.getFile());
        }
    }

    private static InputStream getInputStreamFromUrl(String string) throws IOException {
        URL uRL = new URL(string);
        try {
            return uRL.openConnection().getInputStream();
        }
        catch (UnknownServiceException unknownServiceException) {
            return new FileInputStream(uRL.getFile());
        }
    }

    private static String encodeObject(Object object) throws NamingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return s_encoder.encodeBuffer(byArray);
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("Object cannot be encoded");
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private static Object decodeObject(String string) throws NamingException {
        try {
            byte[] byArray = s_decoder.decodeBuffer(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("Object cannot be decoded");
            namingException.setRootCause(exception);
            throw namingException;
        }
    }
}

