/*
 * Decompiled with CFR 0.152.
 */
package com.baan.ow.jndi.xml;

import com.baan.ow.jndi.xml.XmlFile;
import com.baan.ow.jndi.xml.XmlNameParser;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class XmlCtx
implements Context {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.ow.jndi.xml", "XmlCtx");
    private static Object s_lock = new Object();
    private static final String ERROR_READ_ONLY = "The URL is read-only";
    private static final String ERROR_ROOT_NODE = "The XML file has invalid root node, name must be 'root'";
    private static final String ERROR_NAME_EMPTY = "Name may not be empty";
    private static final String ERROR_RENAME = "rename not supported";
    private static final String ERROR_LISTBINDINGS = "listBindings not supported";
    private static NameParser s_nameParser = new XmlNameParser();
    private static Hashtable s_fileCache = new Hashtable();
    private String m_url = null;
    private XmlFile m_file = null;
    private XmlCtx m_parent = null;
    private String m_path = null;
    private Hashtable m_envProps = null;
    private boolean m_readOnly = false;
    private String m_name = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCtx(Hashtable hashtable) throws NamingException {
        Object object = s_lock;
        synchronized (object) {
            this.m_envProps = (Hashtable)hashtable.clone();
            this.m_url = (String)hashtable.get("java.naming.provider.url");
            this.m_readOnly = this.m_url.startsWith("http:");
            this.m_name = "root";
            this.m_path = "/" + this.m_name;
            this.m_file = (XmlFile)s_fileCache.get(this.m_url);
            if (this.m_file == null) {
                s_logger.message("Reading configuration from " + this.m_url);
                this.m_file = new XmlFile(this.m_url);
                s_fileCache.put(this.m_url, this.m_file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlCtx(XmlCtx xmlCtx, String string) throws NamingException {
        Object object = s_lock;
        synchronized (object) {
            this.m_parent = xmlCtx;
            this.m_url = xmlCtx.m_url;
            this.m_file = xmlCtx.m_file;
            this.m_envProps = xmlCtx.m_envProps;
            this.m_readOnly = xmlCtx.m_readOnly;
            this.m_name = string;
            this.m_path = xmlCtx.m_path + "/" + "context" + "[@" + "Id" + "='" + this.m_name + "']";
        }
    }

    public String getPath() {
        return this.m_path;
    }

    public String toString() {
        return this.m_name;
    }

    public void close() throws NamingException {
        s_logger.flowMessage("Close " + this);
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createSubcontext(Name name) throws NamingException {
        Object object = s_lock;
        synchronized (object) {
            if (this.m_readOnly) {
                s_logger.errorMessage(ERROR_READ_ONLY);
                throw new OperationNotSupportedException(ERROR_READ_ONLY);
            }
            if (name.isEmpty()) {
                s_logger.errorMessage(ERROR_NAME_EMPTY);
                throw new InvalidNameException(ERROR_NAME_EMPTY);
            }
            Name name2 = this.getMyComponents(name);
            String string = name2.get(0);
            if (name2.size() > 1) {
                XmlCtx xmlCtx = new XmlCtx(this, string);
                return xmlCtx.createSubcontext(name2.getSuffix(1));
            }
            s_logger.message("Create new subcontext, name: " + string);
            this.m_file.appendChild(this, string, null, this.getClass());
            return new XmlCtx(this, string);
        }
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (this.m_readOnly) {
            throw new OperationNotSupportedException(ERROR_READ_ONLY);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException(ERROR_NAME_EMPTY);
        }
        this.unbind(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Object object = s_lock;
        synchronized (object) {
            if (name.isEmpty()) {
                Vector vector = this.m_file.list(this);
                return new XmlNameEnumerator(vector);
            }
            Object object2 = this.lookup(name);
            if (object2 instanceof Context) {
                return ((Context)object2).list("");
            }
            throw new NotContextException(name + " cannot be listed");
        }
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        s_logger.errorMessage(ERROR_LISTBINDINGS);
        throw new OperationNotSupportedException(ERROR_LISTBINDINGS);
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(Name name) throws NamingException {
        Object object = s_lock;
        synchronized (object) {
            if (name.isEmpty()) {
                return this;
            }
            Name name2 = this.getMyComponents(name);
            String string = name2.get(0);
            if (name2.size() > 1) {
                XmlCtx xmlCtx = new XmlCtx(this, string);
                return xmlCtx.lookup(name2.getSuffix(1));
            }
            Object object2 = this.m_file.lookup(this, string);
            if (object2 != null) {
                return object2;
            }
            return new XmlCtx(this, string);
        }
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(new CompositeName(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Name name, Object object) throws NamingException {
        Object object2 = s_lock;
        synchronized (object2) {
            if (this.m_readOnly) {
                s_logger.errorMessage(ERROR_READ_ONLY);
                throw new OperationNotSupportedException(ERROR_READ_ONLY);
            }
            if (name.isEmpty()) {
                s_logger.errorMessage(ERROR_NAME_EMPTY);
                throw new InvalidNameException(ERROR_NAME_EMPTY);
            }
            Name name2 = this.getMyComponents(name);
            String string = name2.get(0);
            if (name2.size() > 1) {
                XmlCtx xmlCtx = new XmlCtx(this, string);
                xmlCtx.bind(name2.getSuffix(1), object);
                return;
            }
            s_logger.message("Bind object, name: " + string);
            this.m_file.appendChild(this, string, object, object.getClass());
        }
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(Name name, Object object) throws NamingException {
        Object object2 = s_lock;
        synchronized (object2) {
            this.unbind(name);
            this.bind(name, object);
        }
    }

    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(Name name) throws NamingException {
        Object object = s_lock;
        synchronized (object) {
            if (this.m_readOnly) {
                throw new OperationNotSupportedException(ERROR_READ_ONLY);
            }
            if (name.isEmpty()) {
                throw new InvalidNameException(ERROR_NAME_EMPTY);
            }
            Name name2 = this.getMyComponents(name);
            String string = name2.get(0);
            if (name2.size() > 1) {
                XmlCtx xmlCtx = new XmlCtx(this, string);
                xmlCtx.unbind(name2.getSuffix(1));
                return;
            }
            s_logger.message("Unbind object, name: " + string);
            this.m_file.removeChild(this, string);
        }
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    public void rename(Name name, Name name2) throws NamingException {
        s_logger.errorMessage(ERROR_RENAME);
        throw new OperationNotSupportedException(ERROR_RENAME);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.m_envProps == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.m_envProps.clone();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (object == null) {
            return this.removeFromEnvironment(string);
        }
        if (this.m_envProps == null) {
            this.m_envProps = new Hashtable(5, 0.75f);
        }
        return this.m_envProps.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.m_envProps == null) {
            return null;
        }
        return this.m_envProps.remove(string);
    }

    public String getNameInNamespace() throws NamingException {
        Name name = s_nameParser.parse("");
        if (this.m_parent != null) {
            name.add(this.toString());
            name.add(this.m_parent.getNameInNamespace());
        }
        return name.toString();
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(new CompositeName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof Context) {
            ((Context)object).close();
        }
        return s_nameParser;
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    private Name getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return s_nameParser.parse(name.get(0));
        }
        return name;
    }

    class XmlNameEnumerator
    implements NamingEnumeration {
        private Enumeration m_enumeration;

        public XmlNameEnumerator(Vector vector) {
            this.m_enumeration = vector.elements();
        }

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            return this.m_enumeration.nextElement();
        }
    }
}

