/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class TestQuery3 {
    private static final String DRIVER = "com.baan.jdbc.BaanJDBCDriver";
    private static Connection connection;
    private static String backend;

    public static void main(String[] stringArray) {
        backend = stringArray[0];
        TestQuery3.testJDBC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testJDBC() {
        try {
            Class.forName(DRIVER);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class com.baan.jdbc.BaanJDBCDriver could not be found");
            System.err.println(classNotFoundException.toString());
        }
        try {
            System.out.println();
            String string = "jdbc:baan://" + backend;
            String string2 = "";
            String string3 = "";
            System.out.println("connection = DriverManager.getConnection(url, user, password);");
            connection = DriverManager.getConnection(string, string2, string3);
            System.out.println("DatabaseMetaData DBM = connection.getMetaData();");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            System.out.println("ResultSet rs = DBM.getTypeInfo();");
            Statement statement = connection.createStatement();
            String string4 = "select * from tmboa120";
            ResultSet resultSet = statement.executeQuery(string4);
            System.out.println("JDBC Performance test");
            int n = 5;
            statement.clearWarnings();
            connection.clearWarnings();
            statement.close();
        }
        catch (SQLException sQLException) {
            System.err.println("SQLException occurred");
            System.err.println(sQLException.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException.toString());
                }
            }
        }
    }

    private static void displayResultSet(ResultSet resultSet, boolean bl) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData;
        System.out.println();
        try {
            resultSetMetaData = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            return;
        }
        int n2 = resultSetMetaData.getColumnCount();
        if (bl) {
            n = 0;
            while (n < n2) {
                if (n > 0) {
                    System.out.print("|");
                }
                TestQuery3.displayField("" + resultSetMetaData.getColumnLabel(n + 1));
                ++n;
            }
            System.out.println();
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    System.out.print("|");
                }
                TestQuery3.displayField("" + resultSetMetaData.getColumnName(n3 + 1));
                ++n3;
            }
            System.out.println();
            int n4 = 0;
            while (n4 < n2) {
                if (n4 > 0) {
                    System.out.print("|");
                }
                TestQuery3.displayField("" + resultSetMetaData.getColumnType(n4 + 1));
                ++n4;
            }
            System.out.println();
            int n5 = 0;
            while (n5 < n2) {
                if (n5 > 0) {
                    System.out.print("|");
                }
                TestQuery3.displayField("" + resultSetMetaData.getColumnTypeName(n5 + 1));
                ++n5;
            }
            System.out.println();
            int n6 = 0;
            while (n6 < n2) {
                if (n6 > 0) {
                    System.out.print("|");
                }
                TestQuery3.displayField("" + resultSetMetaData.getColumnTypeName(n6 + 1));
                ++n6;
            }
            System.out.println();
            int n7 = 0;
            while (n7 < n2) {
                if (n7 > 0) {
                    System.out.print("|");
                }
                TestQuery3.displayField("---------------------");
                ++n7;
            }
            if (bl) {
                System.out.println();
            }
        }
        while (resultSet.next()) {
            n = 0;
            while (n < n2) {
                if (bl) {
                    if (n > 0) {
                        System.out.print("|");
                    }
                    TestQuery3.displayField("" + resultSet.getObject(n + 1));
                } else {
                    resultSet.getObject(n + 1);
                }
                ++n;
            }
            if (!bl) continue;
            System.out.println();
        }
    }

    private static void displayField(String string) {
        String string2 = "                                                 ";
        string2 = string2 + string + " ";
        string2 = string2.substring(string2.length() - 35, string2.length());
        System.out.print(string2);
    }

    private static void displayWarnings(SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            System.err.println(sQLWarning.toString());
            sQLWarning = sQLWarning.getNextWarning();
            System.err.println(sQLWarning.getMessage());
        }
    }

    static {
        backend = "";
    }
}

