/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class TestQuery {
    private static final String DRIVER = "com.baan.jdbc.BaanJDBCDriver";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Connection connection = null;
        if (stringArray.length == 0 || stringArray.length > 2) {
            System.err.println("Arguments: <buscomponent> <querytext>");
            return;
        }
        try {
            Class.forName(DRIVER);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class com.baan.jdbc.BaanJDBCDriver could not be found");
            System.err.println(classNotFoundException.toString());
        }
        try {
            String string = stringArray[0];
            String string2 = "jdbc:baan://" + string;
            String string3 = "";
            String string4 = "";
            connection = DriverManager.getConnection(string2, string3, string4);
            Statement statement = connection.createStatement();
            int n = statement.getFetchSize();
            n = statement.getMaxRows();
            n = statement.getQueryTimeout();
            String[] stringArray2 = new String[64];
            stringArray2[0] = "select ttadv100.* from ttadv100";
            stringArray2[1] = "SELECT ttadv100.* FROM ttadv100 AS SET WITH 5 ROWS";
            stringArray2[2] = "SELECT ttadv100.* FROM ttadv100 AS PREPARED SET WITH 12 ROWS";
            stringArray2[3] = "SELECT ttadv230.* FROM ttadv230 WHERE ttadv230.crus = \"pgeorge\"";
            stringArray2[4] = "SELECT ttadv100.cpac FROM ttadv100";
            stringArray2[5] = "SELECT ttadv100.cpac,ttadv100.dsca FROM ttadv100";
            stringArray2[6] = "SELECT ttadv380.* FROM ttadv380";
            stringArray2[7] = "SELECT ttadv111.* FROM ttadv111";
            stringArray2[8] = "SELECT ttadv230.*, ttadv100.dsca FROM ttadv230, ttadv100 WHERE ttadv100.cpac = ttadv230.cpac";
            stringArray2[9] = "SELECT ttadv100.cpac AS pck FROM ttadv100";
            stringArray2[10] = "SELECT ttadv100.cpac pck FROM ttadv100";
            stringArray2[11] = "SELECT ttadv100.cpac FROM ttadv100 a_b_c";
            stringArray2[12] = "SELECT ttadv230.* FROM ttadv230 WHERE ttadv230.cpac = \"tm\"";
            stringArray2[13] = "SELECT ttadv230.* FROM ttadv230 WHERE ttadv230.cpac = 'tm'";
            stringArray2[14] = "SELECT ttadv100.cpac:pck FROM ttadv100";
            stringArray2[15] = "select ttadv188.* from ttadv188";
            stringArray2[16] = "SELECT ttadv100.* FROM ttadv100 a_b_c AS SET WITH 15 ROWS";
            stringArray2[17] = "SELECT a_b_c.cpac FROM ttadv100 a_b_c";
            stringArray2[18] = "SELECT tiitm001.* FROM tiitm001";
            stringArray2[19] = "SELECT ttadv100.cpax FROM ttadv100";
            stringArray2[20] = "SELECT * FROM ttadv100";
            stringArray2[21] = "SELECT ttadv100.dsca, ttadv100_alias.dsca FROM ttadv200, ttadv100, ttadv100 AS ttadv100_alias WHERE ttadv200.cpac REFERS TO ttadv100 AND ttadv200.mpac REFERS TO ttadv100_alias AS SET WITH 20 ROWS";
            stringArray2[22] = "SELECT ttadv100.* FROM ttadv100 ORDER BY ttadv100.cpac DESC";
            stringArray2[23] = "SELECT ttadv200.cpac, ttadv200.cmod, ttadv200.cses, COUNT(*) FROM ttadv200 GROUP BY ttadv200.cpac, ttadv200.cmod, ttadv200.cses";
            stringArray2[24] = "SELECT ttadv200.cpac, ttadv200.cmod, ttadv200.cses FROM ttadv200 GROUP BY ttadv200.cpac, ttadv200.cmod, ttadv200.cses";
            stringArray2[25] = "SELECT COUNT(*) FROM ttadv200";
            stringArray2[26] = "SELECT COUNT(ttadv200.cpac) FROM ttadv200";
            stringArray2[27] = "SELECT COUNT(*) AS ttadv200_count FROM ttadv200";
            stringArray2[28] = "SELECT ttaad320.* FROM ttaad320";
            stringArray2[29] = "SELECT ttadv230.* FROM ttadv230 WHERE ttadv230.cpac = 'tm'";
            stringArray2[30] = "Select ttadv421.cpac, ttadv421.cmod, ttadv421.flno, count(ttadv421.indn) AS result From ttadv421 Where ttadv421.cpac = 'tt' and ttadv421.cmod = 'adv' and ttadv421.flno between '100' and '200' group by ttadv421.cpac, ttadv421.cmod, ttadv421.flno";
            stringArray2[31] = "Select ttadv421.cpac, ttadv421.cmod, ttadv421.flno, sum(ttadv421.indn) AS result From ttadv421 Where ttadv421.cpac = 'tt' and ttadv421.cmod = 'adv' and ttadv421.flno between '100' and '200' group by ttadv421.cpac, ttadv421.cmod, ttadv421.flno";
            stringArray2[32] = "Select ttadv421.cpac, ttadv421.cmod, ttadv421.flno, sum(ttadv421.indn) AS result From ttadv421 Where ttadv421.cpac = 'tt' and ttadv421.cmod = 'adv' and ttadv421.flno between '100' and '200' group by ttadv421.cpac, ttadv421.cmod, ttadv421.flno";
            stringArray2[33] = "select ttadv421.cpac, ttadv421.cmod, ttadv421.flno, count(ttadv421.indn) AS result from ttadv421 where cpac = 'tt' and cmod = 'adv' and exists (select ttadv420.flno from ttadv420 where ttadv420.flno = ttadv421.flno and ttadv420.flno between '000' and '100') group by ttadv421.cpac, ttadv421.cmod, ttadv421.flno";
            stringArray2[34] = "Select ttadv421.cpac, ttadv421.cmod, ttadv421.flno, avg(ttadv421.indn) result From ttadv421 Where ttadv421.cpac = 'tt' and ttadv421.cmod = 'adv' and ttadv421.flno between '100' and '200' group by ttadv421.cpac, ttadv421.cmod, ttadv421.flno";
            stringArray2[35] = "select ttadv101.cpac, ttadv101.cmod, ttadv100.dsca from ttadv100, ttadv101 where ttadv101 refers to ttadv100 and ttadv101.cpac = 'tt' and ttadv101.cmod inrange 'aaa' and 'bbb'";
            stringArray2[36] = "SELECT ttadv200.*, ttadv100.dsca, ttadv100_a.cpac cpac, ttadv100_a.dsca dsca FROM ttadv200, ttadv100, ttadv100 ttadv100_a WHERE ttadv200.cpac refers to ttadv100 AND ttadv200.date = {d '1970-08-05'} AND ttadv200.time = {t '18:01:23'} AND ttadv200.mpac refers to ttadv100_a AND ttadv200.cpac='cf'";
            stringArray2[37] = "select * from ttadv200";
            stringArray2[38] = "";
            stringArray2[39] = "";
            stringArray2[40] = "";
            String string5 = stringArray.length > 1 ? stringArray[1] : stringArray2[36];
            System.out.println("Query text is: " + string5);
            if (string5 != "") {
                ResultSet resultSet = statement.executeQuery(string5);
                TestQuery.displayResultSet(resultSet);
                TestQuery.test_resultsetmetadata(resultSet);
            }
            TestQuery.displayWarnings(statement.getWarnings());
            TestQuery.displayWarnings(connection.getWarnings());
            statement.clearWarnings();
            connection.clearWarnings();
            statement.close();
        }
        catch (SQLException sQLException) {
            System.err.println("SQLException occurred");
            System.err.println(sQLException.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException.toString());
                }
            }
        }
    }

    private static void displayTablesInfo(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            System.out.println("TABLE_NAME: " + resultSet.getString("TABLE_NAME"));
            System.out.println("TABLE_TYPE: " + resultSet.getString("TABLE_TYPE"));
            System.out.println("REMARKS: " + resultSet.getString("REMARKS"));
        }
    }

    private static void displayColumnInfo(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            System.out.println("TABLE_NAME: " + resultSet.getString("TABLE_NAME"));
            System.out.println("DB_TABLE_NAME: " + resultSet.getString("DB_TABLE_NAME"));
            System.out.println("COLUMN_NAME: " + resultSet.getString("COLUMN_NAME"));
            System.out.println("DB_COLUMN_NAME: " + resultSet.getString("DB_COLUMN_NAME"));
            System.out.println("REMARKS: " + resultSet.getString("REMARKS"));
        }
    }

    public static void displayResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData;
        try {
            resultSetMetaData = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            return;
        }
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                System.out.print("|");
            }
            System.out.print(TestQuery.print(resultSetMetaData.getColumnLabel(n2 + 1)));
            ++n2;
        }
        System.out.print("|");
        System.out.println(" (ColumnLabels)");
        int n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                System.out.print("|");
            }
            System.out.print(TestQuery.print(resultSetMetaData.getColumnName(n3 + 1)));
            ++n3;
        }
        System.out.print("|");
        System.out.println(" (ColumnNames)");
        int n4 = 0;
        while (n4 < n) {
            if (n4 > 0) {
                System.out.print("|");
            }
            System.out.print(TestQuery.print("" + resultSetMetaData.getColumnType(n4 + 1)));
            ++n4;
        }
        System.out.print("|");
        System.out.println(" (ColumnType)");
        int n5 = 0;
        while (n5 < n) {
            if (n5 > 0) {
                System.out.print("|");
            }
            System.out.print(TestQuery.print("---------------------"));
            ++n5;
        }
        System.out.print("|");
        System.out.println();
        while (resultSet.next()) {
            int n6 = 0;
            while (n6 < n) {
                if (n6 > 0) {
                    System.out.print("|");
                }
                System.out.print(TestQuery.print(resultSet.getObject(n6 + 1).toString()));
                ++n6;
            }
            System.out.print("|");
            System.out.println();
        }
    }

    private static String print(String string) {
        String string2 = "               ";
        string = " " + string + string2;
        return string.substring(0, 15);
    }

    public static void displayWarnings(SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            System.err.println(sQLWarning.toString());
            sQLWarning = sQLWarning.getNextWarning();
            System.err.println(sQLWarning.getMessage());
        }
    }

    private static void test_databasemetadata(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        boolean bl = databaseMetaData.isReadOnly();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = databaseMetaData.getTables("", "", "ttadv", stringArray);
        TestQuery.displayTablesInfo(resultSet);
        stringArray[0] = "SYSTEM TABLE";
        resultSet = databaseMetaData.getTables("", "", "ttadv", stringArray);
        TestQuery.displayTablesInfo(resultSet);
        stringArray[0] = "VIEW";
        resultSet = databaseMetaData.getTables("", "", "ttadv", stringArray);
        TestQuery.displayTablesInfo(resultSet);
        String[] stringArray2 = new String[]{"TABLE", "SYSTEM TABLE"};
        resultSet = databaseMetaData.getTables("", "", "ttadv", stringArray2);
        TestQuery.displayTablesInfo(resultSet);
        resultSet = databaseMetaData.getColumns("", "", "", "ttadv111.cust");
        TestQuery.displayColumnInfo(resultSet);
        resultSet = databaseMetaData.getColumns("", "", "ttadv111", "");
        TestQuery.displayColumnInfo(resultSet);
        resultSet = databaseMetaData.getIndexInfo("", "", "ttadv111", false, false);
        resultSet = databaseMetaData.getPrimaryKeys("", "", "ttadv111");
        connection.setReadOnly(true);
    }

    private static void test_resultsetmetadata(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            boolean bl = resultSetMetaData.isSearchable(n2);
            int n3 = resultSetMetaData.isNullable(n2);
            int n4 = resultSetMetaData.getColumnDisplaySize(n2);
            String string = resultSetMetaData.getColumnLabel(n2);
            String string2 = resultSetMetaData.getColumnName(n2);
            int n5 = resultSetMetaData.getPrecision(n2);
            int n6 = resultSetMetaData.getColumnType(n2);
            String string3 = resultSetMetaData.getColumnTypeName(n2);
            boolean bl2 = resultSetMetaData.isReadOnly(n2);
            ++n2;
        }
    }
}

