/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.b3.legacydirectory.DirectoryException;
import com.baan.b3.legacydirectory.DirectoryToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JDBCshooter
extends JFrame {
    private static final String DRIVER = "com.baan.jdbc.BaanJDBCDriver";
    private Connection m_connection = null;
    private JButton ButtonConnect;
    private JButton ButtonExecute;
    private JTextField TextFieldQuery;
    private JTextArea TextResult;
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;

    public JDBCshooter() {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ButtonExecute);
        this.setTitle("OpenWorld JDBC Query shooter");
        ((Component)this).setSize(400, 300);
        try {
            String[] stringArray = DirectoryToolkit.getDefaultToolkit().listAllBusComponentIds();
            int n = 0;
            while (n < stringArray.length) {
                this.jComboBox1.addItem(stringArray[n]);
                ++n;
            }
        }
        catch (DirectoryException directoryException) {
            this.TextResult.setText(directoryException.getMessage());
        }
        try {
            Class.forName(DRIVER);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.TextResult.setForeground(Color.RED);
            String[] stringArray = new String[]{"Class com.baan.jdbc.BaanJDBCDriver could not be found", classNotFoundException.getMessage()};
            this.TextResult.setText(stringArray[0] + "\n" + stringArray[1]);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.TextFieldQuery = new JTextField();
        this.ButtonExecute = new JButton();
        this.jPanel1 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.ButtonConnect = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.TextResult = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JDBCshooter.this.exitForm(windowEvent);
            }
        });
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BorderLayout());
        this.TextFieldQuery.setText("<your query>");
        this.TextFieldQuery.setMinimumSize(new Dimension(11, 18));
        this.TextFieldQuery.setPreferredSize(new Dimension(76, 18));
        this.jPanel3.add((Component)this.TextFieldQuery, "Center");
        this.ButtonExecute.setText("Exceute");
        this.ButtonExecute.setEnabled(false);
        this.ButtonExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDBCshooter.this.ButtonExecuteActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add((Component)this.ButtonExecute, "East");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jPanel1.setLayout(new BorderLayout());
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDBCshooter.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.jComboBox1, "Center");
        this.ButtonConnect.setText("Connect");
        this.ButtonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDBCshooter.this.ButtonConnectActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.ButtonConnect, "East");
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setAutoscrolls(true);
        this.TextResult.setBackground(new Color(0, 0, 0));
        this.TextResult.setFont(new Font("MonoSpaced", 0, 12));
        this.TextResult.setForeground(new Color(255, 255, 0));
        this.TextResult.setBorder(null);
        this.TextResult.setCaretColor(new Color(255, 102, 102));
        this.TextResult.setSelectionColor(new Color(204, 204, 204));
        this.TextResult.setAutoscrolls(false);
        this.jScrollPane1.setViewportView(this.TextResult);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel4, "Center");
        this.pack();
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
    }

    private void ButtonConnectActionPerformed(ActionEvent actionEvent) {
        this.TextResult.setText("");
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = "";
        try {
            string = (String)this.jComboBox1.getSelectedItem();
            String string2 = "jdbc:baan://" + string;
            String string3 = "";
            String string4 = "";
            this.m_connection = DriverManager.getConnection(string2, string3, string4);
            this.ButtonExecute.setEnabled(true);
            this.ButtonConnect.setEnabled(false);
            this.jComboBox1.setEnabled(false);
            this.setCursor(0);
        }
        catch (SQLException sQLException) {
            this.TextResult.setForeground(Color.RED);
            String[] stringArray = new String[]{"Error connecting BusComponent " + string, sQLException.getMessage()};
            this.TextResult.setText(stringArray[0] + "\n" + stringArray[1]);
            this.setCursor(0);
        }
    }

    private void ButtonExecuteActionPerformed(ActionEvent actionEvent) {
        this.TextResult.setText("");
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = this.TextFieldQuery.getText();
        try {
            Statement statement = this.m_connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            this.displayResultSet(resultSet);
            this.setCursor(0);
        }
        catch (SQLException sQLException) {
            this.TextResult.setForeground(Color.RED);
            String[] stringArray = new String[]{"Error executing:", string, sQLException.getMessage()};
            this.TextResult.setText(stringArray[0] + "\n" + stringArray[1] + "\n" + stringArray[2]);
            this.setCursor(0);
        }
    }

    public void displayResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData;
        this.TextResult.setForeground(Color.YELLOW);
        Vector vector = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            resultSetMetaData = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            return;
        }
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(JDBCshooter.print(resultSetMetaData.getColumnLabel(n2 + 1)));
            ++n2;
        }
        stringBuffer.append("|");
        stringBuffer.append(" (ColumnLabels)");
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(JDBCshooter.print(resultSetMetaData.getColumnName(n3 + 1)));
            ++n3;
        }
        stringBuffer.append("|");
        stringBuffer.append(" (ColumnNames)");
        stringBuffer.append("\n");
        int n4 = 0;
        while (n4 < n) {
            if (n4 > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(JDBCshooter.print("" + resultSetMetaData.getColumnType(n4 + 1)));
            ++n4;
        }
        stringBuffer.append("|");
        stringBuffer.append(" (ColumnType)");
        stringBuffer.append("\n");
        int n5 = 0;
        while (n5 < n) {
            if (n5 > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(JDBCshooter.print("--------------------------"));
            ++n5;
        }
        stringBuffer.append("|");
        stringBuffer.append("\n");
        while (resultSet.next()) {
            int n6 = 0;
            while (n6 < n) {
                if (n6 > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(JDBCshooter.print(resultSet.getObject(n6 + 1).toString()));
                ++n6;
            }
            stringBuffer.append("|");
            stringBuffer.append("\n");
        }
        this.TextResult.setText(stringBuffer.toString());
        this.TextResult.setCaretPosition(1);
    }

    private static String print(String string) {
        String string2 = "                      ";
        string = " " + string + string2;
        return string.substring(0, 22);
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        new JDBCshooter().show();
    }
}

