/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseEvent;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.services.licensing.LicenseListener;

public class JDBCLicense
implements LicenseListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "JDBCLicense");
    private static final String LOG_PREFIX = "JDBC : ";
    private static JDBCLicense m_instance = null;
    private boolean m_valid = false;
    private String m_ErrorMessage = "";
    private ILicense m_license;

    static JDBCLicense Instance() {
        if (m_instance == null) {
            m_instance = new JDBCLicense();
        }
        return m_instance;
    }

    private JDBCLicense() {
    }

    String getErrorMessage() {
        return this.m_ErrorMessage;
    }

    synchronized boolean isValid() {
        block5: {
            if (this.m_valid) {
                return true;
            }
            if (this.m_license != null) break block5;
            int n = 7068;
            String string = "JDBCConnector";
            try {
                this.m_license = LicenseFactory.createServerLicense(n, string);
                this.m_license.addLicenseListener(this);
                int n2 = this.m_license.getDaysLeft();
                if (n2 < 0) {
                    s_logger.message(LOG_PREFIX + this.m_license.getMessage());
                    this.m_valid = false;
                    this.m_ErrorMessage = this.m_license.getMessage();
                    break block5;
                }
                if (n2 <= 14) {
                    s_logger.message(LOG_PREFIX + this.m_license.getMessage());
                    this.m_valid = true;
                    break block5;
                }
                this.m_valid = true;
            }
            catch (LicenseException licenseException) {
                s_logger.errorMessage("JDBC : Licensing error: " + licenseException.getMessage());
                this.m_license = null;
                this.m_valid = false;
                this.m_ErrorMessage = licenseException.getMessage();
            }
        }
        return this.m_valid;
    }

    void release() {
        if (this.m_license != null) {
            this.m_license.removeLicenseListener(this);
            s_logger.message("JDBC : Release License");
            this.m_license.release();
            this.m_license = null;
        }
        this.m_valid = false;
        this.m_ErrorMessage = "License is released";
    }

    public void licenseChanged(LicenseEvent licenseEvent) {
        s_logger.message(LOG_PREFIX + licenseEvent.getMessage());
        switch (licenseEvent.getReason()) {
            case 1: 
            case 4: {
                this.m_valid = false;
                this.m_ErrorMessage = this.m_license.getMessage();
                break;
            }
            case 2: 
            case 3: {
                this.m_valid = true;
                this.m_ErrorMessage = "";
            }
        }
    }
}

