/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.jdbc.BusinessDocumentManagerEx;
import com.eibus.co.BusDoc;
import com.eibus.co.dom.BusinessDataElementImpl;
import com.eibus.co.dom.BusinessElementImpl;
import com.eibus.co.dom.ConstructorImpl;
import com.eibus.exception.BusException;
import java.sql.SQLException;

class JDBCConstructor
extends ConstructorImpl {
    public static final String FETCHSIZE_ATTR = "fetchsize";
    public static final String INCLUDEMETA_ATTR = "includemeta";
    public static final String CURSOR_ATTR = "cursor";
    public static final String PREPARED_ATTR = "prepared";
    public static final String PARAMETERS_TAG = "parameters";
    private BusinessDocumentManagerEx m_businessDocumentManager;
    private BusinessElementImpl m_query;
    private BusinessDataElementImpl m_queryText;

    JDBCConstructor(BusinessDocumentManagerEx businessDocumentManagerEx, String string) {
        this.m_businessDocumentManager = businessDocumentManagerEx;
        this.m_businessDocumentManager.addConstructor(this);
        this.setLanguage("QUERY");
        this.m_query = new BusinessElementImpl("query");
        this.appendChild(this.m_query);
        this.m_queryText = new BusinessDataElementImpl();
        this.m_query.appendChild(this.m_queryText);
        this.setQueryText(string);
    }

    BusDoc execute() throws SQLException {
        try {
            BusDoc busDoc = this.m_businessDocumentManager.retrieveData();
            if (busDoc == null) {
                this.m_businessDocumentManager.clearConstructors();
                throw new SQLException("No response received");
            }
            NodeList nodeList = busDoc.getDocumentElement().getElementsByTagName("dataset");
            if (nodeList == null) {
                this.m_businessDocumentManager.clearConstructors();
                throw new SQLException("No dataset(s) in busdoc");
            }
            int n = 0;
            while (n < nodeList.getLength()) {
                NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("error");
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    Node node = nodeList2.item(0);
                    NodeList nodeList3 = ((Element)node).getElementsByTagName("description");
                    String string = "Error description not found";
                    if (nodeList3 != null && nodeList3.getLength() > 0) {
                        string = nodeList3.item(0).getNodeValue();
                    }
                    nodeList3 = ((Element)node).getElementsByTagName("number");
                    int n2 = -1;
                    if (nodeList3 != null && nodeList3.getLength() > 0) {
                        n2 = Integer.parseInt(nodeList3.item(0).getNodeValue());
                    }
                    this.m_businessDocumentManager.clearConstructors();
                    throw new SQLException(string, "", n2);
                }
                ++n;
            }
            this.m_businessDocumentManager.clearConstructors();
            return busDoc;
        }
        catch (BusException busException) {
            this.m_businessDocumentManager.clearConstructors();
            throw new SQLException(busException.toString());
        }
    }

    public Node getRows(BusDoc busDoc) throws SQLException {
        NodeList nodeList = busDoc.getDocumentElement().getElementsByTagName("dataset");
        if (nodeList != null) {
            String string = String.valueOf(this.hashCode());
            int n = 0;
            while (n < nodeList.getLength()) {
                NodeList nodeList2;
                String string2;
                Node node = nodeList.item(n).getFirstChild();
                if (node != null && string.equals(string2 = ((Element)node).getAttribute("id")) && (nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("rows")) != null && nodeList2.getLength() > 0) {
                    return nodeList2.item(0);
                }
                ++n;
            }
        }
        return null;
    }

    public Node getMetaData(BusDoc busDoc) throws SQLException {
        NodeList nodeList = busDoc.getDocumentElement().getElementsByTagName("dataset");
        if (nodeList != null) {
            String string = String.valueOf(this.hashCode());
            int n = 0;
            while (n < nodeList.getLength()) {
                NodeList nodeList2;
                Node node = nodeList.item(n).getFirstChild();
                if (node != null && (nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("metadata")) != null && nodeList2.getLength() > 0) {
                    return nodeList2.item(0);
                }
                ++n;
            }
        }
        return null;
    }

    void setQueryText(String string) {
        this.m_queryText.setData(string);
    }

    void setFetchSize(int n) {
        this.m_query.setAttribute(FETCHSIZE_ATTR, String.valueOf(n));
    }

    void setIncludeMeta(boolean bl) {
        this.m_query.setAttribute(INCLUDEMETA_ATTR, String.valueOf(bl));
    }

    void setCursor(int n) {
        this.m_query.setAttribute(CURSOR_ATTR, String.valueOf(n));
    }
}

