/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.jdbc.JDBCConstructor;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.bdf.ProtocolErrors;
import com.eibus.co.BusDoc;
import com.eibus.co.Constructor;
import com.eibus.exception.BusException;
import com.eibus.services.guid.Guid;
import com.eibus.services.runtime.Registry;
import java.sql.SQLException;

class BusinessDocumentManagerEx
extends BusinessDocumentManager {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "BusinessDocumentManagerEx");
    public static final String ID_TAG = "id";
    private static final String LOG_PREFIX = "JDBC : ";
    private long m_timeoutFistRequest;
    private int m_processId;
    private BusDoc m_request;

    public BusinessDocumentManagerEx(long l) throws BusException {
        this.m_timeoutFistRequest = l;
        this.m_processId = -1;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void close() throws BusException {
        if (this.m_processId >= 0) {
            s_logger.message("JDBC : Close dispatcher for process id: " + this.m_processId);
            String string = "kill " + this.m_processId;
            JDBCConstructor jDBCConstructor = new JDBCConstructor(this, string);
            try {
                BusDoc busDoc = jDBCConstructor.execute();
            }
            catch (SQLException sQLException) {
                s_logger.errorException(sQLException);
            }
        }
        super.close();
    }

    public int addConstructor(Constructor constructor) {
        if (this.m_request == null) {
            this.m_request = this.factory.createBusDoc();
            this.m_request.getHeader().setProcessId("" + this.m_processId);
        }
        int n = constructor.hashCode();
        constructor.setAttribute(ID_TAG, String.valueOf(n));
        this.m_request.addCO(constructor);
        return n;
    }

    BusDoc retrieveData() throws BusException {
        long l = 0L;
        if (this.m_processId <= 0 && (l = this.getTimeOut()) < this.m_timeoutFistRequest) {
            s_logger.message("JDBC : Set timeout for first Request to " + this.m_timeoutFistRequest + " ms");
            this.setTimeOut(this.m_timeoutFistRequest);
        }
        Guid guid = this.m_request.getHeader().generateNewCorrelationId();
        LogEvent logEvent = LoggerFactory.createLogEvent(guid);
        logEvent.storeMessage("JDBC Connector, Create Busdoc, Process id = " + this.m_processId);
        Registry.registerManager(guid, null, null, this);
        BusDoc busDoc = this.sendAndWaitForAnswer(this.m_request);
        if (this.m_processId <= 0) {
            this.setTimeOut(l);
        }
        try {
            this.m_processId = Integer.parseInt(busDoc.getHeader().getProcessId());
        }
        catch (NumberFormatException numberFormatException) {
            throw new BusException("Protocol Error, Backend does not support 'com.baan.jdbc' protocol, use a Adapter for BaanERP Backend with DAS support");
        }
        this.m_request = null;
        Registry.unRegisterManager(guid, null, null);
        ProtocolErrors.seekAndThrowManagerExceptions(busDoc);
        LoggerFactory.removeLogEvent(guid);
        return busDoc;
    }

    void clearConstructors() {
        if (this.m_request != null) {
            this.m_request = null;
        }
    }
}

