/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

class BaanJDBCTypes {
    public static final int BAAN_DATATYPE_UNKNOWN = 0;
    public static final int BAAN_DATATYPE_BYTE = 1;
    public static final int BAAN_DATATYPE_INTEGER = 2;
    public static final int BAAN_DATATYPE_LONG = 3;
    public static final int BAAN_DATATYPE_FLOAT = 4;
    public static final int BAAN_DATATYPE_DOUBLE = 5;
    public static final int BAAN_DATATYPE_STRING = 6;
    public static final int BAAN_DATATYPE_DATE = 7;
    public static final int BAAN_DATATYPE_TIME = 8;
    public static final int BAAN_DATATYPE_TEXT = 9;
    public static final int BAAN_DATATYPE_MAIL = 10;
    public static final int BAAN_DATATYPE_ENUM = 11;
    public static final int BAAN_DATATYPE_BITSET = 12;
    public static final int BAAN_DATATYPE_COMBINED = 13;
    public static final int BAAN_DATATYPE_MULTIBYTE = 14;
    public static final int BAAN_DATATYPE_BOOLEAN = 30;
    static SimpleDateFormat simpleDateFormat;
    static Date DEFAULT_DATE;

    BaanJDBCTypes() {
    }

    static String getBaanTypeNameFromBaanType(int n) {
        switch (n) {
            case 1: {
                return "BYTE";
            }
            case 2: {
                return "INTEGER";
            }
            case 3: {
                return "LONG";
            }
            case 4: {
                return "FLOAT";
            }
            case 5: {
                return "DOUBLE";
            }
            case 6: {
                return "STRING";
            }
            case 7: {
                return "DATE";
            }
            case 8: {
                return "TIME";
            }
            case 9: {
                return "TEXT";
            }
            case 10: {
                return "MAIL";
            }
            case 11: {
                return "ENUM";
            }
            case 12: {
                return "BITSET";
            }
            case 13: {
                return "COMBINED";
            }
            case 14: {
                return "MULTIBYTE";
            }
            case 30: {
                return "BOOLEAN";
            }
        }
        return "";
    }

    static Date get_java_util_Date(String string) throws SQLException {
        String string2 = "[0-9]{4}-[0-9]{2}-[0-9]{2}";
        String string3 = string2 + "T[0-9]{2}:[0-9]{2}:[0-9]{2}";
        Date date = string.matches(string3) ? BaanJDBCTypes.String2Date(string) : (string.matches(string2) ? BaanJDBCTypes.String2Date(string + "T00:00:00") : null);
        if (date == null) {
            return new Date(0L);
        }
        return date;
    }

    public static synchronized Date String2Date(String string) {
        if (string == null) {
            return DEFAULT_DATE;
        }
        try {
            return simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            return DEFAULT_DATE;
        }
    }

    static String get_JDBC_Date_Escape_Sequence(java.sql.Date date) {
        String string = "" + date.getYear();
        String string2 = "" + date.getMonth();
        String string3 = "" + date.getDay();
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        return "{d '" + string + "-" + string2 + "-" + string3 + "'}";
    }

    static String get_JDBC_Time_Escape_Sequence(Time time) {
        String string = "" + time.getHours();
        String string2 = "" + time.getMinutes();
        String string3 = "" + time.getSeconds();
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        return "{t '" + string + ":" + string2 + ":" + string3 + "'}";
    }

    static String get_JDBC_TimeStamp_Escape_Sequence(Timestamp timestamp) {
        String string = "" + timestamp.getYear();
        String string2 = "" + timestamp.getMonth();
        String string3 = "" + timestamp.getDay();
        String string4 = "" + timestamp.getHours();
        String string5 = "" + timestamp.getMinutes();
        String string6 = "" + timestamp.getSeconds();
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if (string4.length() == 1) {
            string4 = "0" + string4;
        }
        if (string5.length() == 1) {
            string5 = "0" + string5;
        }
        if (string6.length() == 1) {
            string6 = "0" + string6;
        }
        return "{ts '" + string + "-" + string2 + "-" + string3 + " " + string4 + ":" + string5 + ":" + string6 + "'}";
    }

    static {
        DEFAULT_DATE = new Date(0L);
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }
}

