/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.b3.dom.Node;
import com.baan.jdbc.BaanJDBCConnection;
import com.baan.jdbc.BaanJDBCResultSet;
import com.baan.jdbc.JDBCConstructor;
import com.baan.jdbc.JDBCLicense;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDoc;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class BaanJDBCStatement
implements Statement {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "BaanJDBCStatement");
    int m_resultSetHoldability = 2;
    int m_resultSetType = 1003;
    int m_resultSetConcurrency = 1007;
    boolean m_closed = false;
    int m_fetchDirection = 1000;
    int m_fetchSize;
    int m_maxFieldSize = 0;
    int m_maxRows = 0;
    BaanJDBCConnection m_connection;
    String m_nativeSQL;
    JDBCLicense m_license = JDBCLicense.Instance();
    static final String LOG_PREFIX = "JDBC : ";

    BaanJDBCStatement(BaanJDBCConnection baanJDBCConnection, int n, int n2, int n3) throws SQLException {
        this.m_connection = baanJDBCConnection;
        this.m_resultSetType = n;
        this.m_resultSetConcurrency = n2;
        this.m_resultSetHoldability = n3;
        if (n != 1003) {
            s_logger.errorMessage("createStatement(): Specified resultSetType not implemented");
            throw new SQLException("createStatement(): Specified resultSetType not implemented");
        }
        if (n2 != 1007) {
            s_logger.errorMessage("createStatement(): Specified resultSetConcurrency not implemented");
            throw new SQLException("createStatement(): Specified resultSetConcurrency not implemented");
        }
        try {
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            this.m_fetchSize = adapterClientConfiguration.getIteratorSize();
        }
        catch (OWConfigurationException oWConfigurationException) {
            this.m_fetchSize = 0;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        return this.executeQueryMeta(string, false);
    }

    public ResultSet executeQueryMeta(String string, boolean bl) throws SQLException {
        Object object;
        if (!this.m_license.isValid()) {
            throw new SQLException(this.m_license.getErrorMessage());
        }
        s_logger.message("JDBC : Execute query: " + string);
        if (!string.toUpperCase().matches("\\s*SELECT\\b.*")) {
            s_logger.errorMessage("executeQuery without a proper SELECT statement");
            throw new SQLException("executeQuery without a proper SELECT statement");
        }
        this.m_nativeSQL = string;
        if (this.m_maxRows > 0) {
            object = ".*\\bAS\\b\\s+(\\bPREPARED\\b)?\\s*\\bSET\\b\\s*\\bWITH\\b\\s*[0-9][0-9]*\\s*\\bROWS\\b\\s*";
            if (!this.m_nativeSQL.toUpperCase().matches((String)object)) {
                object = ".*\\bAS\\b\\s+(\\bPREPARED\\b)?\\s*\\bSET\\b\\s*";
                this.m_nativeSQL = this.m_nativeSQL.toUpperCase().matches((String)object) ? this.m_nativeSQL + " WITH " + this.m_maxRows + " ROWS" : this.m_nativeSQL + " AS SET WITH " + this.m_maxRows + " ROWS";
            }
        }
        object = this.m_connection.createJDBCConstructor(this.m_nativeSQL);
        if (this.m_fetchSize > 0) {
            ((JDBCConstructor)object).setFetchSize(this.m_fetchSize);
        }
        ((JDBCConstructor)object).setIncludeMeta(bl);
        BusDoc busDoc = ((JDBCConstructor)object).execute();
        Node node = ((JDBCConstructor)object).getRows(busDoc);
        Node node2 = ((JDBCConstructor)object).getMetaData(busDoc);
        BaanJDBCResultSet baanJDBCResultSet = new BaanJDBCResultSet(this, node, node2);
        return baanJDBCResultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        s_logger.errorMessage("executeUpdate(): Not implemented");
        throw new SQLException("executeUpdate(): Not implemented");
    }

    public void close() throws SQLException {
        if (!this.m_closed) {
            this.m_closed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.m_maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.m_maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        return this.m_maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.m_maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    public int getQueryTimeout() throws SQLException {
        return this.m_connection.getTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.m_connection.setTimeout(n);
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
    }

    public boolean execute(String string) throws SQLException {
        s_logger.errorMessage("execute(): Not implemented");
        throw new SQLException("execute(): Not implemented");
    }

    public ResultSet getResultSet() throws SQLException {
        s_logger.errorMessage("getResultSet(): Not implemented");
        throw new SQLException("getResultSet(): Not implemented");
    }

    public int getUpdateCount() throws SQLException {
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.m_fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.m_fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.m_fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.m_resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.m_resultSetType;
    }

    public void addBatch(String string) throws SQLException {
        s_logger.errorMessage("addBatch(): Not implemented");
        throw new SQLException("addBatch(): Not implemented");
    }

    public void clearBatch() throws SQLException {
        s_logger.errorMessage("clearBatch(): Not implemented");
        throw new SQLException("clearBatch(): Not implemented");
    }

    public int[] executeBatch() throws SQLException {
        s_logger.errorMessage("executeBatch(): Not implemented");
        throw new SQLException("executeBatch(): Not implemented");
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    public boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        s_logger.errorMessage("getGeneratedKeys(): Not implemented");
        throw new SQLException("getGeneratedKeys(): Not implemented");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        s_logger.errorMessage("executeUpdate(): Not implemented");
        throw new SQLException("executeUpdate(): Not implemented");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        s_logger.errorMessage("executeUpdate(): Not implemented");
        throw new SQLException("executeUpdate(): Not implemented");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        s_logger.errorMessage("executeUpdate(): Not implemented");
        throw new SQLException("executeUpdate(): Not implemented");
    }

    public boolean execute(String string, int n) throws SQLException {
        s_logger.errorMessage("execute(): Not implemented");
        throw new SQLException("execute(): Not implemented");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        s_logger.errorMessage("execute(): Not implemented");
        throw new SQLException("execute(): Not implemented");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        s_logger.errorMessage("execute(): Not implemented");
        throw new SQLException("execute(): Not implemented");
    }

    public int getResultSetHoldability() throws SQLException {
        return this.m_resultSetHoldability;
    }

    String getNativeSQL() {
        return this.m_nativeSQL;
    }
}

