/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.jdbc.BaanJDBCResultSet;
import com.baan.jdbc.BaanJDBCTypes;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class BaanJDBCResultSetMetaData
implements ResultSetMetaData {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "BaanJDBCResultSetMetaData");
    private BaanJDBCResultSet m_resultSet;
    private Node m_metaData;
    private NodeList m_metaDataColumns;

    public BaanJDBCResultSetMetaData(BaanJDBCResultSet baanJDBCResultSet, Node node) throws SQLException {
        this.m_resultSet = baanJDBCResultSet;
        if (node != null) {
            this.m_metaData = node.cloneNode(true);
            this.m_metaDataColumns = this.m_metaData.getChildNodes();
        }
    }

    public int getColumnCount() throws SQLException {
        return this.m_metaData.getChildNodes().getLength();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        return !this.findColumnPropertyValue(n, "TYPE_NAME").equals(String.valueOf(9));
    }

    public boolean isCurrency(int n) throws SQLException {
        s_logger.errorMessage("isCurrency() not supported");
        throw new SQLException("isCurrency() not supported");
    }

    public int isNullable(int n) throws SQLException {
        try {
            return Integer.parseInt(this.findColumnPropertyValue(n, "NULLABLE"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean isSigned(int n) throws SQLException {
        s_logger.errorMessage("isSigned() not supported");
        throw new SQLException("isSigned() not supported");
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            return Integer.parseInt(this.findColumnPropertyValue(n, "COLUMN_SIZE"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.findColumnPropertyValue(n, "REMARKS");
    }

    public String getColumnName(int n) throws SQLException {
        return this.findColumnPropertyValue(n, "COLUMN_NAME");
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        try {
            return Integer.parseInt(this.findColumnPropertyValue(n, "DECIMAL_DIGITS"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getScale(int n) throws SQLException {
        return this.getColumnDisplaySize(n) - this.getPrecision(n);
    }

    public String getTableName(int n) throws SQLException {
        return this.findColumnPropertyValue(n, "TABLE_NAME");
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        int n2;
        try {
            n2 = Integer.parseInt(this.findColumnPropertyValue(n, "COLUMN_DEPTH"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        if (n2 > 1) {
            return 2003;
        }
        return this.getColumnBaseType(n);
    }

    public String getColumnTypeName(int n) throws SQLException {
        int n2;
        try {
            n2 = Integer.parseInt(this.findColumnPropertyValue(n, "TYPE_NAME"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        return BaanJDBCTypes.getBaanTypeNameFromBaanType(n2);
    }

    public boolean isReadOnly(int n) throws SQLException {
        return this.findColumnPropertyValue(n, "readonly").equals("true");
    }

    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        s_logger.errorMessage("getColumnClassName not supported");
        throw new SQLException("getColumnClassName not supported");
    }

    int getColumnBaseType(int n) throws SQLException {
        int n2;
        try {
            n2 = Integer.parseInt(this.findColumnPropertyValue(n, "DATA_TYPE"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        return n2;
    }

    private String findColumnPropertyValue(int n, String string) throws SQLException {
        String string2;
        Node node;
        Node node2;
        NodeList nodeList;
        Node node3 = this.findColumnNode(n);
        if (node3 != null && (nodeList = ((Element)node3).getElementsByTagName(string)).getLength() == 1 && (node2 = (node = nodeList.item(0)).getFirstChild()) != null && (string2 = node2.getNodeValue()) != null) {
            return string2;
        }
        return "";
    }

    private Node findColumnNode(int n) throws SQLException {
        if (this.m_metaDataColumns == null && n >= this.m_metaDataColumns.getLength()) {
            s_logger.errorMessage("BaanJDBCResultSetMetaData, Index out of bounds");
            throw new SQLException("BaanJDBCResultSetMetaData, Index out of bounds");
        }
        return this.m_metaDataColumns.item(n - 1);
    }
}

