/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.jdbc.BaanJDBCArray;
import com.baan.jdbc.BaanJDBCConnection;
import com.baan.jdbc.BaanJDBCPreparedStatement;
import com.baan.jdbc.BaanJDBCResultSetMetaData;
import com.baan.jdbc.BaanJDBCStatement;
import com.baan.jdbc.BaanJDBCTypes;
import com.baan.jdbc.JDBCConstructor;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDoc;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class BaanJDBCResultSet
implements ResultSet {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "BaanJDBCResultSet");
    private BaanJDBCStatement m_statement;
    private BaanJDBCConnection m_connection;
    private Node m_rows;
    private Node m_currentRow;
    private boolean newSet = false;
    private int setCount = 0;
    private boolean m_isAfterLast = false;
    private Hashtable m_columnUpdates = new Hashtable();
    private ResultSetMetaData m_resultSetMetaData;
    private boolean m_wasNull;
    private static String LINE_SEPERATOR = System.getProperty("line.seperator");

    private BaanJDBCResultSet() {
    }

    public BaanJDBCResultSet(BaanJDBCStatement baanJDBCStatement, Node node, Node node2) throws SQLException {
        this.m_statement = baanJDBCStatement;
        this.m_connection = (BaanJDBCConnection)baanJDBCStatement.getConnection();
        if (node != null) {
            this.m_rows = node.cloneNode(true);
        }
        if (node2 != null) {
            this.m_resultSetMetaData = new BaanJDBCResultSetMetaData(this, node2);
        }
    }

    public BaanJDBCResultSet(BaanJDBCPreparedStatement baanJDBCPreparedStatement, Node node, Node node2) throws SQLException {
        this.m_statement = baanJDBCPreparedStatement;
        this.m_connection = (BaanJDBCConnection)baanJDBCPreparedStatement.getConnection();
        if (node != null) {
            this.m_rows = node.cloneNode(true);
        }
        if (node2 != null) {
            this.m_resultSetMetaData = new BaanJDBCResultSetMetaData(this, node2);
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {}
    }

    public void close() throws SQLException {
        this.m_rows = null;
        this.m_resultSetMetaData = null;
    }

    public boolean next() throws SQLException {
        if (this.m_currentRow == null) {
            if (this.m_rows != null) {
                this.m_currentRow = this.m_rows.getFirstChild();
            }
        } else {
            if (this.newSet && this.m_currentRow != null) {
                this.newSet = false;
                return true;
            }
            this.m_currentRow = this.m_currentRow.getNextSibling();
            if (this.m_currentRow == null) {
                boolean bl = this.retrieveMoreRows();
                this.newSet = false;
                return bl;
            }
        }
        this.newSet = false;
        return this.m_currentRow != null;
    }

    private boolean retrieveMoreRows() throws SQLException {
        String string = this.getCursorName();
        if (!string.equals("")) {
            BusDoc busDoc;
            String string2 = this.m_statement.getNativeSQL();
            JDBCConstructor jDBCConstructor = this.m_connection.createJDBCConstructor(string2);
            jDBCConstructor.setCursor(Integer.parseInt(string));
            if (this.getFetchSize() > 0) {
                jDBCConstructor.setFetchSize(this.getFetchSize());
            }
            if ((busDoc = jDBCConstructor.execute()) != null) {
                Node node = jDBCConstructor.getRows(busDoc);
                this.m_rows = null;
                if (node != null) {
                    this.newSet = true;
                    ++this.setCount;
                    this.m_rows = node.cloneNode(true);
                    this.m_currentRow = this.m_rows.getFirstChild();
                    if (this.m_currentRow == null) {
                        this.m_isAfterLast = true;
                        return false;
                    }
                    return true;
                }
            }
        }
        this.m_isAfterLast = true;
        return false;
    }

    public boolean wasNull() throws SQLException {
        return this.m_wasNull;
    }

    private Node findColumnNode(Node node, int n) throws SQLException {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()) != null) {
            if (n > nodeList.getLength()) {
                s_logger.errorMessage("Index out of bounds" + n);
                throw new SQLException("Index out of bounds" + n);
            }
            return nodeList.item(n - 1);
        }
        s_logger.errorMessage("Error during lookup of column with index " + n);
        throw new SQLException("Error during lookup of column with index " + n);
    }

    private String getColumnNodeValue(Node node) throws SQLException {
        Node node2;
        if (node != null && (node2 = node.getFirstChild()) != null) {
            this.m_wasNull = false;
            return node2.getNodeValue();
        }
        this.m_wasNull = true;
        return "";
    }

    private String getRawData(int n) throws SQLException {
        return this.getColumnNodeValue(this.findColumnNode(this.m_currentRow, n));
    }

    public String getString(int n) throws SQLException {
        String string = this.getRawData(n);
        return string.replaceAll("\r", LINE_SEPERATOR);
    }

    private String getStringInternal(int n) throws SQLException {
        return this.getRawData(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getRawData(n);
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        int n2 = this.getInt(n);
        return n2 != 0;
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getRawData(n);
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public short getShort(int n) throws SQLException {
        String string = this.getRawData(n);
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getInt(int n) throws SQLException {
        String string = this.getRawData(n);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLong(int n) throws SQLException {
        String string = this.getRawData(n);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getRawData(n);
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getRawData(n);
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getRawData(n);
        try {
            return new BigDecimal(new BigInteger(string), n2);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        s_logger.errorMessage("getBytes() not supported");
        throw new SQLException("getBytes() not supported");
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getStringInternal(n);
        java.util.Date date = BaanJDBCTypes.get_java_util_Date(string);
        return new Date(date.getTime());
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getStringInternal(n);
        java.util.Date date = BaanJDBCTypes.get_java_util_Date(string);
        return new Time(date.getTime());
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getStringInternal(n);
        java.util.Date date = BaanJDBCTypes.get_java_util_Date(string);
        return new Timestamp(date.getTime());
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        s_logger.errorMessage("getAsciiStream() not supported");
        throw new SQLException("getAsciiStream() not supported");
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        s_logger.errorMessage("getUnicodeStream() not supported");
        throw new SQLException("getUnicodeStream() not supported");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        s_logger.errorMessage("getBinaryStream() not supported");
        throw new SQLException("getBinaryStream() not supported");
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        if (this.m_rows != null) {
            return ((Element)this.m_rows).getAttribute("cursor");
        }
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.m_resultSetMetaData == null) {
            Node node;
            String string = this.m_statement.getNativeSQL();
            JDBCConstructor jDBCConstructor = this.m_connection.createJDBCConstructor(string);
            jDBCConstructor.setIncludeMeta(true);
            jDBCConstructor.setFetchSize(-1);
            BusDoc busDoc = jDBCConstructor.execute();
            if (busDoc != null && (node = jDBCConstructor.getMetaData(busDoc)) != null) {
                this.m_resultSetMetaData = new BaanJDBCResultSetMetaData(this, node);
            }
        }
        if (this.m_resultSetMetaData == null) {
            s_logger.errorMessage("Error retrieving resultsetmetadata");
            throw new SQLException("Error retrieving resultsetmetadata");
        }
        return this.m_resultSetMetaData;
    }

    public Object getObject(int n) throws SQLException {
        int n2 = this.getMetaData().getColumnType(n);
        switch (n2) {
            case -6: {
                return new Byte(this.getByte(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 6: {
                return new Double(this.getDouble(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 2: {
                return this.getBigDecimal(n);
            }
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getAsciiStream(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBinaryStream(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case 2003: {
                return this.getArray(n);
            }
            case 16: {
                return new Boolean(this.getBoolean(n));
            }
            case 1111: {
                return this.getStringInternal(n);
            }
        }
        throw new SQLException("Unsupported SQL datatype: " + n2);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        NodeList nodeList;
        if (this.m_currentRow != null && (nodeList = this.m_currentRow.getChildNodes()) != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeName().equals(string)) {
                    return n + 1;
                }
                ++n;
            }
            s_logger.errorMessage("Error finding column " + string);
            throw new SQLException("Error finding column " + string);
        }
        s_logger.errorMessage("Error finding column " + string);
        throw new SQLException("Error finding column " + string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        s_logger.errorMessage("getCharacterStream() not supported");
        throw new SQLException("getCharacterStream() not supported");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getRawData(n);
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigDecimal("0");
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.m_rows == null || this.m_currentRow == null;
    }

    public boolean isAfterLast() throws SQLException {
        return this.m_rows == null || this.m_isAfterLast;
    }

    public boolean isFirst() throws SQLException {
        if (this.m_currentRow != null && this.m_rows.getFirstChild().equals(this.m_currentRow)) {
            return this.setCount == 0;
        }
        return false;
    }

    public boolean isLast() throws SQLException {
        if (this.m_currentRow != null && this.m_rows.getLastChild().equals(this.m_currentRow)) {
            return !this.retrieveMoreRows();
        }
        return false;
    }

    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            s_logger.errorMessage("beforeFirst() not supported in a forward-only ResultSet!");
            throw new SQLException("beforeFirst() not supported in a forward-only ResultSet!");
        }
        this.m_currentRow = null;
        this.m_isAfterLast = false;
    }

    public void afterLast() throws SQLException {
        if (this.getType() == 1003) {
            s_logger.errorMessage("afterLast() not supported in a forward-only ResultSet!");
            throw new SQLException("afterLast() not supported in a forward-only ResultSet!");
        }
        this.m_isAfterLast = true;
    }

    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            s_logger.errorMessage("first() not supported in a forward-only ResultSet!");
            throw new SQLException("first() not supported in a forward-only ResultSet!");
        }
        return this.m_rows != null && (this.m_currentRow = this.m_rows.getFirstChild()) != null;
    }

    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            s_logger.errorMessage("last() not supported in a forward-only ResultSet!");
            throw new SQLException("last() not supported in a forward-only ResultSet!");
        }
        while (this.retrieveMoreRows()) {
        }
        return this.m_rows != null && (this.m_currentRow = this.m_rows.getLastChild()) != null;
    }

    public int getRow() throws SQLException {
        s_logger.errorMessage("getRow() not supported");
        throw new SQLException("getRow() not supported");
    }

    public boolean absolute(int n) throws SQLException {
        s_logger.errorMessage("absolute() not supported");
        throw new SQLException("absolute() not supported");
    }

    public boolean relative(int n) throws SQLException {
        s_logger.errorMessage("relative() not supported");
        throw new SQLException("relative() not supported");
    }

    public boolean previous() throws SQLException {
        s_logger.errorMessage("previous() not supported");
        throw new SQLException("previous() not supported");
    }

    public void setFetchDirection(int n) throws SQLException {
        this.m_statement.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.m_statement.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.m_statement.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.m_statement.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.m_statement.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        return this.m_statement.getResultSetConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        return !((Element)this.m_currentRow).getAttribute("status").equals("updated");
    }

    public boolean rowInserted() throws SQLException {
        s_logger.errorMessage("rowInserted() not supported");
        throw new SQLException("rowInserted() not supported");
    }

    public boolean rowDeleted() throws SQLException {
        return ((Element)this.m_currentRow).getAttribute("status").equals("deleted");
    }

    public void updateNull(int n) throws SQLException {
        s_logger.errorMessage("updateNull() not supported");
        throw new SQLException("updateNull() not supported");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        s_logger.errorMessage("updateBoolean() not supported");
        throw new SQLException("updateBoolean() not supported");
    }

    public void updateByte(int n, byte by) throws SQLException {
        s_logger.errorMessage("updateByte() not supported");
        throw new SQLException("updateByte() not supported");
    }

    public void updateShort(int n, short s) throws SQLException {
        s_logger.errorMessage("updateShort() not supported");
        throw new SQLException("updateShort() not supported");
    }

    public void updateInt(int n, int n2) throws SQLException {
        s_logger.errorMessage("updateInt() not supported");
        throw new SQLException("updateInt() not supported");
    }

    public void updateLong(int n, long l) throws SQLException {
        s_logger.errorMessage("updateLong() not supported");
        throw new SQLException("updateLong() not supported");
    }

    public void updateFloat(int n, float f) throws SQLException {
        s_logger.errorMessage("updateFloat() not supported");
        throw new SQLException("updateFloat() not supported");
    }

    public void updateDouble(int n, double d) throws SQLException {
        s_logger.errorMessage("updateDouble() not supported");
        throw new SQLException("updateDouble() not supported");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        s_logger.errorMessage("updateBigDecimal() not supported");
        throw new SQLException("updateBigDecimal() not supported");
    }

    public void updateString(int n, String string) throws SQLException {
        s_logger.errorMessage("updateString() not supported");
        throw new SQLException("updateString() not supported");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        s_logger.errorMessage("updateBytes() not supported");
        throw new SQLException("updateBytes() not supported");
    }

    public void updateDate(int n, Date date) throws SQLException {
        s_logger.errorMessage("updateDate() not supported");
        throw new SQLException("updateDate() not supported");
    }

    public void updateTime(int n, Time time) throws SQLException {
        s_logger.errorMessage("updateTime() not supported");
        throw new SQLException("updateTime() not supported");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        s_logger.errorMessage("updateTimestamp() not supported");
        throw new SQLException("updateTimestamp() not supported");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        s_logger.errorMessage("updateAsciiStream() not supported");
        throw new SQLException("updateAsciiStream() not supported");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        s_logger.errorMessage("updateBinaryStream() not supported");
        throw new SQLException("updateBinaryStream() not supported");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        s_logger.errorMessage("updateCharacterStream() not supported");
        throw new SQLException("updateCharacterStream() not supported");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        s_logger.errorMessage("updateObject() not supported");
        throw new SQLException("updateObject() not supported");
    }

    public void updateObject(int n, Object object) throws SQLException {
        s_logger.errorMessage("updateObject() not supported");
        throw new SQLException("updateObject() not supported");
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        s_logger.errorMessage("insertRow() not supported");
        throw new SQLException("insertRow() not supported");
    }

    public void updateRow() throws SQLException {
        s_logger.errorMessage("updateRow() not supported");
        throw new SQLException("updateRow() not supported");
    }

    public void deleteRow() throws SQLException {
        s_logger.errorMessage("deleteRow() not supported");
        throw new SQLException("deleteRow() not supported");
    }

    public void refreshRow() throws SQLException {
        s_logger.errorMessage("refreshRow() not supported");
        throw new SQLException("refreshRow() not supported");
    }

    public void cancelRowUpdates() throws SQLException {
        s_logger.errorMessage("cancelRowUpdates() not supported");
        throw new SQLException("cancelRowUpdates() not supported");
    }

    public void moveToInsertRow() throws SQLException {
        s_logger.errorMessage("moveToInsertRow() not supported");
        throw new SQLException("moveToInsertRow() not supported");
    }

    public void moveToCurrentRow() throws SQLException {
        s_logger.errorMessage("moveToCurrentRow() not supported");
        throw new SQLException("moveToCurrentRow() not supported");
    }

    public Statement getStatement() throws SQLException {
        return this.m_statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        s_logger.errorMessage("getRef() not supported");
        throw new SQLException("getRef() not supported");
    }

    public Blob getBlob(int n) throws SQLException {
        s_logger.errorMessage("getBlob() not supported");
        throw new SQLException("getBlob() not supported");
    }

    public Clob getClob(int n) throws SQLException {
        s_logger.errorMessage("getClob() not supported");
        throw new SQLException("getClob() not supported");
    }

    public Array getArray(int n) throws SQLException {
        Node node = this.findColumnNode(this.m_currentRow, n);
        return new BaanJDBCArray(node, n, this.getMetaData());
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        try {
            return new URL(this.getStringInternal(n));
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.toString());
        }
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        s_logger.errorMessage("updateRef() not supported");
        throw new SQLException("updateRef() not supported");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        s_logger.errorMessage("updateBlob() not supported");
        throw new SQLException("updateBlob() not supported");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        s_logger.errorMessage("updateClob() not supported");
        throw new SQLException("updateClob() not supported");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        s_logger.errorMessage("updateArray() not supported");
        throw new SQLException("updateArray() not supported");
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }
}

