/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.jdbc.BaanJDBCConnection;
import com.baan.jdbc.BaanJDBCStatement;
import com.baan.jdbc.BaanJDBCTypes;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;

public class BaanJDBCPreparedStatement
extends BaanJDBCStatement
implements PreparedStatement {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "BaanJDBCPreparedStatement");
    private Hashtable m_parameters;
    private String m_nativeSQL;
    private String QueryId;
    private ResultSet m_LastResult = null;

    BaanJDBCPreparedStatement(BaanJDBCConnection baanJDBCConnection, String string, int n, int n2, int n3) throws SQLException {
        super(baanJDBCConnection, n, n2, n3);
        this.m_nativeSQL = string;
        if (!this.m_nativeSQL.toUpperCase().matches("\\s*SELECT\\b.*")) {
            throw new SQLException("executeQuery without a proper SELECT statement");
        }
        int n4 = this.m_nativeSQL.indexOf("?");
        int n5 = 1;
        while (n4 > 0) {
            this.m_nativeSQL = this.m_nativeSQL.replaceFirst("\\?", ":" + n5++);
            n4 = this.m_nativeSQL.indexOf("?");
        }
        if (this.m_maxRows > 0) {
            String string2 = ".*\\bAS\\b\\s+(\\bPREPARED\\b)?\\s*\\bSET\\b\\s*\\bWITH\\b\\s*[0-9][0-9]*\\s*\\bROWS\\b\\s*";
            if (!this.m_nativeSQL.toUpperCase().matches(string2)) {
                string2 = ".*\\bAS\\b\\s+(\\bPREPARED\\b)?\\s*\\bSET\\b\\s*";
                this.m_nativeSQL = this.m_nativeSQL.toUpperCase().matches(string2) ? this.m_nativeSQL + " WITH " + this.m_maxRows + " ROWS" : this.m_nativeSQL + " AS SET WITH " + this.m_maxRows + " ROWS";
            }
        }
        s_logger.message("JDBC : Prepared Statement created with query: '" + this.m_nativeSQL + "'");
        this.m_parameters = new Hashtable();
    }

    public void setNull(int n, int n2) throws SQLException {
        throw new SQLException("setNull(): Not implemented");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        s_logger.message("JDBC : setBoolean index " + n);
        this.checkParameterIndex(n);
        String string = "" + bl;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setByte(int n, byte by) throws SQLException {
        s_logger.message("JDBC : setByte index " + n);
        this.checkParameterIndex(n);
        String string = "" + by;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setShort(int n, short s) throws SQLException {
        s_logger.message("JDBC : setShort index " + n);
        this.checkParameterIndex(n);
        String string = "" + s;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setInt(int n, int n2) throws SQLException {
        s_logger.message("JDBC : setInt index " + n);
        this.checkParameterIndex(n);
        String string = "" + n2;
        Integer n3 = new Integer(n);
        this.m_parameters.put(n3, string);
    }

    public void setLong(int n, long l) throws SQLException {
        s_logger.message("JDBC : setLong index " + n);
        this.checkParameterIndex(n);
        String string = "" + l;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setFloat(int n, float f) throws SQLException {
        s_logger.message("JDBC : setFloat index " + n);
        this.checkParameterIndex(n);
        String string = "" + f;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setDouble(int n, double d) throws SQLException {
        s_logger.message("JDBC : setDouble index " + n);
        this.checkParameterIndex(n);
        String string = "" + d;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        s_logger.message("JDBC : setBigDecimal index " + n);
        this.checkParameterIndex(n);
        String string = "" + bigDecimal;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setString(int n, String string) throws SQLException {
        s_logger.message("JDBC : setString index " + n);
        this.checkParameterIndex(n);
        String string2 = "" + string;
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string2);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("setBytes(): Not implemented");
    }

    public void setDate(int n, Date date) throws SQLException {
        s_logger.message("JDBC : setDate index " + n);
        this.checkParameterIndex(n);
        String string = BaanJDBCTypes.get_JDBC_Date_Escape_Sequence(date);
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        s_logger.message("JDBC : setTime index " + n);
        this.checkParameterIndex(n);
        String string = BaanJDBCTypes.get_JDBC_Time_Escape_Sequence(time);
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        s_logger.message("JDBC : setTimestamp index " + n);
        this.checkParameterIndex(n);
        String string = BaanJDBCTypes.get_JDBC_TimeStamp_Escape_Sequence(timestamp);
        Integer n2 = new Integer(n);
        this.m_parameters.put(n2, string);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        s_logger.errorMessage("setAsciiStream(): Not implemented");
        throw new SQLException("setAsciiStream(): Not implemented");
    }

    private void checkParameterIndex(int n) throws SQLException {
        if (n < 1) {
            s_logger.message("JDBC : PreparedStatement setParamerIndex(" + n + ") not allowed (1-n)");
            throw new SQLException("PreparedStatement setParamerIndex(" + n + ") not allowed (1-n)");
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        s_logger.errorMessage("setUnicodeStream(): Not implemented, deprecated");
        throw new SQLException("setUnicodeStream(): Not implemented, deprecated");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        s_logger.errorMessage("setBinaryStream(): Not implemented, deprecated");
        throw new SQLException("setBinaryStream(): Not implemented, deprecated");
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        s_logger.errorMessage("setObject(): Not implemented, deprecated");
        throw new SQLException("setObject(): Not implemented, deprecated");
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        s_logger.errorMessage("setObject(): Not implemented, deprecated");
        throw new SQLException("setObject(): Not implemented, deprecated");
    }

    public void setObject(int n, Object object) throws SQLException {
        s_logger.errorMessage("setObject(): Not implemented, deprecated");
        throw new SQLException("setObject(): Not implemented, deprecated");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        s_logger.errorMessage("setDate(): Not implemented, deprecated");
        throw new SQLException("setDate(): Not implemented, deprecated");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        s_logger.errorMessage("setTime(): Not implemented, deprecated");
        throw new SQLException("setTime(): Not implemented, deprecated");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        s_logger.errorMessage("setTimestamp(): Not implemented, deprecated");
        throw new SQLException("setTimestamp(): Not implemented, deprecated");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        s_logger.errorMessage("setNull(): Not implemented, deprecated");
        throw new SQLException("setNull(): Not implemented, deprecated");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        s_logger.errorMessage("setURL(): Not implemented, deprecated");
        throw new SQLException("setURL(): Not implemented, deprecated");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        s_logger.errorMessage("setCharacterStream(): Not implemented, deprecated");
        throw new SQLException("setCharacterStream(): Not implemented, deprecated");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        s_logger.errorMessage("setRef(): Not implemented, deprecated");
        throw new SQLException("setRef(): Not implemented, deprecated");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        s_logger.errorMessage("setBlob(): Not implemented, deprecated");
        throw new SQLException("setBlob(): Not implemented, deprecated");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        s_logger.errorMessage("setClob(): Not implemented, deprecated");
        throw new SQLException("setClob(): Not implemented, deprecated");
    }

    public void setArray(int n, Array array) throws SQLException {
        s_logger.errorMessage("setArray(): Not implemented, deprecated");
        throw new SQLException("setArray(): Not implemented, deprecated");
    }

    public void addBatch() throws SQLException {
        s_logger.errorMessage("addBatch(): Not implemented");
        throw new SQLException("addBatch(): Not implemented");
    }

    public void clearParameters() throws SQLException {
        s_logger.message("JDBC : Parameters Prepared Statement cleared");
        this.m_parameters = new Hashtable();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.m_LastResult != null) {
            return this.m_LastResult.getMetaData();
        }
        this.execute();
        if (this.m_LastResult != null) {
            return this.m_LastResult.getMetaData();
        }
        return null;
    }

    public int executeUpdate() throws SQLException {
        s_logger.errorMessage("executeUpdate(): Not implemented");
        throw new SQLException("executeUpdate(): Not implemented");
    }

    public ResultSet executeQuery() throws SQLException {
        s_logger.message("JDBC : Execute prepared query: " + this.m_nativeSQL);
        String string = this.m_nativeSQL;
        String[] stringArray = new String[this.m_parameters.size()];
        int n = 1;
        while (n < this.m_parameters.size() + 1) {
            Object v = this.m_parameters.get(new Integer(n));
            if (v == null) {
                s_logger.errorMessage("PreparedStatement parameter " + n + "not set");
                throw new SQLException("PreparedStatement parameter " + n + "not set");
            }
            string = string.replaceFirst(":" + n, v.toString());
            s_logger.message("JDBC : PreparedStatement Parameter " + n + " = '" + v.toString() + "'");
            ++n;
        }
        s_logger.message("JDBC : PreparedStatement query = " + string);
        return super.executeQuery(string);
    }

    public boolean execute() throws SQLException {
        this.m_LastResult = this.executeQuery();
        return true;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        s_logger.errorMessage("getParameterMetaData(): Not implemented");
        throw new SQLException("getParameterMetaData(): Not implemented");
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_LastResult != null) {
            return this.m_LastResult;
        }
        this.execute();
        return this.m_LastResult;
    }
}

