/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.jdbc.BaanJDBCConnection;
import com.baan.jdbc.BaanJDBCStatement;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BaanJDBCDatabaseMetaData
implements DatabaseMetaData {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "BaanJDBCDatabaseMetaData");
    private static final String LOG_PREFIX = "JDBC :  DatabaseMetaData, ";
    private BaanJDBCConnection m_connection;
    private Statement m_statement;

    public BaanJDBCDatabaseMetaData(BaanJDBCConnection baanJDBCConnection) throws SQLException {
        this.m_connection = baanJDBCConnection;
        this.m_statement = this.m_connection.createStatement();
    }

    protected void finalize() {
        try {
            this.m_statement.close();
        }
        catch (SQLException sQLException) {}
    }

    public boolean allProceduresAreCallable() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, allProceduresAreCallable = FALSE");
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, allTablesAreSelectable = TRUE");
        return true;
    }

    public String getURL() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getURL not supported");
        throw new SQLException("getURL not supported");
    }

    public String getUserName() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getUserName not supported");
        return "BaanERP user";
    }

    public boolean isReadOnly() throws SQLException {
        boolean bl = true;
        ResultSet resultSet = this.m_statement.executeQuery("SELECT @@IsReadOnly()");
        if (resultSet != null) {
            if (resultSet.next()) {
                bl = resultSet.getBoolean("READONLY");
            } else {
                throw new SQLException("Error executing BaanJDBCDatabaseMetaData.isReadOnly()");
            }
        }
        resultSet.close();
        s_logger.message("JDBC :  DatabaseMetaData, isReadOnly returned " + bl);
        return bl;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, nullsAreSortedHigh = FALSE");
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, nullsAreSortedLow = FALSE");
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, nullsAreSortedAtStart = FALSE");
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, nullsAreSortedAtEnd = FALSE");
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getDatabaseProductName = ''");
        return "";
    }

    public String getDatabaseProductVersion() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getDatabaseProductVersion = ''");
        return "";
    }

    public String getDriverName() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getDriverName = 'Connector for JDBC'");
        return "Connector for JDBC";
    }

    public String getDriverVersion() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getDriverVersion = 1.0");
        return "1.0";
    }

    public int getDriverMajorVersion() {
        s_logger.message("JDBC :  DatabaseMetaData, DriverMajorVersion = 1");
        return 1;
    }

    public int getDriverMinorVersion() {
        s_logger.message("JDBC :  DatabaseMetaData, DriverMinorVersion = 0");
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, usesLocalFiles = FALSE");
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, usesLocalFilePerTable = FALSE");
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsMixedCaseIdentifiers = FALSE");
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, storesUpperCaseIdentifiers = FALSE");
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, storesLowerCaseIdentifiers = TRUE");
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, storesMixedCaseIdentifiers = FALSE");
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsMixedCaseQuotedIdentifiers = FALSE");
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, storesUpperCaseQuotedIdentifiers = FALSE");
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, storesLowerCaseQuotedIdentifiers = TRUE");
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, storesMixedCaseQuotedIdentifiers = FALSE");
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getIdentifierQuoteString = '");
        return "'";
    }

    public String getSQLKeywords() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getSQLKeywords = 'REFERS,TO,TEXT,USE,LANGUAGE,AS,PREPARED,SET,WITH,ROWS'");
        return "REFERS,TO,TEXT,USE,LANGUAGE,AS,PREPARED,SET,WITH,ROWS";
    }

    public String getNumericFunctions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getNumericFunctions = ''");
        return "";
    }

    public String getStringFunctions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getStringFunctions = ''");
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getSystemFunctions = ''");
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getTimeDateFunctions = 'd,t,ts'");
        return "d,t,ts";
    }

    public String getSearchStringEscape() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getSearchStringEscape = ''");
        return "";
    }

    public String getExtraNameCharacters() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getExtraNameCharacters = '^$[]'");
        return "^$[]";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsAlterTableWithAddColumn = FALSE");
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsAlterTableWithDropColumn = FALSE");
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsColumnAliasing = TRUE");
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, nullPlusNonNullIsNull = FALSE");
        return false;
    }

    public boolean supportsConvert() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsConvert = FALSE");
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsConvert(" + n + "," + n2 + ") = FALSE");
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsTableCorrelationNames = TRUE");
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsDifferentTableCorrelationNames = TRUE");
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsExpressionsInOrderBy = FALSE");
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsOrderByUnrelated = FALSE");
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsGroupBy = TRUE");
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsGroupByUnrelated = FALSE");
        return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsGroupByBeyondSelect = FALSE");
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsLikeEscapeClause = TRUE");
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsMultipleResultSets = FALSE");
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsMultipleTransactions = FALSE");
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsNonNullableColumns = FALSE");
        return false;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsMinimumSQLGrammar = FALSE");
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsCoreSQLGrammar = FALSE");
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsExtendedSQLGrammar = FALSE");
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsANSI92EntryLevelSQL = TRUE");
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsANSI92IntermediateSQL = TRUE");
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsANSI92FullSQL = TRUE");
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsIntegrityEnhancementFacility = FALSE");
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsOuterJoins = TRUE");
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsFullOuterJoins = FALSE");
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsLimitedOuterJoins = FALSE");
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getSchemaTerm = ''");
        return "";
    }

    public String getProcedureTerm() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getProcedureTerm = ''");
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getCatalogTerm = ''");
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, isCatalogAtStart = FALSE");
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getCatalogSeparator = ''");
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSchemasInDataManipulation = FALSE");
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSchemasInProcedureCalls = FALSE");
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSchemasInTableDefinitions = FALSE");
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSchemasInIndexDefinitions = FALSE");
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSchemasInPrivilegeDefinitions = FALSE");
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsCatalogsInDataManipulation = FALSE");
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsCatalogsInProcedureCalls = FALSE");
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsCatalogsInTableDefinitions = FALSE");
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsCatalogsInIndexDefinitions = FALSE");
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsCatalogsInPrivilegeDefinitions = FALSE");
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsPositionedDelete = FALSE");
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsPositionedUpdate = FALSE");
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSelectForUpdate = FALSE");
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsStoredProcedures = FALSE");
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSubqueriesInComparisons = TRUE");
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSubqueriesInExists = TRUE");
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSubqueriesInIns = TRUE");
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSubqueriesInQuantifieds = TRUE");
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsCorrelatedSubqueries = TRUE");
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsUnion = FALSE");
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsUnionAll = FALSE");
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsOpenCursorsAcrossCommit = FALSE");
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsOpenCursorsAcrossRollback = FALSE");
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsOpenStatementsAcrossCommit = FALSE");
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsOpenStatementsAcrossRollback = FALSE");
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxBinaryLiteralLength = 0");
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxCharLiteralLength = 1");
        return 1;
    }

    public int getMaxColumnNameLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxColumnNameLength = 16");
        return 16;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxColumnsInGroupBy = 64");
        return 64;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxColumnsInIndex = 16");
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxColumnsInOrderBy = 64");
        return 64;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxColumnsInSelect = 256");
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxColumnsInTable = 512");
        return 512;
    }

    public int getMaxConnections() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxConnections = 256");
        return 256;
    }

    public int getMaxCursorNameLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxCursorNameLength = 16");
        return 16;
    }

    public int getMaxIndexLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxIndexLength = 256");
        return 256;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxSchemaNameLength = 256");
        return 256;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxProcedureNameLength = 256");
        return 256;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxCatalogNameLength = 256");
        return 256;
    }

    public int getMaxRowSize() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxRowSize = 2147483639");
        return 0x7FFFFFF7;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, doesMaxRowSizeIncludeBlobs = FALSE");
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxStatementLength = 2147483639");
        return 0x7FFFFFF7;
    }

    public int getMaxStatements() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxStatements = 256");
        return 256;
    }

    public int getMaxTableNameLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxTableNameLength = 16");
        return 16;
    }

    public int getMaxTablesInSelect() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxTablesInSelect = 256");
        return 256;
    }

    public int getMaxUserNameLength() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getMaxUserNameLength = 256");
        return 256;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getDefaultTransactionIsolation = /*TRANSACTION_NONE*/0");
        return 0;
    }

    public boolean supportsTransactions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsTransactions = FALSE");
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        s_logger.message("JDBC :  DatabaseMetaData, supportsTransactionIsolationLevel(" + n + ") = " + bl);
        return bl;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsDataDefinitionAndDataManipulationTransactions = FALSE");
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsDataManipulationTransactionsOnly = FALSE");
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, dataDefinitionCausesTransactionCommit = FALSE");
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, dataDefinitionIgnoredInTransactions = TRUE");
        return true;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getProcedures not supported");
        throw new SQLException("getProcedures():not supported");
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getProcedureColumns not supported");
        throw new SQLException("getProcedureColumns():not supported");
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n = 0;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase("TABLE")) {
                    ++n;
                } else if (stringArray[n2].equalsIgnoreCase("SYSTEM TABLE")) {
                    n += 2;
                } else if (stringArray[n2].equalsIgnoreCase("VIEW")) {
                    n += 4;
                }
                ++n2;
            }
        }
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        return baanJDBCStatement.executeQueryMeta("SELECT @@GetTables(" + string3 + "," + n + ")", true);
    }

    public ResultSet getSchemas() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getSchemas not supported");
        throw new SQLException("getSchemas():not supported");
    }

    public ResultSet getCatalogs() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getCatalogs not supported");
        throw new SQLException("getCatalogs():not supported");
    }

    public ResultSet getTableTypes() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getTableTypes not supported");
        throw new SQLException("getTableTypes():not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "";
        if (string4 != null & string4.length() > 0) {
            if (!(string3 != null & string3.length() > 0)) throw new SQLException("GetColumns, no table specified, table name pattern is mandatory.");
            string5 = string3 + "." + string4;
        } else {
            if (!(string3 != null & string3.length() > 0)) throw new SQLException("GetColumns, no table specified, table name pattern is mandatory.");
            string5 = string3;
        }
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        return baanJDBCStatement.executeQueryMeta("SELECT @@GetColumns(" + string5 + ")", true);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getColumnPrivileges not supported");
        throw new SQLException("getColumnPrivileges():not supported");
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getTablePrivileges not supported");
        throw new SQLException("getTablePrivileges():not supported");
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getBestRowIdentifier not supported");
        throw new SQLException("getBestRowIdentifier():not supported");
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getVersionColumns not supported");
        throw new SQLException("getVersionColumns():not supported");
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        return baanJDBCStatement.executeQueryMeta("SELECT @@GetPrimaryKeys(" + string3 + ")", true);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        return baanJDBCStatement.executeQueryMeta("SELECT @@GetImportedKeys(" + string3 + ")", true);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        return baanJDBCStatement.executeQueryMeta("SELECT @@GetExportedKeys(" + string3 + ")", true);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        return baanJDBCStatement.executeQueryMeta("SELECT @@GetCrossReference(" + string3 + "," + string6 + ")", true);
    }

    public ResultSet getTypeInfo() throws SQLException {
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        return baanJDBCStatement.executeQueryMeta("SELECT @@getTypeInfo()", true);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        BaanJDBCStatement baanJDBCStatement = (BaanJDBCStatement)this.m_statement;
        if (bl) {
            return baanJDBCStatement.executeQueryMeta("SELECT @@GetIndexInfo(" + string3 + ",1)", true);
        }
        return baanJDBCStatement.executeQueryMeta("SELECT @@GetIndexInfo(" + string3 + ",0)", true);
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        boolean bl = false;
        if (n == 1003) {
            bl = true;
        }
        s_logger.message("JDBC :  DatabaseMetaData, supportsResultSetType(" + n + ") = " + bl);
        return bl;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        boolean bl = false;
        if (n == 1003 && n2 == 1007) {
            bl = true;
        }
        s_logger.message("JDBC :  DatabaseMetaData, supportsResultSetConcurrency(" + n + "," + n2 + ") = " + bl);
        return bl;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, ownUpdatesAreVisible(" + n + ") = FALSE");
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, ownDeletesAreVisible(" + n + ") = FALSE");
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, ownInsertsAreVisible(" + n + ") = FALSE");
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, othersUpdatesAreVisible(" + n + ") = FALSE");
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, othersDeletesAreVisible(" + n + ") = FALSE");
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, othersInsertsAreVisible(" + n + ") = FALSE");
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, updatesAreDetected(" + n + ") = FALSE");
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, deletesAreDetected(" + n + ") = FALSE");
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, insertsAreDetected(" + n + ") = FALSE");
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsBatchUpdates = FALSE");
        return false;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getUDTs not supported");
        throw new SQLException("getUDTs():not supported");
    }

    public Connection getConnection() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getConnection = " + this.m_connection.toString());
        return this.m_connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsSavepoints = FALSE");
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsNamedParameters = FALSE");
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsMultipleOpenResults = FALSE");
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsGetGeneratedKeys = FALSE");
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getSuperTypes not supported");
        throw new SQLException("getSuperTypes():not supported");
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getSuperTables not supported");
        throw new SQLException("getSuperTables():not supported");
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, SQLException: getAttributes not supported");
        throw new SQLException("getAttributes():not supported");
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsResultSetHoldability(" + n + ") = FALSE");
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getResultSetHoldability = /*HOLD_CURSORS_OVER_COMMIT*/1");
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getDatabaseMajorVersion = 0");
        return 0;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getDatabaseMinorVersion = 0");
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getJDBCMajorVersion = 1");
        return 1;
    }

    public int getJDBCMinorVersion() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getJDBCMinorVersion = 0");
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, getSQLStateType = /*sqlStateSQL99*/2");
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, locatorsUpdateCopy = FALSE");
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        s_logger.message("JDBC :  DatabaseMetaData, supportsStatementPooling = FALSE");
        return false;
    }
}

